/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners;

import com.atlassian.confluence.api.model.accessmode.AccessMode;
import com.atlassian.confluence.event.events.cluster.ClusterAccessModeEvent;
import com.atlassian.confluence.schedule.ScheduledJobKey;
import com.atlassian.confluence.schedule.managers.ScheduledJobManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.spring.container.ContainerManager;
import com.comalatech.confluence.util.WorkflowsListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAccessModeEventListener
extends WorkflowsListener {
    private static final Logger log = LoggerFactory.getLogger(ClusterAccessModeEventListener.class);
    private final ScheduledJobManager scheduledJobManager = (ScheduledJobManager)ContainerManager.getComponent((String)"scheduledJobManager");
    public static final String[] WORKFLOWS_SCHEDULES_JOBS_KEYS = new String[]{"workflowsPersistentQueueJobConfig", "workflowExpirationJobConfig", "workflowStatsGatherJobConfig", "overdueReadAckJobConfig"};
    public static final String WORKFLOWS_SCHEDULE_JOBS_GROUP = "DEFAULT";

    public ClusterAccessModeEventListener(EventPublisher eventPublisher) {
        super(eventPublisher);
    }

    @EventListener
    public void onClusterAccessMode(ClusterAccessModeEvent event) {
        this.toggleWorkflowsScheduledJobs(event.getAccessMode());
    }

    private void toggleWorkflowsScheduledJobs(AccessMode accessMode) {
        for (String scheduledJobKey : WORKFLOWS_SCHEDULES_JOBS_KEYS) {
            Class<JobId> parameterClass;
            JobId parameter;
            if (GeneralUtil.getVersionNumber().startsWith(String.valueOf(8))) {
                parameter = JobId.of((String)scheduledJobKey);
                parameterClass = JobId.class;
            } else {
                parameter = new ScheduledJobKey(WORKFLOWS_SCHEDULE_JOBS_GROUP, scheduledJobKey);
                parameterClass = ScheduledJobKey.class;
            }
            this.invokeJobManager(accessMode.equals((Object)AccessMode.READ_ONLY) ? "disable" : "enable", parameterClass, parameter);
        }
    }

    private void invokeJobManager(String methodName, Class parameterClassType, Object parameter) {
        try {
            Method method = ScheduledJobManager.class.getMethod(methodName, parameterClassType);
            method.invoke((Object)this.scheduledJobManager, parameter);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error("Error detected while invoking enable/disable in scheduledJobManager", (Throwable)e);
        }
    }
}

