/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics;

import com.comalatech.confluence.analytics.StatField;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.esignatures.configuration.ESignaturesConfigurationManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class ESignatureStatsGatherer {
    private static final String E_SIGNATURES_CREDENTIALS_TYPE = "eSignatureCredentialsType";
    private final ESignaturesConfigurationManager eSignaturesConfigurationManager;
    private final WorkflowsFeatureManager workflowsFeatureManager;

    public ESignatureStatsGatherer(ESignaturesConfigurationManager eSignaturesConfigurationManager, WorkflowsFeatureManager workflowsFeatureManager) {
        this.eSignaturesConfigurationManager = eSignaturesConfigurationManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public List<StatField> getAnalyticsFields() {
        ArrayList<StatField> fields = new ArrayList<StatField>();
        this.when(this.workflowsFeatureManager, wm -> wm.isWorkflowsApp() || wm.isWorkflowsLiteApp(), () -> fields.add(this.obtainEsignatureCredentialTypeAsStatField()));
        return fields;
    }

    private StatField obtainEsignatureCredentialTypeAsStatField() {
        return new StatField(E_SIGNATURES_CREDENTIALS_TYPE, this.eSignaturesConfigurationManager::getESignaturesCredentials);
    }

    private <T> void when(T stat, Predicate<T> filter, Runnable action) {
        if (filter.test(stat)) {
            action.run();
        }
    }
}

