/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.actions;

import com.atlassian.confluence.compat.struts2.actioncontext.ActionContextCompatManager;
import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompatManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.pages.actions.ViewPageAction;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.RenderUtils;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.actions.ViewPageCookieUtils;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ReleasedViewPageAction
extends ViewPageAction
implements PageAware {
    private static final Logger log = LoggerFactory.getLogger(ReleasedViewPageAction.class);
    private static final String VIEW_PAGE_RESULT = "viewpage";
    public static final String NAME = "releaseview";
    private static final long serialVersionUID = 5061299016372036041L;
    private WebResourceManager webResourceManager;
    private WorkflowsFeatureManager workflowsFeatureManager;
    private ApprovalAccessor approvalAccessor;
    private String pageXHtmlContent;
    private ActionContextCompatManager actionContextCompatManager;
    private ServletActionContextCompatManager servletActionContextCompatManager;
    private StateService stateService;

    public boolean isPermitted() {
        return super.isPermitted() && !this.getPage().isDeleted();
    }

    private void initResources() {
        String pluginKey = this.workflowsFeatureManager.getPluginKey();
        this.webResourceManager.requireResource(pluginKey + ":workflow-published-view");
    }

    public String execute() throws Exception {
        AbstractPage page = this.getPage();
        ViewPageCookieUtils.setViewPublished(this.getPage(), this.servletActionContextCompatManager);
        int publishedVersion = 0;
        try {
            ApprovalCheck finalCheck = this.approvalAccessor.getFinalApprovalCheck(page);
            if (finalCheck == null) {
                throw new IllegalStateException("Final approval check version requested but none exists in page with id: " + page.getIdAsString());
            }
            this.getCurrentRequest().setAttribute("approvalId", (Object)Integer.toString(finalCheck.getId()));
            State publishedState = this.stateService.getPublishedState((ContentEntityObject)page);
            if (publishedState != null) {
                publishedVersion = publishedState.getContentVersion();
            }
        }
        catch (IllegalArgumentException iae) {
            if (log.isDebugEnabled()) {
                log.debug(iae.getMessage());
            }
            return VIEW_PAGE_RESULT;
        }
        catch (IllegalStateException ise) {
            if (log.isDebugEnabled()) {
                log.debug(ise.getMessage());
            }
            return VIEW_PAGE_RESULT;
        }
        if (log.isDebugEnabled()) {
            log.debug("rendering published view for page: " + page + "  published version: " + publishedVersion + " currentVersion: " + page.getVersion());
        }
        if (publishedVersion > 0 && publishedVersion != page.getVersion()) {
            AbstractPage oldPage = this.pageManager.getPageByVersion(page, publishedVersion);
            page = (AbstractPage)page.clone();
            if (oldPage == null) {
                if (log.isDebugEnabled()) {
                    log.debug("page: " + page + " published version: " + publishedVersion + " not found, probably deleted.");
                }
                String msg = this.getText("approvalsworkflow.approval.version.not.available", new Object[]{publishedVersion});
                page.setBodyAsString("<div class=\"aui-message error shadowed\">    <p class=\"title\">        <span class=\"aui-icon icon-error\">        </span>        <strong>" + msg + "        </strong>    </p></div>");
            } else {
                this.initResources();
                page.setBodyContent(oldPage.getBodyContent());
                page.setVersion(oldPage.getVersion());
            }
        }
        PageContext context = page.toPageContext();
        ApprovalCheck approvalCheck = this.approvalAccessor.getFinalApprovalCheck(page.getLatestVersion());
        context.addParam((Object)NAME, (Object)approvalCheck);
        this.actionContextCompatManager.setName(NAME);
        try {
            this.pageXHtmlContent = RenderUtils.renderContent((ContentEntityObject)page, (RenderContext)context);
        }
        catch (WorkflowException e) {
            if (log.isDebugEnabled()) {
                log.error("", (Throwable)e);
            } else {
                log.error(e.getMessage());
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return page.getType();
    }

    public String getViewPageActionUrl() {
        AbstractPage page = this.getPage();
        return "/pages/viewpage.action?pageId=" + page.getId();
    }

    @HtmlSafe
    public String getPageXHtmlContent() {
        return this.pageXHtmlContent;
    }

    public void setApprovalAccessor(ApprovalAccessor approvalAccessor) {
        this.approvalAccessor = approvalAccessor;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    public void setWorkflowsFeatureManager(WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public WebInterfaceContext getWebInterfaceContext() {
        DefaultWebInterfaceContext result = DefaultWebInterfaceContext.copyOf((WebInterfaceContext)super.getWebInterfaceContext());
        if (((Object)((Object)this)).getClass().equals(ReleasedViewPageAction.class)) {
            result.setParameter("releasedMode", (Object)Boolean.TRUE);
            result.setParameter("viewMode", (Object)Boolean.TRUE);
        }
        return result;
    }

    public void setActionContextCompatManager(@Qualifier(value="actionContextCompatManager") ActionContextCompatManager actionContextCompatManager) {
        this.actionContextCompatManager = actionContextCompatManager;
    }

    public void setServletActionContextCompatManager(@Qualifier(value="servletActionContextCompat") ServletActionContextCompatManager servletActionContextCompatManager) {
        this.servletActionContextCompatManager = servletActionContextCompatManager;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }

    public WebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }
}

