/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.rest.model;

import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQueryFilter;
import com.comalatech.workflow.model.document.activity.SortingOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class DocumentActivityReportRequest {
    private Long nextActivityTimestamp;
    private SortingOrder sorting;
    private InternalDocumentActivityQueryFilter filters;

    public InternalDocumentActivityQuery toQuery() {
        InternalDocumentActivityQuery query = new InternalDocumentActivityQuery();
        query.setLimit(100);
        query.setFilters(this.filters);
        query.setOrder(this.sorting != null ? this.sorting : SortingOrder.desc);
        query.setNextActivityTimestamp(this.nextActivityTimestamp);
        return query;
    }

    public static DocumentActivityReportRequestBuilder builder() {
        return new DocumentActivityReportRequestBuilder();
    }

    public Long getNextActivityTimestamp() {
        return this.nextActivityTimestamp;
    }

    public SortingOrder getSorting() {
        return this.sorting;
    }

    public InternalDocumentActivityQueryFilter getFilters() {
        return this.filters;
    }

    public void setNextActivityTimestamp(Long nextActivityTimestamp) {
        this.nextActivityTimestamp = nextActivityTimestamp;
    }

    public void setSorting(SortingOrder sorting) {
        this.sorting = sorting;
    }

    public void setFilters(InternalDocumentActivityQueryFilter filters) {
        this.filters = filters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentActivityReportRequest)) {
            return false;
        }
        DocumentActivityReportRequest other = (DocumentActivityReportRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$nextActivityTimestamp = this.getNextActivityTimestamp();
        Long other$nextActivityTimestamp = other.getNextActivityTimestamp();
        if (this$nextActivityTimestamp == null ? other$nextActivityTimestamp != null : !((Object)this$nextActivityTimestamp).equals(other$nextActivityTimestamp)) {
            return false;
        }
        SortingOrder this$sorting = this.getSorting();
        SortingOrder other$sorting = other.getSorting();
        if (this$sorting == null ? other$sorting != null : !((Object)((Object)this$sorting)).equals((Object)other$sorting)) {
            return false;
        }
        InternalDocumentActivityQueryFilter this$filters = this.getFilters();
        InternalDocumentActivityQueryFilter other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentActivityReportRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $nextActivityTimestamp = this.getNextActivityTimestamp();
        result = result * 59 + ($nextActivityTimestamp == null ? 43 : ((Object)$nextActivityTimestamp).hashCode());
        SortingOrder $sorting = this.getSorting();
        result = result * 59 + ($sorting == null ? 43 : ((Object)((Object)$sorting)).hashCode());
        InternalDocumentActivityQueryFilter $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    public String toString() {
        return "DocumentActivityReportRequest(nextActivityTimestamp=" + this.getNextActivityTimestamp() + ", sorting=" + (Object)((Object)this.getSorting()) + ", filters=" + this.getFilters() + ")";
    }

    public DocumentActivityReportRequest() {
    }

    public DocumentActivityReportRequest(Long nextActivityTimestamp, SortingOrder sorting, InternalDocumentActivityQueryFilter filters) {
        this.nextActivityTimestamp = nextActivityTimestamp;
        this.sorting = sorting;
        this.filters = filters;
    }

    public static class DocumentActivityReportRequestBuilder {
        private Long nextActivityTimestamp;
        private SortingOrder sorting;
        private InternalDocumentActivityQueryFilter filters;

        DocumentActivityReportRequestBuilder() {
        }

        public DocumentActivityReportRequestBuilder nextActivityTimestamp(Long nextActivityTimestamp) {
            this.nextActivityTimestamp = nextActivityTimestamp;
            return this;
        }

        public DocumentActivityReportRequestBuilder sorting(SortingOrder sorting) {
            this.sorting = sorting;
            return this;
        }

        public DocumentActivityReportRequestBuilder filters(InternalDocumentActivityQueryFilter filters) {
            this.filters = filters;
            return this;
        }

        public DocumentActivityReportRequest build() {
            return new DocumentActivityReportRequest(this.nextActivityTimestamp, this.sorting, this.filters);
        }

        public String toString() {
            return "DocumentActivityReportRequest.DocumentActivityReportRequestBuilder(nextActivityTimestamp=" + this.nextActivityTimestamp + ", sorting=" + (Object)((Object)this.sorting) + ", filters=" + this.filters + ")";
        }
    }
}

