/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.state;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.mapper.ContentMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateClosedMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateDueDateMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateInitMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateOverrideMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateTransitionMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.StateChangeReason;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatesMapper
extends ContentMapper {
    private static final Logger log = LoggerFactory.getLogger(StatesMapper.class);
    private final StateTransitionMapper stateTransitionMapper;
    private final StateOverrideMapper stateOverrideMapper;
    private final StateInitMapper stateInitMapper;
    private final StateDueDateMapper stateDueDateMapper;
    private final StateClosedMapper stateClosedMapper;

    public StatesMapper(PageManager pageManager, ActorUtils actorUtils) {
        super(pageManager);
        this.stateTransitionMapper = new StateTransitionMapper(actorUtils);
        this.stateOverrideMapper = new StateOverrideMapper(actorUtils);
        this.stateInitMapper = new StateInitMapper(actorUtils);
        this.stateDueDateMapper = new StateDueDateMapper(actorUtils);
        this.stateClosedMapper = new StateClosedMapper(actorUtils);
    }

    public List<Activity> buildStateTransitionActivities(PageState state, PageState previousState) throws Exception {
        List<DueDateRecord> dueDateHistory;
        ArrayList<Activity> activities = new ArrayList<Activity>();
        AbstractPage content = this.buildContent(state.getPage(), state.getVersion());
        if (state.getStateChangeReason() != null) {
            if (state.getStateChangeReason().equals((Object)StateChangeReason.ADMIN_OVERRIDE)) {
                activities.add(this.stateOverrideMapper.buildActivity(content, state, previousState));
            }
            if (state.getStateChangeReason().equals((Object)StateChangeReason.SPACE_INITIALISE)) {
                activities.add(this.stateInitMapper.buildActivity(content, state, previousState));
            }
        } else if (previousState != null) {
            activities.add(this.stateTransitionMapper.buildStateTransitionActivity(content, state, previousState));
            activities.add(this.stateClosedMapper.buildStateCloseActivity(content, state, previousState));
        } else {
            activities.add(this.stateTransitionMapper.buildInitialStateSetActivity(content, state));
        }
        if ((dueDateHistory = state.getDueDateHistory()) != null && !dueDateHistory.isEmpty()) {
            for (DueDateRecord dueDateRecord : dueDateHistory) {
                activities.add(this.stateDueDateMapper.buildActivity(content, state, dueDateRecord));
            }
        }
        return activities;
    }
}

