/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.adhoc.notification.SlackNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import org.springframework.beans.factory.annotation.Qualifier;

public class NotificationConfigAction
extends ConfluenceActionSupport {
    protected WorkflowNotificationConfigManager workflowNotificationConfigManager;
    private AdhocWorkflowsLicenseManager licenseManager;
    private WorkflowStatisticsManager workflowStatisticsManager;
    private WorkflowsFeatureManager workflowsFeatureManager;
    private DarkFeatureManager darkFeatureManager;
    private SlackNotificationConfigManager slackNotificationConfigManager;
    boolean taskAssigned;
    boolean taskPageWatcher;
    boolean approvalAssigned;
    boolean stateAssigned;
    boolean stateExpired;
    boolean readConfirmation;
    boolean slackNotification;
    private String confirm;
    private boolean editMode = true;
    private String docoUrlCDM = "https://apps.appf.re/cdmdc/doc/globalnotifications/56t706";
    private String docoUrlCDC = "https://apps.appf.re/cdcdc/doc/globaladminconfig/vA6VpE";
    private String docoUrlCDA = "https://apps.appf.re/cdadc/doc/adminguide/wW7YjI";

    public String view() {
        this.editMode = false;
        return "success";
    }

    public String edit() {
        return "success";
    }

    public String save() {
        if (this.confirm == null) {
            return "success";
        }
        this.workflowNotificationConfigManager.setNotificationConfig(NotificationType.APPROVAL_ASSIGNMENT, this.approvalAssigned);
        this.workflowNotificationConfigManager.setNotificationConfig(NotificationType.READ_CONFIRMATION, this.readConfirmation);
        if (this.workflowsFeatureManager.isApprovalsApp()) {
            return "success";
        }
        this.workflowNotificationConfigManager.setNotificationConfig(NotificationType.STATE_EXPIRED, this.stateExpired);
        if (this.workflowsFeatureManager.isWorkflowsLiteApp()) {
            return "success";
        }
        this.workflowNotificationConfigManager.setNotificationConfig(NotificationType.TASK_ASSIGNMENT, this.taskAssigned);
        this.workflowNotificationConfigManager.setNotificationConfig(NotificationType.TASK_PAGEWATCHER, this.taskPageWatcher);
        if (this.isSlackAppEnabled()) {
            this.workflowNotificationConfigManager.setNotificationConfig(NotificationType.SLACK_NOTIFICATION, this.slackNotification);
        }
        return "success";
    }

    public boolean getNotificationConfig(String notificationName) {
        return this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.getByName(notificationName));
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public boolean isSlackAppEnabled() {
        return this.slackNotificationConfigManager.isNextupPluginEnabled();
    }

    public boolean isSlackAppDisabled() {
        return !this.isSlackAppEnabled();
    }

    public String getDocoUrl(String app) {
        String url = this.docoUrlCDM;
        if (app.equalsIgnoreCase("cda")) {
            url = this.docoUrlCDA;
        } else if (app.equalsIgnoreCase("cdc")) {
            url = this.docoUrlCDC;
        }
        return url;
    }

    @ParameterSafe
    public void setApprovalAssigned(boolean approvalAssigned) {
        this.approvalAssigned = approvalAssigned;
    }

    @ParameterSafe
    public void setReadConfirmation(boolean readConfirmation) {
        this.readConfirmation = readConfirmation;
    }

    @ParameterSafe
    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    @ParameterSafe
    public void setStateExpired(boolean stateExpired) {
        this.stateExpired = stateExpired;
    }

    @ParameterSafe
    public void setTaskAssigned(boolean taskAssigned) {
        this.taskAssigned = taskAssigned;
    }

    @ParameterSafe
    public void setTaskPageWatcher(boolean taskPageWatcher) {
        this.taskPageWatcher = taskPageWatcher;
    }

    @ParameterSafe
    public void setSlackNotification(boolean slackNotification) {
        this.slackNotification = slackNotification;
    }

    public void setWorkflowNotificationConfigManager(WorkflowNotificationConfigManager workflowNotificationConfigManager) {
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
    }

    public void setWorkflowStatisticsManager(WorkflowStatisticsManager workflowStatisticsManager) {
        this.workflowStatisticsManager = workflowStatisticsManager;
    }

    public void setWorkflowsFeatureManager(WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public void setDarkFeatureManager(DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }

    public void setSlackNotificationConfigManager(SlackNotificationConfigManager slackNotificationConfigManager) {
        this.slackNotificationConfigManager = slackNotificationConfigManager;
    }

    public void setStateAssigned(boolean stateAssigned) {
        this.stateAssigned = stateAssigned;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public void setDocoUrlCDM(String docoUrlCDM) {
        this.docoUrlCDM = docoUrlCDM;
    }

    public void setDocoUrlCDC(String docoUrlCDC) {
        this.docoUrlCDC = docoUrlCDC;
    }

    public void setDocoUrlCDA(String docoUrlCDA) {
        this.docoUrlCDA = docoUrlCDA;
    }

    public WorkflowNotificationConfigManager getWorkflowNotificationConfigManager() {
        return this.workflowNotificationConfigManager;
    }

    public AdhocWorkflowsLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public WorkflowStatisticsManager getWorkflowStatisticsManager() {
        return this.workflowStatisticsManager;
    }

    public WorkflowsFeatureManager getWorkflowsFeatureManager() {
        return this.workflowsFeatureManager;
    }

    public DarkFeatureManager getDarkFeatureManager() {
        return this.darkFeatureManager;
    }

    public SlackNotificationConfigManager getSlackNotificationConfigManager() {
        return this.slackNotificationConfigManager;
    }

    public boolean isTaskAssigned() {
        return this.taskAssigned;
    }

    public boolean isTaskPageWatcher() {
        return this.taskPageWatcher;
    }

    public boolean isApprovalAssigned() {
        return this.approvalAssigned;
    }

    public boolean isStateAssigned() {
        return this.stateAssigned;
    }

    public boolean isStateExpired() {
        return this.stateExpired;
    }

    public boolean isReadConfirmation() {
        return this.readConfirmation;
    }

    public boolean isSlackNotification() {
        return this.slackNotification;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public String getDocoUrlCDM() {
        return this.docoUrlCDM;
    }

    public String getDocoUrlCDC() {
        return this.docoUrlCDC;
    }

    public String getDocoUrlCDA() {
        return this.docoUrlCDA;
    }
}

