/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.support.style;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import org.apache.commons.lang.StringUtils;

public class StyleAction
extends ConfluenceActionSupport
implements SpaceAware {
    private static final String CUSTOM_1 = "property.style.customcolour1";
    private static final String CUSTOM_2 = "property.style.customcolour2";
    private static final String CUSTOM_3 = "property.style.customcolour3";
    private static final String CUSTOM_4 = "property.style.customcolour4";
    private static final String CUSTOM_5 = "property.style.customcolour5";
    private static final String MENU_ITEM_SELECTED_BACKGROUND = "property.style.menuitemselectedbgcolour";
    private static final String MENU_ITEM_SELECTED_TEXT = "property.style.menuitemselectedtextcolour";
    private static final String MENU_ITEM_TEXT = "property.style.menuitemtextcolour";
    private static final String MENU_SELECTED_BACKGROUND = "property.style.menuselectedbgcolour";
    private static final String TOP_BAR_MENU_ITEM_TEXT = "property.style.topbarmenuitemtextcolour";
    private static final String TOP_BAR_MENU_SELECTED_BACKGROUND = "property.style.topbarmenuselectedbgcolour";
    private ColourScheme scheme;
    private ColourSchemeManager colourSchemeManager;
    private ThemeManager themeManager;
    private Theme theme;
    private Space space;

    public boolean isPermitted() {
        return true;
    }

    public String execute() {
        this.scheme = this.getActiveColourScheme(this.getSpaceKey());
        this.theme = this.getActiveTheme(this.getSpaceKey());
        return "success";
    }

    private Theme getActiveTheme(String spaceKey) {
        if (StringUtils.isNotEmpty((String)spaceKey)) {
            return this.themeManager.getSpaceTheme(spaceKey);
        }
        return this.themeManager.getGlobalTheme();
    }

    private ColourScheme getActiveColourScheme(String spaceKey) {
        if (StringUtils.isNotEmpty((String)spaceKey)) {
            return this.colourSchemeManager.getSpaceColourScheme(spaceKey);
        }
        return this.colourSchemeManager.getGlobalColourScheme();
    }

    public Theme getTheme() {
        return this.theme;
    }

    public String getTopBarColor() {
        return this.scheme.get("property.style.topbarcolour");
    }

    public String getBreadcrumbsTextColour() {
        return this.scheme.get("property.style.breadcrumbstextcolour");
    }

    public String getSpaceNameColor() {
        return this.scheme.get("property.style.spacenamecolour");
    }

    public String getHeadingTextColor() {
        return this.scheme.get("property.style.headingtextcolour");
    }

    public String getLinkColor() {
        return this.scheme.get("property.style.linkcolour");
    }

    public String getBorderColor() {
        return this.scheme.get("property.style.bordercolour");
    }

    public String getNavBackgroundColor() {
        return this.scheme.get("property.style.navbgcolour");
    }

    public String getNavTextColor() {
        return this.scheme.get("property.style.navtextcolour");
    }

    public String getNavSelectedBackgroundColor() {
        return this.scheme.get("property.style.navselectedbgcolour");
    }

    public String getNavSelectedTextColor() {
        return this.scheme.get("property.style.navselectedtextcolour");
    }

    public String getCustomColor1() {
        return this.scheme.get(CUSTOM_1);
    }

    public String getCustomColor2() {
        return this.scheme.get(CUSTOM_2);
    }

    public String getCustomColor3() {
        return this.scheme.get(CUSTOM_3);
    }

    public String getCustomColor4() {
        return this.scheme.get(CUSTOM_4);
    }

    public String getCustomColor5() {
        return this.scheme.get(CUSTOM_5);
    }

    public String getTopBarColour() {
        return this.scheme.get("property.style.topbarcolour");
    }

    public String getSpaceNameColour() {
        return this.scheme.get("property.style.spacenamecolour");
    }

    public String getHeadingTextColour() {
        return this.scheme.get("property.style.headingtextcolour");
    }

    public String getLinkColour() {
        return this.scheme.get("property.style.linkcolour");
    }

    public String getBorderColour() {
        return this.scheme.get("property.style.bordercolour");
    }

    public String getNavBackgroundColour() {
        return this.scheme.get("property.style.navbgcolour");
    }

    public String getNavTextColour() {
        return this.scheme.get("property.style.navtextcolour");
    }

    public String getNavSelectedBackgroundColour() {
        return this.scheme.get("property.style.navselectedbgcolour");
    }

    public String getNavSelectedTextColour() {
        return this.scheme.get("property.style.navselectedtextcolour");
    }

    public String getMenuItemSelectedBackgroundColor() {
        return this.scheme.get(MENU_ITEM_SELECTED_BACKGROUND);
    }

    public String getMenuItemSelctedTextColor() {
        return this.scheme.get(MENU_ITEM_SELECTED_TEXT);
    }

    public String getMenuItemTextColor() {
        return this.scheme.get(MENU_ITEM_TEXT);
    }

    public String getMenuSelectedBackgroundColor() {
        return this.scheme.get(MENU_SELECTED_BACKGROUND);
    }

    public String getTopBarMenuItemTextColor() {
        return this.scheme.get(TOP_BAR_MENU_ITEM_TEXT);
    }

    public String getTopBarMenuItemSelectedBackgroundColor() {
        return this.scheme.get(TOP_BAR_MENU_SELECTED_BACKGROUND);
    }

    public void setColourSchemeManager(ColourSchemeManager colourSchemeManager) {
        this.colourSchemeManager = colourSchemeManager;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public boolean isSpaceRequired() {
        return false;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public String getSpaceKey() {
        return this.space != null ? this.space.getKey() : null;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public Space getSpace() {
        return this.space;
    }
}

