/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.mappers;

import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflowreports.macro.parameter.StringListReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ApprovalsReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.model.StateReportParameters;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class StringListParameterMapper
implements ParameterMapper {
    @Override
    public ReportParameter map(ReportParameter parameter) {
        if (this.parameterCanBeMapped(parameter)) {
            StringReportParameterValue paramValue = (StringReportParameterValue)parameter.getValue();
            String fieldsValueExpression = (String)paramValue.getValue();
            String defaultFieldsValueExpression = (String)paramValue.getDefaultValue();
            List<String> fieldsValue = this.extractValuesFromExpression(fieldsValueExpression);
            List<String> defaultFieldsValue = this.extractValuesFromExpression(defaultFieldsValueExpression);
            parameter.setValue(new StringListReportParameterValue(fieldsValue, defaultFieldsValue));
        }
        return parameter;
    }

    @Override
    public boolean parameterCanBeMapped(ReportParameter parameter) {
        return parameter.getValue() instanceof StringReportParameterValue && (parameter.keyIs(StateReportParameters.SPACE.getKey()) || parameter.keyIs(StateReportParameters.LABEL.getKey()) || parameter.keyIs(StateReportParameters.STATE.getKey()) || parameter.keyIs(StateReportParameters.WORKFLOW.getKey()) || parameter.keyIs(ApprovalsReportParameters.SPACE.getKey()) || parameter.keyIs(ApprovalsReportParameters.LABEL.getKey()) || parameter.keyIs(ApprovalsReportParameters.STATE.getKey()) || parameter.keyIs(ApprovalsReportParameters.WORKFLOW.getKey()));
    }

    private List<String> extractValuesFromExpression(String commaSeparatedValues) {
        ArrayList<String> values = new ArrayList<String>();
        for (String value : MiscUtils.splitAndTrim(commaSeparatedValues)) {
            if (!StringUtils.isNotBlank((CharSequence)value.trim())) continue;
            values.add(value.trim());
        }
        return values;
    }
}

