/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhoc.dao.AdhocWorkflowDao;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.DefaultWorkflowService;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.InvalidWorkflow;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowDeletedEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowDisabledEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowEditedEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowEnabledEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowTemplateDeletedEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowTemplateEditedEventImpl;
import com.comalatech.confluence.workflow.events.admin.WorkflowTemplateDeletedEventImpl;
import com.comalatech.confluence.workflow.events.admin.WorkflowTemplateDisabledEventImpl;
import com.comalatech.confluence.workflow.events.admin.WorkflowTemplateEditedEventImpl;
import com.comalatech.confluence.workflow.events.admin.WorkflowTemplateEnabledEventImpl;
import com.comalatech.confluence.workflow.parser.WorkflowParser;
import com.comalatech.confluence.workflow.rest.model.RestRemoteWorkflow;
import com.comalatech.confluence.workflow.rest.model.RestRemoteWorkflowsRepository;
import com.comalatech.confluence.workflow.rest.model.mapper.RemoteWorkflowsRepositoryMapper;
import com.comalatech.confluence.workflowcontainer.SampleWorkflowStatusEnum;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.confluence.workflowcontainer.model.RemoteWorkflowsRepository;
import com.comalatech.confluence.workflowcontainer.remote.RemoteRepositoryProxy;
import com.comalatech.workflow.event.admin.WorkflowChangeEvent;
import com.comalatech.workflow.template.LinkedTemplateManager;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultWorkflowContainerManager
implements WorkflowContainerManager,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowContainerManager.class);
    private String DATASET_VERSION;
    private static final String VERSION_KEY = "com.comalatech.workflows.repository.version";
    private final ConfluenceBandanaContext context = new ConfluenceBandanaContext();
    private final SampleWorkflow[] WORKFLOWS = new SampleWorkflow[]{new SampleWorkflow("workflows/sample.simple.workflow", "1", true), new SampleWorkflow("workflows/sample.advanced.workflow", "1", false), new SampleWorkflow("workflows/sample.review.workflow", "1", false), new SampleWorkflow("workflows/sample.documentation.workflow", "1", false), new SampleWorkflow("workflows/sample.read.ack.workflow", "1", false)};
    private final SampleWorkflow[] WORKFLOWS_LITE = new SampleWorkflow[]{new SampleWorkflow("workflows_lite/sample.simple.workflow", "1", true), new SampleWorkflow("workflows_lite/sample.qms.workflow", "1", false), new SampleWorkflow("workflows_lite/sample.expiry.workflow", "1", false)};
    private static final String SAMPLE_WORKFLOW_STATUS_KEY = "com.comalatech.sample.workflow.status.";
    private final ArrayList<String> SAMPLE_WORKFLOW_NAMES = new ArrayList();
    private static final long COUNTCHECKPERIOD = 0x6DDD00L;
    private ApplicationContext applicationContext;
    private final RemoteRepositoryProxy remoteRepositoryProxy;
    private final PluginAccessor pluginAccessor;
    private final WorkflowParser workflowParser;
    private final AdhocWorkflowDao adhocWorkflowDao;
    private final InternalWorkflowParameterManager workflowParameterManager;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;
    private final BandanaManager bandanaManager;
    private final LinkedTemplateManager linkedTemplateManager;
    private final EventPublisher eventPublisher;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final WikiStyleRenderer wikiStyleRenderer;
    private AdhocWorkflowManager adhocWorkflowManager;
    private int cachedNumberOrWorkflows;
    private long nextRecalculateNumberOfWorkflows = 0L;
    Map<String, ProductionWorkflowsCache> productionWorkflowsCache;
    private boolean registeredSystemWorkflows = false;
    private final SpaceManager spaceManager;

    public DefaultWorkflowContainerManager(RemoteRepositoryProxy remoteRepositoryProxy, PluginAccessor pluginAccessor, WorkflowParser workflowParser, AdhocWorkflowDao adhocWorkflowDao, InternalWorkflowParameterManager workflowParameterManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager, BandanaManager bandanaManager, LinkedTemplateManager linkedTemplateManager, EventPublisher eventPublisher, WorkflowsFeatureManager workflowsFeatureManager, WikiStyleRenderer wikiStyleRenderer, SpaceManager spaceManager) {
        this.remoteRepositoryProxy = remoteRepositoryProxy;
        this.pluginAccessor = pluginAccessor;
        this.workflowParser = workflowParser;
        this.adhocWorkflowDao = adhocWorkflowDao;
        this.workflowParameterManager = workflowParameterManager;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
        this.bandanaManager = bandanaManager;
        this.linkedTemplateManager = linkedTemplateManager;
        this.eventPublisher = eventPublisher;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.spaceManager = spaceManager;
        this.productionWorkflowsCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(workflowAdvancedConfigurationManager.getCacheProductionWorkflows()).build();
    }

    public void afterPropertiesSet() throws Exception {
        this.adhocWorkflowManager = (AdhocWorkflowManager)this.applicationContext.getBean("adhocWorkflowManager", AdhocWorkflowManager.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public String loadSystemWorkflow(String workflowPath) throws WorkflowException {
        Plugin plugin = this.pluginAccessor.getEnabledPlugin(this.workflowsFeatureManager.getPluginKey());
        InputStream stream = plugin.getResourceAsStream(workflowPath);
        if (stream == null) {
            throw new WorkflowException(workflowPath + " not found");
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            StringBuffer workflow = new StringBuffer();
            while ((line = br.readLine()) != null) {
                workflow.append(line).append("\n");
            }
            return workflow.toString();
        }
        catch (Exception e) {
            throw new WorkflowException(e.getMessage());
        }
    }

    @Override
    public Workflow renderWorkflow(String workflowBody) throws WorkflowException {
        return this.workflowParser.parseWorkflow(workflowBody);
    }

    @Override
    public Workflow getSystemWorkflow(String path) throws WorkflowException {
        String rawWorkflow = this.loadSystemWorkflow(path);
        return this.renderWorkflow(rawWorkflow);
    }

    @Override
    public void registerSampleWorkflowsIfRequired() {
        if (!this.registeredSystemWorkflows) {
            if (this.workflowsFeatureManager.isWorkflowsApp()) {
                this.registerSampleWorkflows(this.WORKFLOWS);
            } else if (this.workflowsFeatureManager.isWorkflowsLiteApp()) {
                this.registerSampleWorkflows(this.WORKFLOWS_LITE);
            }
        }
    }

    @Override
    public List<InvalidWorkflow> getInvalidWorkflowTemplates(Space space) {
        String spaceKey = space != null ? space.getKey() : null;
        ArrayList<InvalidWorkflow> invalidWorkflows = new ArrayList<InvalidWorkflow>();
        List<String> globalTemplateNames = this.adhocWorkflowDao.getWorkflowTemplatesNames(spaceKey);
        for (String globalTemplateName : globalTemplateNames) {
            try {
                Workflow workflow = this.getWorkflowTemplate(null, globalTemplateName);
                if (workflow == null || !StringUtils.isNotBlank((CharSequence)workflow.getErrorMessage())) continue;
                throw new WorkflowException(workflow.getErrorMessage());
            }
            catch (WorkflowException e) {
                InvalidWorkflow invalidWorkflow = new InvalidWorkflow(this.adhocWorkflowDao.getWorkflowTemplateBody(null, globalTemplateName), globalTemplateName, e.getMessage());
                invalidWorkflows.add(invalidWorkflow);
            }
        }
        return invalidWorkflows;
    }

    @Override
    public List<Workflow> getWorkflowTemplates(Space space) {
        return this.getWorkflowTemplates(space, false);
    }

    @Override
    public List<Workflow> getAvailableWorkflowTemplates(Space space) {
        return this.getWorkflowTemplates(space, true);
    }

    private List<Workflow> sortWorkflows(List<Workflow> workflows) {
        workflows.sort((w, w1) -> {
            if (w.getKey() == null) {
                if (w1.getKey() != null) {
                    return 1;
                }
            } else {
                if (w1.getKey() == null) {
                    return -1;
                }
                return w.getKey().compareTo(w1.getKey());
            }
            if (w.getName() != null) {
                return w.getName().compareTo(w1.getName());
            }
            return 0;
        });
        return workflows;
    }

    private List<Workflow> getWorkflowTemplates(Space space, boolean onlyActive) {
        if (!this.registeredSystemWorkflows) {
            if (this.workflowsFeatureManager.isWorkflowsApp()) {
                this.registerSampleWorkflows(this.WORKFLOWS);
            } else {
                this.registerSampleWorkflows(this.WORKFLOWS_LITE);
            }
        }
        ArrayList<Workflow> workflows = new ArrayList<Workflow>();
        if (space != null && onlyActive) {
            List<String> globalTemplateNames = this.adhocWorkflowDao.getWorkflowTemplatesNames(null);
            for (String globalTemplateName : globalTemplateNames) {
                if (!this.adhocWorkflowDao.isGlobalWorkflowTemplateActive(space.getKey(), globalTemplateName)) continue;
                Workflow workflow = null;
                try {
                    workflow = this.getWorkflowTemplate(null, globalTemplateName);
                }
                catch (WorkflowException e) {
                    log.error("error loading global workflow " + e.getMessage());
                }
                if (workflow == null || !workflow.isActive()) continue;
                DefaultWorkflowService.createHandle(Workflow.WorkflowType.GLOBALE_TEMPLATE, workflow);
                workflows.add(workflow);
            }
        }
        String spaceKey = space != null ? space.getKey() : null;
        List<String> templateNames = this.adhocWorkflowDao.getWorkflowTemplatesNames(spaceKey);
        for (String templateName : templateNames) {
            Workflow workflow = null;
            try {
                workflow = this.getWorkflowTemplate(spaceKey, templateName);
            }
            catch (WorkflowException e) {
                log.error("error loading template " + templateName + " from space " + spaceKey, (Throwable)e);
            }
            if (workflow == null || onlyActive && !workflow.isActive()) continue;
            workflow.setHandle(DefaultWorkflowService.createHandle(Workflow.WorkflowType.GLOBALE_TEMPLATE, workflow));
            workflow.setContainerSpaceKey(spaceKey);
            workflows.add(workflow);
        }
        return this.sortWorkflows(workflows);
    }

    private void registerSampleWorkflows(SampleWorkflow[] workflows) {
        if (this.DATASET_VERSION == null) {
            this.DATASET_VERSION = this.workflowConfigurationManager.getConfiguration().getPluginVersion();
        }
        if (this.DATASET_VERSION.equals(this.getValue(VERSION_KEY))) {
            return;
        }
        try {
            for (SampleWorkflow sampleWorkflow : workflows) {
                try {
                    Workflow workflow = this.getSystemWorkflow(sampleWorkflow.path);
                    if (this.getWorkflowTemplate(null, workflow.getName()) == null || this.isSampleWorkflow(workflow.getName())) {
                        if (log.isInfoEnabled()) {
                            log.info("loading sample workflow " + workflow.getName());
                        }
                        this.SAMPLE_WORKFLOW_NAMES.add(workflow.getName());
                        SampleWorkflowStatusEnum prevStatus = this.getSampleWorkflowStatus(workflow);
                        if (prevStatus == SampleWorkflowStatusEnum.REMOVED) continue;
                        if (prevStatus == SampleWorkflowStatusEnum.ENABLED) {
                            workflow.setActive(true);
                        } else if (prevStatus == SampleWorkflowStatusEnum.DISABLED) {
                            workflow.setActive(false);
                        }
                        this.saveWorkflowTemplate(null, workflow, true, null);
                        if (!sampleWorkflow.defaultApprovalWorkflow) continue;
                        this.workflowConfigurationManager.setDefaultApprovalWorkflow(null, workflow.getName());
                        continue;
                    }
                    if (!log.isInfoEnabled()) continue;
                    log.info("workflow " + workflow.getName() + " has been modified, it will not be overriden");
                }
                catch (WorkflowException e) {
                    log.error(e.getMessage());
                }
            }
            this.registeredSystemWorkflows = true;
            this.setValue(VERSION_KEY, this.DATASET_VERSION);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public void setValue(String key, String value) {
        this.bandanaManager.setValue((BandanaContext)this.context, key, (Object)value);
    }

    private String getValue(String key) {
        return (String)this.bandanaManager.getValue((BandanaContext)this.context, key);
    }

    @Override
    public RemoteWorkflowsRepository getRemoteWorkflows(boolean forceLoad) {
        return this.remoteRepositoryProxy.getRemoteRepository(forceLoad);
    }

    @Override
    public RestRemoteWorkflowsRepository getRestRemoteWorkflows(boolean forceLoad, String categoryId, String spaceKey) {
        RemoteWorkflowsRepository remoteWorkflowsRepository = this.getRemoteWorkflows(forceLoad);
        RestRemoteWorkflowsRepository restRemoteWorkflowsRepository = new RemoteWorkflowsRepositoryMapper().toRest(remoteWorkflowsRepository.removeIfNotInCategory(categoryId));
        PageContext context = new PageContext(spaceKey);
        context.pushRenderMode(RenderMode.ALL);
        for (RestRemoteWorkflow restRemoteWorkflow : restRemoteWorkflowsRepository.getWorkflows()) {
            restRemoteWorkflow.setDescription(this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, restRemoteWorkflow.getDescription()));
            if (StringUtils.isNotBlank((CharSequence)spaceKey)) {
                restRemoteWorkflow.setImportedInPage(this.isWorkflowTemplateExists(spaceKey, restRemoteWorkflow.getName()));
                restRemoteWorkflow.setImportedInSpace(this.isProductionWorkflowExists(spaceKey, restRemoteWorkflow.getName()));
                continue;
            }
            restRemoteWorkflow.setImportedInGlobal(this.isWorkflowTemplateExists(spaceKey, restRemoteWorkflow.getName()));
        }
        return restRemoteWorkflowsRepository;
    }

    @Override
    public Workflow getWorkflowTemplate(String spaceKey, String name) throws WorkflowException {
        String rawWorkflow = this.adhocWorkflowDao.getWorkflowTemplateBody(spaceKey, name);
        return this.makeWorkflow(spaceKey, rawWorkflow);
    }

    private Workflow makeWorkflow(String spaceKey, String rawWorkflow) throws WorkflowException {
        if (!StringUtils.isNotBlank((CharSequence)rawWorkflow)) {
            return null;
        }
        Workflow workflow = this.renderWorkflow(rawWorkflow);
        workflow.setContainerSpaceKey(spaceKey);
        return workflow;
    }

    @Override
    public void saveWorkflowTemplate(String spaceKey, Workflow workflow, boolean sampleWorkflow, String oldWorkflowName) {
        Space space;
        if (workflow == null || workflow.getName() == null || workflow.getName().trim().length() == 0) {
            return;
        }
        if (this.workflowRenamed(workflow.getName(), oldWorkflowName)) {
            this.adhocWorkflowDao.setWorkflowTemplateBody(spaceKey, oldWorkflowName, null);
            this.adhocWorkflowDao.setProductionWorkflowActive(spaceKey, oldWorkflowName, false);
        }
        this.adhocWorkflowDao.setWorkflowTemplateBody(spaceKey, workflow.getName(), workflow.toMacro().toString());
        if (!StringUtils.isNotBlank((CharSequence)spaceKey)) {
            List<String> spaceKeys = this.linkedTemplateManager.getLinkedSpaces(workflow.getName());
            for (String linkedSpaceKey : spaceKeys) {
                this.workflowParameterManager.registerWorkflowParameters(linkedSpaceKey, workflow.getWorkflowParameters());
            }
        } else {
            this.workflowParameterManager.registerWorkflowParameters(spaceKey, workflow.getWorkflowParameters());
        }
        if (spaceKey == null) {
            this.adhocWorkflowDao.setGlobalSampleWorkflow(workflow.getName(), sampleWorkflow);
        }
        WorkflowChangeEvent event = (space = this.spaceManager.getSpace(spaceKey)) != null ? new SpaceWorkflowTemplateEditedEventImpl(space, workflow) : new WorkflowTemplateEditedEventImpl(workflow);
        this.eventPublisher.publish((Object)event);
    }

    @Override
    public void createWorkflowTemplateBackup(String spaceKey, String currentWorkflowName, String newWorkflowName) {
        String workflowMarkupBackup = this.adhocWorkflowDao.getWorkflowTemplateBackup(spaceKey, currentWorkflowName);
        if (StringUtils.isBlank((CharSequence)workflowMarkupBackup)) {
            String workflowMarkup = this.adhocWorkflowDao.getWorkflowTemplateBody(spaceKey, StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{currentWorkflowName}) ? currentWorkflowName : newWorkflowName);
            this.adhocWorkflowDao.setWorkflowTemplateBackup(spaceKey, newWorkflowName, workflowMarkup);
        }
    }

    @Override
    public Workflow restoreWorkflowBackup(@Nullable String spaceKey, String workflowName) throws WorkflowException {
        Workflow workflowBackup;
        String workflowMarkupBackup = this.adhocWorkflowDao.getWorkflowTemplateBackup(spaceKey, workflowName);
        workflowBackup.setType((workflowBackup = this.makeWorkflow(spaceKey, workflowMarkupBackup)).getType() != null ? workflowBackup.getType() : (spaceKey != null ? Workflow.WorkflowType.SPACE : Workflow.WorkflowType.GLOBALE_TEMPLATE));
        switch (workflowBackup.getType()) {
            case SPACE: {
                this.saveProductionWorkflow(spaceKey, workflowBackup, workflowBackup.getName());
                break;
            }
            case SPACE_TEMPLATE: 
            case GLOBALE_TEMPLATE: {
                this.saveWorkflowTemplate(spaceKey, workflowBackup, false, workflowBackup.getName());
            }
        }
        this.adhocWorkflowDao.removeWorkflowTemplateBackup(spaceKey, workflowName);
        return workflowBackup;
    }

    private boolean workflowRenamed(String currentWorkflowName, String oldWorkflowName) {
        if (oldWorkflowName == null) {
            return false;
        }
        return !currentWorkflowName.equals(oldWorkflowName);
    }

    @Override
    public boolean isSampleWorkflow(String name) {
        return this.adhocWorkflowDao.isGlobalSampleWorkflow(name);
    }

    @Override
    public boolean isWorkflowTemplateExists(String spaceKey, String templateName) {
        return this.adhocWorkflowDao.getWorkflowTemplateBody(spaceKey, templateName) != null;
    }

    @Override
    public boolean isProductionWorkflowExists(String spaceKey, String templateName) {
        return this.adhocWorkflowDao.getProductionWorkflowBody(spaceKey, templateName) != null;
    }

    @Override
    public void removeWorkflowTemplate(String spaceKey, String workflowName) {
        this.adhocWorkflowDao.removeWorkflowTemplate(spaceKey, workflowName);
        try {
            Space space = this.spaceManager.getSpace(spaceKey);
            Workflow workflow = this.getWorkflowTemplate(spaceKey, workflowName);
            if (workflow == null) {
                workflow = this.adhocWorkflowManager.parseWorkflowMarkup(String.format("{workflow:name=%s}{state:s1}{state}{workflow}", workflowName));
            }
            WorkflowChangeEvent event = space != null ? new SpaceWorkflowTemplateDeletedEventImpl(space, workflow) : new WorkflowTemplateDeletedEventImpl(workflow);
            this.eventPublisher.publish((Object)event);
        }
        catch (WorkflowException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void copyWorkflowTemplate(String spaceKey, Workflow workflow) {
        String newName = this.adhocWorkflowDao.createUniqueWorkflowTemplateName(spaceKey, workflow.getName());
        workflow.setName(newName);
        this.saveWorkflowTemplate(spaceKey, workflow, false, null);
    }

    @Override
    public void promoteWorkflowTemplate(String spaceKey, Workflow workflow) {
        String oldName = workflow.getName();
        String newName = this.adhocWorkflowDao.createUniqueWorkflowTemplateName(null, oldName);
        workflow.setName(newName);
        this.saveWorkflowTemplate(null, workflow, false, null);
        this.adhocWorkflowDao.setWorkflowTemplateBody(spaceKey, oldName, null);
    }

    @Override
    public boolean isGlobalWorkflowTemplateActive(String spaceKey, String globalWorkflowName) {
        return this.adhocWorkflowDao.isGlobalWorkflowTemplateActive(spaceKey, globalWorkflowName);
    }

    @Override
    public void setGlobalWorkflowActive(String spaceKey, String globalWorkflowName, boolean active) {
        try {
            Workflow workflow = this.getWorkflowTemplate(null, globalWorkflowName);
            workflow.setActive(active);
            this.adhocWorkflowDao.setWorkflowTemplateBody(spaceKey, workflow.getName(), workflow.toMacro().toString());
            this.adhocWorkflowDao.setGlobalWorkflowTemplateActive(spaceKey, globalWorkflowName, active);
            WorkflowChangeEvent event = active ? new WorkflowTemplateEnabledEventImpl(workflow) : new WorkflowTemplateDisabledEventImpl(workflow);
            this.eventPublisher.publish((Object)event);
        }
        catch (WorkflowException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Workflow getProductionWorkflow(String spaceKey, String name) throws WorkflowException {
        String rawWorkflow = this.adhocWorkflowDao.getProductionWorkflowBody(spaceKey, name);
        return this.makeWorkflow(spaceKey, rawWorkflow);
    }

    @Override
    public boolean hasProductionWorkflows(AbstractPage page) {
        if (page != null && page.getSpace() != null) {
            try {
                return this.workflowConfigurationManager.getConfiguration().isSpaceWorkflowsAllowed(page.getSpaceKey()) && (this.getCachedProductionWorkflows(page, null).size() != 0 || this.getLinkedWorkflowsAppliedToPage(page).size() != 0);
            }
            catch (WorkflowException e) {
                log.error("Error determining if the page has production workflows", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean hasProductionWorkflows(Space space) {
        if (space != null) {
            return this.workflowConfigurationManager.getConfiguration().isSpaceWorkflowsAllowed(space.getKey()) && (this.getCachedProductionWorkflows(space).size() != 0 || this.linkedTemplateManager.getLinkedTemplateNames(space.getKey()).size() != 0);
        }
        return false;
    }

    @Override
    public String getDefaultApprovalWorkflowMarkup(String spaceKey) {
        String name = this.workflowConfigurationManager.getDefaultApprovalWorkflow(spaceKey, true);
        String rawWorkflow = this.adhocWorkflowDao.getWorkflowTemplateBody(spaceKey, name);
        if (!StringUtils.isNotBlank((CharSequence)rawWorkflow)) {
            rawWorkflow = this.adhocWorkflowDao.getWorkflowTemplateBody(null, name);
        }
        return rawWorkflow;
    }

    @Override
    public void promoteProductionWorkflow(String spaceKey, Workflow workflow) {
        String oldName = workflow.getName();
        String newName = this.adhocWorkflowDao.createUniqueProductionWorkflowName(spaceKey, workflow.getName());
        workflow.setName(newName);
        workflow.setActive(false);
        if (this.adhocWorkflowDao.getWorkflowTemplateBody(spaceKey, oldName) != null) {
            this.adhocWorkflowDao.setWorkflowTemplateBody(spaceKey, oldName, null);
        }
        this.nextRecalculateNumberOfWorkflows = 0L;
        this.saveProductionWorkflow(spaceKey, workflow, null);
    }

    @Override
    public void saveProductionWorkflow(String spaceKey, Workflow workflow, String oldWorkflowName) {
        Space space = this.spaceManager.getSpace(spaceKey);
        WorkflowChangeEvent event = space != null ? new SpaceWorkflowEditedEventImpl(space, workflow) : new WorkflowTemplateEditedEventImpl(workflow);
        this.saveProductionWorkflow(spaceKey, workflow, oldWorkflowName, event);
    }

    private void saveProductionWorkflow(String spaceKey, Workflow workflow, String oldWorkflowName, WorkflowChangeEvent changeEvent) {
        this.nextRecalculateNumberOfWorkflows = 0L;
        workflow.setAdhoc(false);
        this.adhocWorkflowDao.setProductionWorkflowActive(spaceKey, workflow.getName(), workflow.isActive());
        if (this.workflowRenamed(workflow.getName(), oldWorkflowName)) {
            this.adhocWorkflowDao.removeProductionWorkflow(spaceKey, oldWorkflowName);
            this.nextRecalculateNumberOfWorkflows = 0L;
        }
        this.adhocWorkflowDao.setProductionWorkflowBody(spaceKey, workflow.getName(), workflow.toMacro().toString());
        this.workflowParameterManager.registerWorkflowParameters(spaceKey, workflow.getWorkflowParameters());
        this.publishWorkflowEvent(changeEvent);
    }

    @Override
    public void createProductionWorkflowBackup(String spaceKey, String currentWorkflowName, String newWorkflowName) {
        String workflowMarkup = this.adhocWorkflowDao.getProductionWorkflowBody(spaceKey, StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{currentWorkflowName}) ? currentWorkflowName : newWorkflowName);
        this.adhocWorkflowDao.setWorkflowTemplateBackup(spaceKey, newWorkflowName, workflowMarkup);
    }

    private void publishWorkflowEvent(WorkflowChangeEvent event) {
        this.eventPublisher.publish((Object)event);
    }

    @Override
    public void removeProductionWorkflow(String spaceKey, String name) {
        Space space = this.spaceManager.getSpace(spaceKey);
        try {
            Workflow workflow = this.getProductionWorkflow(spaceKey, name);
            WorkflowChangeEvent event = space != null ? new SpaceWorkflowDeletedEventImpl(space, workflow) : new WorkflowTemplateDeletedEventImpl(workflow);
            this.publishWorkflowEvent(event);
        }
        catch (WorkflowException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        this.adhocWorkflowDao.removeProductionWorkflow(spaceKey, name);
        this.nextRecalculateNumberOfWorkflows = 0L;
        this.productionWorkflowsCache.remove(spaceKey);
    }

    @Override
    public void copyProductionWorkflow(String spaceKey, Workflow workflow) {
        String newName = this.adhocWorkflowDao.createUniqueProductionWorkflowName(spaceKey, workflow.getName());
        workflow.setName(newName);
        workflow.setActive(false);
        this.saveProductionWorkflow(spaceKey, workflow, null);
    }

    @Override
    public void setActiveProductionWorkflow(String spaceKey, Workflow workflow, boolean active) {
        workflow.setActive(active);
        Space space = this.spaceManager.getSpace(spaceKey);
        WorkflowChangeEvent changeEvent = space != null ? (active ? new SpaceWorkflowEnabledEventImpl(space, workflow) : new SpaceWorkflowDisabledEventImpl(space, workflow)) : (active ? new WorkflowTemplateEnabledEventImpl(workflow) : new WorkflowTemplateDisabledEventImpl(workflow));
        this.saveProductionWorkflow(spaceKey, workflow, null, changeEvent);
    }

    @Override
    public List<Workflow> getAllProductionWorkflows(String spaceKey) {
        return this.loadProductionWorkflows(spaceKey, true);
    }

    @Override
    public int getCachedNumberOfProductionWorkflows() {
        long now = System.currentTimeMillis();
        if (this.nextRecalculateNumberOfWorkflows < now) {
            this.cachedNumberOrWorkflows = this.adhocWorkflowDao.getProductionWorkflowsCount();
            this.nextRecalculateNumberOfWorkflows = now + 0x6DDD00L;
        }
        return this.cachedNumberOrWorkflows;
    }

    protected List<Workflow> getCachedProductionWorkflows(Space space) {
        List<Workflow> workflows;
        int persistedVersion = this.adhocWorkflowDao.getProductionWorkflowsVersion(space.getKey());
        if (log.isDebugEnabled()) {
            log.debug("Space production Workflows request for space: " + space.getKey());
        }
        if (!this.productionWorkflowsCache.containsKey(space.getKey()) || persistedVersion != this.productionWorkflowsCache.get(space.getKey()).getLocalCacheKey()) {
            if (log.isDebugEnabled()) {
                if (this.productionWorkflowsCache.containsKey(space.getKey())) {
                    log.debug("Cached workflows for space '" + space.getKey() + "' outdated, retrieving space workflows from Bandana");
                } else {
                    log.debug("Value doesn't exist on space '" + space.getKey() + "' cache, retrieving space workflows from Bandana");
                }
            }
            workflows = this.loadProductionWorkflows(space.getKey(), false);
            this.productionWorkflowsCache.put(space.getKey(), new ProductionWorkflowsCache(persistedVersion, workflows));
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Space workflows for space '" + space.getKey() + "' will be retrieved from cache.");
            }
            workflows = this.productionWorkflowsCache.get(space.getKey()).getCachedSpaceWorkflows();
        }
        if (log.isDebugEnabled()) {
            log.debug("Space Workflows for space '" + space.getKey() + "': " + workflows.toString());
        }
        return Collections.unmodifiableList(workflows);
    }

    @Override
    public List<Workflow> getCachedProductionWorkflows(AbstractPage page, Label modifiedLabel) throws WorkflowException {
        ArrayList<Workflow> pageWorkflows = new ArrayList<Workflow>();
        for (Workflow workflow : this.getCachedProductionWorkflows(page.getSpace())) {
            if (!workflow.isActiveForAbstractPage(page) || !workflow.isActiveForLabels(page.getLabels()) && (modifiedLabel == null || !workflow.isActiveForLabel(modifiedLabel.getName()))) continue;
            pageWorkflows.add(workflow);
        }
        return pageWorkflows;
    }

    public List<Workflow> getLinkedWorkflowsAppliedToPage(AbstractPage page) {
        ArrayList<Workflow> appliedWorkflowsToPage = new ArrayList<Workflow>();
        List<com.comalatech.workflow.model.Workflow> templatesLinkedInTheSpace = this.linkedTemplateManager.getLinkedTemplates(page.getSpaceKey());
        for (com.comalatech.workflow.model.Workflow workflow : templatesLinkedInTheSpace) {
            Workflow workflowImp = (Workflow)workflow;
            if (!workflowImp.isActiveForAbstractPage(page) || !workflowImp.isActiveForLabels(page.getLabels())) continue;
            appliedWorkflowsToPage.add(workflowImp);
        }
        return appliedWorkflowsToPage;
    }

    private List<Workflow> loadProductionWorkflows(String spaceKey, boolean all) {
        ArrayList<Workflow> workflows = new ArrayList<Workflow>();
        List<String> keys = this.adhocWorkflowDao.getProductionWorkflowsKeys(spaceKey);
        for (String key : keys) {
            if (!all && !this.adhocWorkflowDao.isProductionWorkflowActive(spaceKey, key)) continue;
            try {
                Workflow workflow = this.getProductionWorkflow(spaceKey, key);
                if (workflow == null) continue;
                workflows.add(workflow);
            }
            catch (WorkflowException e) {
                log.error("error loading workflow " + spaceKey + ":" + key + ": " + e.getMessage());
            }
            catch (Exception e) {
                log.error("error loading workflow " + spaceKey + ":" + key, (Throwable)e);
            }
        }
        return workflows;
    }

    @Override
    public ArrayList<String> getSampleWorkflowNames() {
        return this.SAMPLE_WORKFLOW_NAMES;
    }

    @Override
    public void setSampleWorkflowEnabled(Workflow workflow) {
        this.bandanaManager.setValue((BandanaContext)this.context, this.makeSampleWorkflowsStatusKey(workflow.getName()), (Object)SampleWorkflowStatusEnum.ENABLED);
    }

    @Override
    public void setSampleWorkflowDisabled(Workflow workflow) {
        this.bandanaManager.setValue((BandanaContext)this.context, this.makeSampleWorkflowsStatusKey(workflow.getName()), (Object)SampleWorkflowStatusEnum.DISABLED);
    }

    @Override
    public void setSampleWorkflowRemoved(Workflow workflow) {
        this.bandanaManager.setValue((BandanaContext)this.context, this.makeSampleWorkflowsStatusKey(workflow.getName()), (Object)SampleWorkflowStatusEnum.REMOVED);
    }

    @Override
    public SampleWorkflowStatusEnum getSampleWorkflowStatus(Workflow workflow) {
        SampleWorkflowStatusEnum sampleWorkflowStatus = SampleWorkflowStatusEnum.ENABLED;
        Object value = this.bandanaManager.getValue((BandanaContext)this.context, this.makeSampleWorkflowsStatusKey(workflow.getName()));
        if (value instanceof SampleWorkflowStatusEnum) {
            sampleWorkflowStatus = (SampleWorkflowStatusEnum)((Object)value);
        }
        return sampleWorkflowStatus;
    }

    @Override
    public String getWorkflowMarkup(String workflowId) {
        return this.adhocWorkflowDao.getWorkflowTemplateBody(null, workflowId);
    }

    private String makeSampleWorkflowsStatusKey(String name) {
        String key = SAMPLE_WORKFLOW_STATUS_KEY + name.trim();
        if (key.length() > 100) {
            key = SAMPLE_WORKFLOW_STATUS_KEY + name.hashCode();
        }
        return key;
    }

    public static class ProductionWorkflowsCache {
        private final int localCacheKey;
        private final List<Workflow> workflowsList;

        public ProductionWorkflowsCache(int localCacheKey, List<Workflow> workflowNames) {
            this.localCacheKey = localCacheKey;
            this.workflowsList = workflowNames;
        }

        public int getLocalCacheKey() {
            return this.localCacheKey;
        }

        public List<Workflow> getCachedSpaceWorkflows() {
            return this.workflowsList;
        }
    }

    public static class SampleWorkflow {
        String path;
        String version;
        boolean defaultApprovalWorkflow;

        public SampleWorkflow(String path, String version, boolean defaultApprovalWorkflow) {
            this.path = path;
            this.version = version;
            this.defaultApprovalWorkflow = defaultApprovalWorkflow;
        }
    }
}

