/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rules.permission;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.permissions.DefaultWorkflowPermissionManager;
import com.comalatech.confluence.workflow.rules.permission.PermissionRule;
import com.comalatech.confluence.workflowcontainer.DefaultWorkflowContainerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanHavePageWorkflow
implements PermissionRule<AbstractPage> {
    private static final Logger log = LoggerFactory.getLogger(CanHavePageWorkflow.class);
    private DefaultWorkflowPermissionManager workflowPermissionManager;
    private AdhocWorkflowManager adhocWorkflowManager;
    private DefaultWorkflowContainerManager workflowContainerManager;
    private StateAccessor stateAccessor;

    public CanHavePageWorkflow(DefaultWorkflowPermissionManager workflowPermissionManager, AdhocWorkflowManager adhocWorkflowManager, DefaultWorkflowContainerManager workflowContainerManager, StateAccessor stateAccessor) {
        this.workflowPermissionManager = workflowPermissionManager;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.workflowContainerManager = workflowContainerManager;
        this.stateAccessor = stateAccessor;
    }

    @Override
    public boolean validate(AbstractPage page, boolean checkTaskable) {
        try {
            Workflow workflow;
            if (page == null || page.getSpaceKey() == null) {
                throw new IllegalArgumentException("Page value is null or space is null");
            }
            if (!this.workflowPermissionManager.canViewDrafts(page, AuthenticatedUserThreadLocal.get())) {
                throw new IllegalArgumentException("User cannot view drafs!");
            }
            if (!this.adhocWorkflowManager.isAdhocWorkflowAllowed(page)) {
                throw new IllegalArgumentException("Global Workflows are not Allowed!");
            }
            if (checkTaskable) {
                workflow = this.adhocWorkflowManager.getPageWorkflow(page);
                if (workflow == null) {
                    return true;
                }
            } else {
                if (this.workflowContainerManager.hasProductionWorkflows(page)) {
                    throw new IllegalArgumentException("Page has production Workflow!");
                }
                return true;
            }
            StatesContainer statesContainer = workflow.getStatesContainer();
            if (statesContainer == null) {
                return true;
            }
            if (statesContainer.size() == 0) {
                throw new IllegalArgumentException("Page states size is empty!");
            }
            if (!checkTaskable) {
                throw new IllegalArgumentException("Page checkTaskable is false");
            }
            PageState pageState = this.stateAccessor.getLatestState(page);
            if (pageState == null) {
                return statesContainer.getInitialState() == null || !statesContainer.getInitialState().isTaskable();
            }
            State state = statesContainer.getState(pageState);
            return state != null && state.isTaskable();
        }
        catch (WorkflowException | IllegalArgumentException ex) {
            log.debug("Error validation Can Have PageWorkflow VerificationRule! : {}", (Throwable)ex);
            return false;
        }
    }
}

