/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.expander;

import com.comalatech.confluence.workflow.rest.expander.Expander;
import com.comalatech.confluence.workflow.rest.expander.ExpanderRequest;
import com.comalatech.confluence.workflow.rest.expander.ExpanderResponse;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractExpandersHandler<R extends ExpanderRequest, T extends ExpanderResponse> {
    private static final String EXPANDER_SEPARATOR = ",";
    private final Map<String, Expander> expanders = new HashMap<String, Expander>();

    public void addExpander(Expander expander) {
        this.expanders.put(expander.getId(), expander);
    }

    public void expand(T response, R request, String ... ids) {
        HashSet<String> remainingIds = new HashSet<String>(this.expanders.keySet());
        for (String id : ids) {
            Expander expander = this.expanders.get(id);
            if (expander == null) continue;
            expander.expand(response, request);
            remainingIds.remove(id);
        }
        response.setExpand(StringUtils.join(remainingIds, (String)EXPANDER_SEPARATOR));
    }

    public String getIds() {
        return StringUtils.join(this.expanders.keySet(), (String)EXPANDER_SEPARATOR);
    }
}

