/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.mywork.notification;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.workflow.mywork.notification.AdhocNotification;
import com.comalatech.workflow.event.WorkflowEvent;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public abstract class AbstractAdhocNotification
implements AdhocNotification {
    protected WorkflowEvent event;
    protected AbstractPage page;
    protected ConfluenceUser currentUser;

    protected AbstractAdhocNotification(WorkflowEvent event) {
        this.event = event;
        this.page = (AbstractPage)event.getContent();
        this.currentUser = AuthenticatedUserThreadLocal.get();
    }

    @Override
    public String getItemUrlPath(String toUser) {
        return this.page.getUrlPath();
    }

    @Override
    public ObjectNode getMetadata(String toUser) {
        ObjectNode metadata = new ObjectMapper().createObjectNode();
        if (this.currentUser != null) {
            if (this.currentUser.getName().equals(toUser)) {
                metadata.put("user", ComalaI18nBean.getComalaI18nBean().getText("com.comalatech.confluence.workflow.mywork.you"));
            } else {
                metadata.put("user", this.currentUser.getFullName());
            }
            metadata.put("username", this.currentUser.getName());
        }
        metadata.put("page", this.page.getDisplayTitle());
        metadata.put("state", this.event.getState().getName());
        return metadata;
    }
}

