/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.PrefixQuery;
import com.atlassian.confluence.util.GeneralUtil;
import com.comalatech.confluence.workflow.model.WorkflowsSearch;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowsSearchConfluence8CompatibilityBuilder {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsSearchConfluence8CompatibilityBuilder.class);

    public static ISearch getContentSearch(SearchQuery query, SearchSort sort, int startOffset, int limit) {
        if (GeneralUtil.getVersionNumber().startsWith(String.valueOf(8))) {
            return WorkflowsSearchConfluence8CompatibilityBuilder._getContentSearch(query, sort, startOffset, limit);
        }
        return new WorkflowsSearch(query, sort, startOffset, limit);
    }

    private static ContentSearch _getContentSearch(SearchQuery query, SearchSort sort, int startOffset, int limit) {
        try {
            Class<?> contentSearchClass = Class.forName("com.atlassian.confluence.search.v2.ContentSearch");
            Class[] constructorTypes = new Class[]{SearchQuery.class, SearchSort.class, Integer.TYPE, Integer.TYPE};
            Constructor<?> contentSearchClassConstructor = contentSearchClass.getConstructor(constructorTypes);
            Object[] constructorArgs = new Object[]{query, sort, startOffset, limit};
            Object newContentSearchClassInstance = contentSearchClassConstructor.newInstance(constructorArgs);
            return (ContentSearch)newContentSearchClassInstance;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error("Error detected while building ContentSearch object through compatibility layer", (Throwable)e);
            return null;
        }
    }

    public static SearchQuery getFieldExistsQuery(String fieldName) {
        if (GeneralUtil.getVersionNumber().startsWith(String.valueOf(8))) {
            return WorkflowsSearchConfluence8CompatibilityBuilder._getFieldExistsQuery(fieldName);
        }
        return new PrefixQuery(fieldName, "");
    }

    private static SearchQuery _getFieldExistsQuery(String fieldName) {
        try {
            Class<?> searchQueryClass = Class.forName("com.atlassian.confluence.search.v2.query.FieldExistsQuery");
            Class[] constructorTypes = new Class[]{String.class};
            Constructor<?> searchQueryClassConstructor = searchQueryClass.getConstructor(constructorTypes);
            Object[] constructorArgs = new Object[]{fieldName};
            Object newSearchQueryClassInstance = searchQueryClassConstructor.newInstance(constructorArgs);
            return (SearchQuery)newSearchQueryClassInstance;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error("Error detected while building SearchQuery object through compatibility layer", (Throwable)e);
            return null;
        }
    }
}

