/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.include.imported;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.migration.LinkResolver;
import com.atlassian.confluence.content.render.xhtml.model.links.DefaultLink;
import com.atlassian.confluence.content.render.xhtml.model.links.NotPermittedLink;
import com.atlassian.confluence.content.render.xhtml.model.links.UnresolvedLink;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.BlogPostResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.BlogPostResourceIdentifierResolver;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.CannotResolveResourceIdentifierException;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.PageResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.PageResourceIdentifierResolver;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ResourceIdentifierResolver;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.links.linktypes.AbstractPageLink;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.UnpermittedLink;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.comalatech.confluence.workflow.macros.include.imported.PageProviderAdvancedMacros;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DefaultPageProviderAdvancedMacros
implements PageProviderAdvancedMacros {
    private final PermissionManager permissionManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final LinkResolver linkResolver;
    private final com.atlassian.renderer.links.LinkResolver legacyLinkResolver;

    public DefaultPageProviderAdvancedMacros(PermissionManager permissionManager, I18NBeanFactory i18NBeanFactory, com.atlassian.renderer.links.LinkResolver legacyLinkResolver) {
        this.permissionManager = permissionManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.linkResolver = (LinkResolver)ComponentLocator.getComponent(LinkResolver.class);
        this.legacyLinkResolver = legacyLinkResolver;
    }

    @Override
    public ContentEntityObject resolve(String location, ConversionContext context) throws NotAuthorizedException {
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        if (StringUtils.isEmpty((CharSequence)location)) {
            throw new IllegalArgumentException(i18NBean.getText("confluence.macros.advanced.include.error.no.location"));
        }
        com.atlassian.confluence.xhtml.api.Link link = this.linkResolver.resolve(location, context.getPageContext());
        if (link == null) {
            throw new IllegalArgumentException(i18NBean.getText("confluence.macros.advanced.include.error.no.link", (Object[])new String[]{location}));
        }
        return this.resolve(link, context);
    }

    @Override
    public ContentEntityObject resolve(com.atlassian.confluence.xhtml.api.Link link, ConversionContext context) {
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        String location = this.getLocation(link.getDestinationResourceIdentifier());
        if (link instanceof NotPermittedLink) {
            throw new NotAuthorizedException(i18NBean.getText("confluence.macros.advanced.include.error.user.not.authorized", (Object[])new String[]{AuthenticatedUserThreadLocal.getUsername(), location}));
        }
        if (link instanceof UnresolvedLink || !(link instanceof DefaultLink)) {
            return null;
        }
        AbstractPage page = this.resolveResourceIdentifier(link.getDestinationResourceIdentifier(), i18NBean, context);
        if (page == null) {
            throw new IllegalArgumentException(i18NBean.getText("confluence.macros.advanced.include.error.no.link", (Object[])new String[]{location}));
        }
        if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)page)) {
            throw new NotAuthorizedException(i18NBean.getText("confluence.macros.advanced.include.error.user.not.authorized", (Object[])new String[]{AuthenticatedUserThreadLocal.getUsername(), location}));
        }
        return page;
    }

    @Override
    public ContentEntityObject resolve(String location, RenderContext context) throws NotAuthorizedException {
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        if (StringUtils.isEmpty((CharSequence)location)) {
            throw new IllegalArgumentException(i18NBean.getText("confluence.macros.advanced.include.error.no.location"));
        }
        Link link = this.legacyLinkResolver.createLink(context, location);
        if (link == null) {
            throw new IllegalArgumentException(i18NBean.getText("confluence.macros.advanced.include.error.no.link", (Object[])new String[]{location}));
        }
        if (link instanceof UnpermittedLink) {
            throw new NotAuthorizedException(i18NBean.getText("confluence.macros.advanced.include.error.user.not.authorized", (Object[])new String[]{AuthenticatedUserThreadLocal.getUsername(), location}));
        }
        if (link instanceof com.atlassian.renderer.links.UnresolvedLink) {
            return null;
        }
        if (!(link instanceof AbstractPageLink)) {
            throw new IllegalArgumentException(i18NBean.getText("confluence.macros.advanced.include.error.invalid.content-entity"));
        }
        if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)((AbstractPageLink)link).getDestinationContent())) {
            throw new NotAuthorizedException(i18NBean.getText("confluence.macros.advanced.include.error.user.not.authorized", (Object[])new String[]{AuthenticatedUserThreadLocal.getUsername(), location}));
        }
        return ((AbstractPageLink)link).getDestinationContent();
    }

    private String getLocation(ResourceIdentifier resourceIdentifier) {
        if (resourceIdentifier == null) {
            return "";
        }
        if (resourceIdentifier instanceof BlogPostResourceIdentifier) {
            BlogPostResourceIdentifier blog = (BlogPostResourceIdentifier)resourceIdentifier;
            return (blog.getSpaceKey() != null ? blog.getSpaceKey() + ":" : "") + "/" + BlogPost.toDatePath((Date)blog.getPostingDay().getTime()) + "/" + blog.getTitle();
        }
        if (resourceIdentifier instanceof PageResourceIdentifier) {
            PageResourceIdentifier page = (PageResourceIdentifier)resourceIdentifier;
            return (page.getSpaceKey() != null ? page.getSpaceKey() + ":" : "") + page.getTitle();
        }
        return resourceIdentifier.toString();
    }

    private AbstractPage resolveResourceIdentifier(ResourceIdentifier destination, I18NBean i18NBean, ConversionContext context) {
        if (destination == null) {
            return (AbstractPage)context.getEntity();
        }
        if (!(destination instanceof PageResourceIdentifier) && !(destination instanceof BlogPostResourceIdentifier)) {
            throw new IllegalArgumentException(i18NBean.getText("confluence.macros.advanced.include.error.invalid.content-entity"));
        }
        try {
            if (destination instanceof BlogPostResourceIdentifier) {
                BlogPostResourceIdentifierResolver blogPostResourceIdentifierResolver = (BlogPostResourceIdentifierResolver)ComponentLocator.getComponent(ResourceIdentifierResolver.class, (String)"blogPostResourceIdentifierResolver");
                return blogPostResourceIdentifierResolver.resolve((BlogPostResourceIdentifier)destination, context);
            }
            PageResourceIdentifierResolver pageResourceIdentifierResolver = (PageResourceIdentifierResolver)ComponentLocator.getComponent(ResourceIdentifierResolver.class, (String)"pageResourceIdentifierResolver");
            return pageResourceIdentifierResolver.resolve((PageResourceIdentifier)destination, context);
        }
        catch (CannotResolveResourceIdentifierException e) {
            return null;
        }
    }
}

