/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.macros.actions.IpcMacro;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ApprovePageMacro
extends IpcMacro {
    public static final String PARAM_COMMENT = "comment";
    protected ApprovalManager approvalManager;
    protected String childApprovedState;

    @Override
    protected String getName() {
        return "approve-page";
    }

    protected void approve(String approvalName, String comment, AbstractPage page, boolean approved) throws WorkflowException {
        this.approvalManager.approvePage(page, approvalName, approved, comment, AuthenticatedUserThreadLocal.get(), true, false, false, false);
    }

    protected boolean getApproveFlag() {
        return true;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        this.checkRunMode(renderContext);
        try {
            String approvalName = null;
            String comment = (String)parameters.get(PARAM_COMMENT);
            if ((this.inWorkflowAction(renderContext) || this.inWorkflowMacro(renderContext)) && !StringUtils.isNotBlank((CharSequence)(approvalName = (String)parameters.get("0")))) {
                throw new MacroException("approvalName not provided");
            }
            AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
            boolean approved = this.getApproveFlag();
            ValueStore valueStore = this.getValueStore(renderContext);
            if (comment != null) {
                comment = valueStore.replaceReferences(comment);
            }
            this.approve(approvalName, comment, page, approved);
        }
        catch (WorkflowException e) {
            this.logMessage(renderContext, e);
        }
        return "";
    }

    private boolean inWorkflowMacro(RenderContext renderContext) {
        return renderContext.getParam((Object)"workflow") != null;
    }

    public void setApprovalManager(ApprovalManager approvalManager) {
        this.approvalManager = approvalManager;
    }
}

