/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.filters;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePreviewFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(FilePreviewFilter.class);
    private final AttachmentManager attachmentManager;
    private final PageManager pageManager;
    private final WorkflowAccessor workflowAccessor;
    public static final Pattern PUBLISHED_VIEW_URL_PATTERN = Pattern.compile(".*display/public.*|.*releaseview\\.action.*");
    public static final Pattern HIDDEN_ATTACHMENT_REQUEST_URL_PATTERN = Pattern.compile(".*/rest/files/1.0/files/content/\\d+$");
    public static final Pattern ATTACHMENT_REQUEST_URL_PATTERN_VERSIONS = Pattern.compile(".*/rest/files/1.0/files/.*/versions.*");

    public FilePreviewFilter(AttachmentManager attachmentManager, PageManager pageManager, WorkflowAccessor workflowAccessor) {
        this.attachmentManager = attachmentManager;
        this.pageManager = pageManager;
        this.workflowAccessor = workflowAccessor;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        boolean doFilter = true;
        if (this.isPublishedView(req)) {
            doFilter = ATTACHMENT_REQUEST_URL_PATTERN_VERSIONS.matcher(req.getRequestURI()).matches() ? !this.isAttachmentDefinedInPageWithFinalState(this.getAttachmentFromAttachmentVersionsRequest(req)) : false;
        }
        if (doFilter) {
            chain.doFilter(request, response);
        } else {
            this.emptyResults(req, resp);
        }
    }

    private boolean isPublishedView(HttpServletRequest request) {
        String referer = request.getHeader("referer");
        String requestUri = request.getRequestURI();
        return referer != null && PUBLISHED_VIEW_URL_PATTERN.matcher(referer).matches() && !HIDDEN_ATTACHMENT_REQUEST_URL_PATTERN.matcher(requestUri).matches();
    }

    private Attachment getAttachmentFromAttachmentVersionsRequest(HttpServletRequest request) {
        Attachment attachment = null;
        String requestURI = request.getRequestURI();
        Matcher matcher = Pattern.compile(Pattern.quote("1.0/files/") + "(.*?)" + Pattern.quote("/versions")).matcher(requestURI);
        if (matcher.find()) {
            String stringAttachmentId = matcher.group(1);
            int attachmentId = Integer.parseInt(stringAttachmentId);
            attachment = attachmentId != 0 ? this.attachmentManager.getAttachment((long)attachmentId) : null;
        }
        return attachment;
    }

    private boolean isAttachmentDefinedInPageWithFinalState(Attachment attachment) {
        AbstractPage page;
        boolean isAttachmentDefinedInPageWithFinalState = false;
        if (attachment != null && this.workflowAccessor.hasWorkflowsOrApprovals((ContentEntityObject)(page = this.pageManager.getAbstractPage(attachment.getContainer().getId())))) {
            try {
                PageWorkflows pageWorkflows = this.workflowAccessor.getWorkflows(page);
                isAttachmentDefinedInPageWithFinalState = pageWorkflows.getFirstWorkflowWithStates().hasFinalState();
            }
            catch (WorkflowException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return isAttachmentDefinedInPageWithFinalState;
    }

    private void emptyResults(HttpServletRequest request, HttpServletResponse response) {
        if (log.isDebugEnabled()) {
            log.debug("Blocking file preview request on published page: " + request.getRequestURL() + "     query params: " + request.getQueryString());
        }
        response.setStatus(200);
        String emptyResults = "{\"results\":[]}";
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        writer.write("{\"results\":[]}");
        writer.flush();
        writer.close();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

