/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.comalatech.confluence.readack.model.ReadAck;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.tasks.model.PageTasks;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.PageWorkflowParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class PageWorkflows {
    private List<Workflow> workflows;
    private List<Workflow> allWorkflows;
    private AbstractPage page;
    private StatesContainer statesContainer;
    private ReadAck readAck;
    private ValueStore valueStore;
    private PageWorkflowParameters parameters;
    private boolean strictTasks;
    private boolean pageWorkflow;

    public PageWorkflows(ValueStore valueStore, List<Workflow> workflows, boolean pageWorkflow) {
        this.workflows = workflows != null ? workflows : new ArrayList();
        this.pageWorkflow = pageWorkflow;
        this.allWorkflows = new ArrayList<Workflow>(workflows);
        this.loadStates();
        this.loadReadAck();
        this.setValueStore(valueStore);
        PageState pageState = this.valueStore.getPageState();
        if (pageState != null) {
            this.valueStore.setPageState(this.getEnrichedPageState(pageState));
        }
    }

    public void setValueStore(ValueStore valueStore) {
        this.page = valueStore.getPage();
        this.valueStore = valueStore;
        valueStore.setPageWorkflows(this);
    }

    public Map getProperties() {
        HashMap<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>();
        for (Workflow workflow : this.workflows) {
            if (workflow.getProperties() == null) continue;
            properties.putAll(workflow.getProperties());
        }
        return properties;
    }

    private PageState getPageState() {
        PageState pageState = this.getValueStore().getPageState();
        if (pageState == null && this.statesContainer != null && this.statesContainer.getInitialState() != null) {
            return new PageState(this.statesContainer.getInitialState().getName());
        }
        return pageState;
    }

    public PageState getEnrichedPageState(PageState pageState) {
        State stateObject;
        if (pageState != null && this.statesContainer != null && (stateObject = this.statesContainer.getState(pageState)) != null) {
            pageState.setTaskable(stateObject.isTaskable());
            pageState.setAssignable(stateObject.isAssignable());
            if (pageState.getDescription() == null && stateObject.getDescription() != null) {
                pageState.setDescription(stateObject.getDescription());
            }
            pageState.setPublished(stateObject.isFinalState());
            pageState.setVersionsCompleted(stateObject.isVersionsCompleted());
            pageState.setChangeDueDate(stateObject.isChangeDueDate());
            pageState.setColour(stateObject.getColour());
        }
        return pageState;
    }

    public PageWorkflowParameters getPageWorkflowParameters() {
        return this.parameters;
    }

    public void setPageWorkflowParameters(PageWorkflowParameters pageWorkflowParameters) {
        this.parameters = pageWorkflowParameters;
    }

    public PageTasks getTasks() {
        return this.valueStore.getPageState().getPageTasks();
    }

    public Map getProperties(String propertiesKey) {
        return (Map)this.getProperties().get(Workflow.makePropertiesKey(propertiesKey));
    }

    public String getProperty(String propertiesKey, String propertyName) {
        Map properties = this.getProperties(propertiesKey);
        if (properties == null) {
            return null;
        }
        return (String)properties.get(propertyName);
    }

    public String getCssUrl() {
        for (Workflow workflow : this.workflows) {
            String cssUrl = workflow.getCssUrl();
            if (cssUrl == null) continue;
            return cssUrl;
        }
        return null;
    }

    public String getPageHeaderTemplate() {
        for (Workflow workflow : this.workflows) {
            String template = workflow.getPageHeaderTemplate();
            if (template == null) continue;
            return template;
        }
        return null;
    }

    public String getPageFooterTemplate() {
        for (Workflow workflow : this.workflows) {
            String template = workflow.getPageFooterTemplate();
            if (template == null) continue;
            return template;
        }
        return null;
    }

    public String getPageHeaderBody(boolean readOnly) {
        for (Workflow workflow : this.workflows) {
            if (workflow.getWorkflowPagePageHeader() == null) continue;
            return workflow.getWorkflowPagePageHeader().getBody(readOnly);
        }
        return null;
    }

    public String getPageFooterBody(boolean readOnly) {
        for (Workflow workflow : this.workflows) {
            if (workflow.getWorkflowPagePageFooter() == null) continue;
            return workflow.getWorkflowPagePageFooter().getBody(readOnly);
        }
        return null;
    }

    public List<String> getWorkflowAdminUsers() {
        TreeSet<String> adminUsers = new TreeSet<String>();
        for (Workflow workflow : this.workflows) {
            String workflowAdminUserNames = workflow.getAdminUserNames();
            if (workflowAdminUserNames == null) continue;
            adminUsers.addAll(Arrays.asList(workflowAdminUserNames.split("[\\s,]")));
        }
        return new ArrayList<String>(adminUsers);
    }

    public String getInitMacros() {
        StringBuffer sb = new StringBuffer();
        for (Workflow workflow : this.workflows) {
            String init = workflow.getInitMacro();
            if (init == null) continue;
            sb.append(init);
        }
        return sb.toString();
    }

    public StatesContainer getStatesContainer() {
        return this.statesContainer;
    }

    public ReadAck getReadAck() {
        return this.readAck;
    }

    public boolean isStandAloneReadAck() {
        return this.getReadAck() != null && this.getStatesContainer() == null;
    }

    public State getState(String name) {
        return this.statesContainer != null ? this.statesContainer.getState(name) : null;
    }

    public State getInitialState() {
        return this.statesContainer != null ? this.statesContainer.getInitialState() : null;
    }

    private void loadStates() {
        for (Workflow workflow : this.workflows) {
            StatesContainer workflowStatesContainer = workflow.getStatesContainer();
            if (workflowStatesContainer == null || workflowStatesContainer.size() <= 0) continue;
            this.statesContainer = workflowStatesContainer;
            break;
        }
    }

    private void loadReadAck() {
        for (Workflow workflow : this.workflows) {
            if (workflow.getReadAck() != null) {
                this.readAck = workflow.getReadAck();
                break;
            }
            if (workflow.getStatesContainer() == null || workflow.getStatesContainer().getFinalState() == null || workflow.getStatesContainer().getFinalState().getReadAck() == null) continue;
            this.readAck = workflow.getStatesContainer().getFinalState().getReadAck();
            break;
        }
    }

    public boolean isLabelSticky(Label label) {
        for (Workflow workflow : this.workflows) {
            if (!workflow.isLabelSticky(label)) continue;
            return true;
        }
        return false;
    }

    public boolean isAdhoc() {
        for (Workflow workflow : this.workflows) {
            if (!workflow.isAdhoc()) continue;
            return true;
        }
        return false;
    }

    public boolean isShowPageStatus(boolean userCanEdit) {
        for (Workflow workflow : this.workflows) {
            if (workflow.getHideStatus() == 1) {
                return false;
            }
            if (workflow.getHideStatus() != 2 || userCanEdit) continue;
            return false;
        }
        return true;
    }

    public boolean isHidStates() {
        for (Workflow workflow : this.workflows) {
            if (!workflow.isHideStates()) continue;
            return true;
        }
        return false;
    }

    public boolean isDisplayProgressTracker() {
        for (Workflow workflow : this.workflows) {
            if (!workflow.isDisplayProgressTracker()) continue;
            return true;
        }
        return false;
    }

    public boolean isInPagePublishing() {
        return this.statesContainer != null ? this.statesContainer.getFinalState() != null : false;
    }

    public void addDummyWorkflow(Workflow workflow) {
        if (workflow != null && workflow.getApprovals().size() > 0) {
            this.allWorkflows.add(workflow);
            Collections.sort(this.allWorkflows);
        }
    }

    public boolean isEmpty() {
        return this.allWorkflows.size() == 0;
    }

    public List<Approval> getApprovals(PageState pageState) {
        ArrayList<Approval> approvals = new ArrayList<Approval>();
        approvals.addAll(this.getStateApprovals(pageState));
        for (Workflow workflow : this.allWorkflows) {
            approvals.addAll(workflow.getApprovals(this.page));
        }
        List pageLabels = null;
        Iterator iterator = approvals.iterator();
        while (iterator.hasNext()) {
            Approval approval = (Approval)iterator.next();
            if (approval.getLabel() == null) continue;
            if (pageLabels == null) {
                pageLabels = this.page.getLabels();
            }
            if (pageLabels.contains(approval.getLabel())) continue;
            iterator.remove();
        }
        Collections.sort(approvals, new Comparator<Approval>(){

            @Override
            public int compare(Approval approval, Approval approval1) {
                return approval.getName().compareTo(approval1.getName());
            }
        });
        return approvals;
    }

    private List<Approval> getStateApprovals(PageState pageState) {
        State state;
        if (this.statesContainer != null && (state = pageState != null ? this.statesContainer.getState(pageState.getState()) : this.statesContainer.getInitialState()) != null) {
            return state.getApprovals(this.page);
        }
        return Approval.EMPTY_LIST;
    }

    public boolean hasTriggers() {
        for (Workflow workflow : this.workflows) {
            if (!workflow.hasTriggers()) continue;
            return true;
        }
        return false;
    }

    public List<Workflow> getWorkflows() {
        return this.workflows;
    }

    public boolean isUpdateStatus() {
        for (Workflow workflow : this.workflows) {
            if (!workflow.isUpdateStatus()) continue;
            return true;
        }
        return false;
    }

    public String[] getWorkflowIds() {
        String[] ids = new String[this.workflows.size()];
        int i = 0;
        for (Workflow workflow : this.workflows) {
            ids[i++] = Long.toString(workflow.getPageId());
        }
        return ids;
    }

    public void setStateModel(PageState pageState) {
        State state = this.getState(pageState.getState());
        if (state == null) {
            return;
        }
        if (state.isFinalState()) {
            pageState.setStateMode(PageState.StateMode.FINAL);
        } else if (this.statesContainer != null && this.statesContainer.getFinalState() != null) {
            pageState.setStateMode(PageState.StateMode.NOT_FINAL);
        } else {
            pageState.setStateMode(PageState.StateMode.DEFAULT);
        }
    }

    public Approval getApproval(String approvalName) {
        List<Approval> approvals = this.getApprovals(this.valueStore.getPageState());
        int ix = Collections.binarySearch(approvals, approvalName, (o1, o2) -> ((Approval)o1).getName().compareTo((String)o2));
        if (ix < 0) {
            return null;
        }
        return approvals.get(ix);
    }

    public boolean isRequiresFinalApproval() {
        if (this.statesContainer != null && this.statesContainer.isRequiresFinalApproval()) {
            return true;
        }
        for (Approval approval : this.getApprovals(null)) {
            if (!approval.isFinalApproval()) continue;
            return true;
        }
        return false;
    }

    public AbstractPage getPage() {
        return this.page;
    }

    public ValueStore getValueStore() {
        return this.valueStore;
    }

    public MacroDefinition getStateAsStatusMacro() {
        PageState pageState = this.getPageState();
        State state = this.getState(pageState.getName());
        if (state == null) {
            return this.statusMacro(pageState.getName(), null);
        }
        if (state.isFinalState()) {
            return this.statusMacro(pageState.getName(), "Green");
        }
        if (this.getStatesContainer().isRequiresFinalApproval()) {
            return this.statusMacro(pageState.getName(), "Yellow");
        }
        return this.statusMacro(pageState.getName(), "Blue");
    }

    private MacroDefinition statusMacro(String name, String colour) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("title", name);
        if (colour != null) {
            parameters.put("color", colour);
        }
        MacroDefinition macroDef = MacroDefinition.builder((String)"status").build();
        macroDef.setParameters(parameters);
        return macroDef;
    }

    public String toString() {
        return "PageWorkflows{workflows=" + this.workflows + ", valueStore=" + this.valueStore + '}';
    }

    public boolean isStrictTasks() {
        return this.strictTasks;
    }

    public void setStrictTasks(boolean strictTasks) {
        this.strictTasks = strictTasks;
    }

    public boolean isPageWorkflow() {
        return this.pageWorkflow;
    }

    public Workflow getFirstWorkflowWithStates() {
        for (Workflow workflow : this.workflows) {
            if (workflow.getStatesContainer() == null || workflow.getStatesContainer().getStates().size() <= 0) continue;
            return workflow;
        }
        return null;
    }

    public boolean isPageReadConfirmation() {
        for (Workflow workflow : this.workflows) {
            if (!workflow.isPageReadConfirmation()) continue;
            return true;
        }
        return false;
    }
}

