/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.model;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

public interface ReadAckStatusType {

    public static class PageStatusTypeAdapter
    extends XmlAdapter<String, PageStatusType> {
        public String marshal(PageStatusType type) {
            return type.toString();
        }

        public PageStatusType unmarshal(String val) {
            return PageStatusType.fromString(val);
        }
    }

    public static enum PageStatusType {
        PENDING("pending"),
        ACKNOWLEDGED("acknowledged"),
        OVERDUE("overdue");

        private static final Map<String, PageStatusType> FORMAT_MAP;
        private final String formatted;

        private PageStatusType(String formatted) {
            this.formatted = formatted;
        }

        @JsonValue
        public String toString() {
            return this.formatted;
        }

        @JsonCreator
        public static PageStatusType fromString(String string) {
            return Optional.ofNullable(FORMAT_MAP.get(string)).orElseThrow(() -> new IllegalArgumentException(string));
        }

        static {
            FORMAT_MAP = Stream.of(PageStatusType.values()).collect(Collectors.toMap(s -> s.formatted, Function.identity()));
        }
    }

    public static class UserStatusTypeAdapter
    extends XmlAdapter<String, UserStatusType> {
        public String marshal(UserStatusType type) {
            return type.toString();
        }

        public UserStatusType unmarshal(String val) {
            return UserStatusType.fromString(val);
        }
    }

    public static enum UserStatusType implements ReadAckStatusType
    {
        PENDING("pending"),
        ACKNOWLEDGED("acknowledged"),
        CLOSED("closed"),
        DELETED("deleted");

        private static final Map<String, UserStatusType> FORMAT_MAP;
        private final String formatted;

        private UserStatusType(String formatted) {
            this.formatted = formatted;
        }

        @JsonValue
        public String toString() {
            return this.formatted;
        }

        @JsonCreator
        public static UserStatusType fromString(String string) {
            return Optional.ofNullable(FORMAT_MAP.get(string)).orElseThrow(() -> new IllegalArgumentException(string));
        }

        static {
            FORMAT_MAP = Stream.of(UserStatusType.values()).collect(Collectors.toMap(s -> s.formatted, Function.identity()));
        }
    }
}

