/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.model;

import com.comalatech.confluence.states.model.DueDateWorkflowElement;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflowcontainer.model.Macroable;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import java.util.List;

public class ReadAck
extends DueDateWorkflowElement
implements Macroable {
    private boolean changeDueDate;
    private boolean approverRequestOption;
    public static final String CHANGE_DUE_DATE = "changeduedate";
    public static final String APPROVER_REQUEST_OPTION = "approverRequestOption";

    public ReadAck(List<Condition> conditions) {
        super(conditions);
    }

    @Override
    public SerializableMacro toMacro() {
        SerializableMacro macro = new SerializableMacro("read-ack");
        for (Condition condition : this.conditions) {
            if (!condition.isApplicableToProduct()) continue;
            condition.addMacroParameters(macro);
        }
        String dueDate = this.getDueDate();
        if (dueDate != null) {
            macro.addParameter("duedate", (Object)dueDate);
        }
        if (!this.approverRequestOption) {
            macro.addParameter(APPROVER_REQUEST_OPTION, (Object)false);
        }
        if (!this.changeDueDate) {
            macro.addParameter(CHANGE_DUE_DATE, (Object)false);
        }
        return macro;
    }

    public String toString() {
        return this.toMacro().toString().trim();
    }

    public boolean getApproverRequestOption() {
        return this.approverRequestOption;
    }

    public void setApproverRequestOption(boolean approverRequestOption) {
        this.approverRequestOption = approverRequestOption;
    }

    public boolean isChangeDueDate() {
        return this.changeDueDate;
    }

    public void setChangeDueDate(boolean changeDueDate) {
        this.changeDueDate = changeDueDate;
    }
}

