/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc.api;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.ipc.api.AbstractAdhocService;
import com.comalatech.confluence.messaging.Message;
import com.comalatech.confluence.messaging.PageMessageManager;
import com.comalatech.confluence.states.StateManager;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StateSelection;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.util.FancyDateFormatter;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.StateSelectionManager;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.comalatech.confluence.workflow.model.PageWorkflowParameter;
import com.comalatech.confluence.workflow.model.PageWorkflowParameters;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflow.rest.model.Message;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.WorkflowHandler;
import com.comalatech.workflow.model.Action;
import com.comalatech.workflow.model.Assignment;
import com.comalatech.workflow.model.FormAction;
import com.comalatech.workflow.model.InputField;
import com.comalatech.workflow.model.PageStatus;
import com.comalatech.workflow.model.WorkflowParameterType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkflowHandler
extends AbstractAdhocService
implements WorkflowHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowHandler.class);
    private final PageManager pageManager;
    private final ApprovalManager approvalManager;
    private final StateService stateService;
    private final PageMessageManager pageMessageManager;
    private final InternalWorkflowParameterManager workflowParameterManager;
    private final WorkflowContainerManager workflowContainerManager;
    private final WorkflowPermissionManager workflowPermissionManager;
    private final PermissionManager permissionManager;
    private final AccessModeService accessModeService;
    private final WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;
    private final StateSelectionManager stateSelectionManager;
    private final DocumentActivityUpgradeService documentActivityUpgradeService;
    private final ComalaI18nBean comalaI18nBean;

    public DefaultWorkflowHandler(UserAccessor userAccessor, WorkflowAccessor workflowAccessor, StateManager stateManager, PageManager pageManager, ApprovalManager approvalManager, StateService stateService, PageMessageManager pageMessageManager, InternalWorkflowParameterManager workflowParameterManager, WorkflowContainerManager workflowContainerManager, WorkflowPermissionManager workflowPermissionManager, PermissionManager permissionManager, AccessModeService accessModeService, WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager, StateSelectionManager stateSelectionManager, DocumentActivityUpgradeService documentActivityUpgradeService, ComalaI18nBean comalaI18nBean) {
        super(userAccessor, workflowAccessor, stateManager);
        this.pageManager = pageManager;
        this.approvalManager = approvalManager;
        this.stateService = stateService;
        this.pageMessageManager = pageMessageManager;
        this.workflowParameterManager = workflowParameterManager;
        this.workflowContainerManager = workflowContainerManager;
        this.workflowPermissionManager = workflowPermissionManager;
        this.permissionManager = permissionManager;
        this.accessModeService = accessModeService;
        this.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
        this.stateSelectionManager = stateSelectionManager;
        this.documentActivityUpgradeService = documentActivityUpgradeService;
        this.comalaI18nBean = comalaI18nBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Action> getActions(ContentEntityObject ceo, ConfluenceUser user, boolean admin) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        try {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
            ArrayList<Action> actions = new ArrayList<Action>();
            if (ceo instanceof AbstractPage) {
                PageWorkflows pageWorkflows;
                AbstractPage page;
                block14: {
                    page = (AbstractPage)ceo;
                    pageWorkflows = this.getPageWorkflows(page);
                    if (pageWorkflows != null) break block14;
                    ArrayList<Action> arrayList = actions;
                    return arrayList;
                }
                try {
                    if (admin && pageWorkflows.getValueStore().canAdminWorkflow(user)) {
                        StateSelection selection = this.stateSelectionManager.getStatesSelection(pageWorkflows, true);
                        if (selection != null) {
                            actions.add(selection);
                        }
                    } else if (this.workflowPermissionManager.canViewWorkflows(((AbstractPage)ceo).getSpace(), currentUser)) {
                        actions.addAll(this.approvalManager.getDecoratedApprovalChecks(pageWorkflows, true, true));
                        StateSelection selection = this.stateSelectionManager.getStatesSelection(pageWorkflows, false);
                        if (selection != null) {
                            actions.add(selection);
                        }
                        if (this.canEdit(user, page)) {
                            this.addFormAction(pageWorkflows, actions);
                        }
                    }
                }
                catch (WorkflowException workflowException) {
                    // empty catch block
                }
            }
            ArrayList<Action> arrayList = actions;
            return arrayList;
        }
        finally {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)currentUser);
        }
    }

    private boolean canEdit(ConfluenceUser user, AbstractPage page) {
        return (Boolean)this.accessModeService.withReadOnlyAccessExemption(() -> this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)page));
    }

    @Override
    public List<ConfluenceUser> getInvolvedUsers(ContentEntityObject ceo) {
        InvolvedUsersContainer users = new InvolvedUsersContainer();
        List summaries = this.pageManager.getVersionHistorySummaries(ceo);
        for (VersionHistorySummary summary : summaries) {
            users.add(summary.getLastModifierName());
        }
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows((AbstractPage)ceo);
        if (pageWorkflows != null) {
            for (String userName : pageWorkflows.getValueStore().getInvolvedUsersNames()) {
                users.add(userName);
            }
        }
        return users.getUsers();
    }

    @Override
    public String getDefaultApprovalWorkflowMarkup(String spaceKey) {
        return this.workflowContainerManager.getDefaultApprovalWorkflowMarkup(spaceKey);
    }

    protected void addFormAction(PageWorkflows pageWorkflows, List<Action> actions) {
        PageWorkflowParameters parameters = this.workflowParameterManager.getPageWorkflowParameters(pageWorkflows);
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        ArrayList<InputField> fields = new ArrayList<InputField>(parameters.size());
        for (PageWorkflowParameter parameter : parameters) {
            if (null == parameter.getType()) continue;
            fields.add(new InputField(parameter.getId(), parameter.getName(), parameter.getDescription(), parameter.getValue(), InputField.InputType.fromWorkflowParameterType(parameter.getType()), parameter.getType() == WorkflowParameterType.LIST ? parameter.getOptions() : null));
        }
        actions.add(new FormAction(true, fields, parameters.isInitialized()));
    }

    @Override
    public List<Message> getPageMessages(ContentEntityObject contentEntityObject, boolean publishedView) {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.addAll(this.getCommonMessages(contentEntityObject, publishedView));
        messages.addAll(this.getUserMessages(contentEntityObject, publishedView));
        return messages;
    }

    private List<Message> getCommonMessages(ContentEntityObject contentEntityObject, boolean publishedView) {
        com.comalatech.confluence.messaging.Message messageDraft;
        ArrayList<Message> commonMessages = new ArrayList<Message>();
        com.comalatech.confluence.messaging.Message messageBoth = this.pageMessageManager.getBothMessage((AbstractPage)contentEntityObject, true);
        if (messageBoth != null && StringUtils.isNotBlank((CharSequence)messageBoth.getMessage())) {
            commonMessages.add(this.createMessage(messageBoth));
        }
        if (publishedView) {
            com.comalatech.confluence.messaging.Message messagePublic = this.pageMessageManager.getPublicMessage((AbstractPage)contentEntityObject, true);
            if (messagePublic != null && StringUtils.isNotBlank((CharSequence)messagePublic.getMessage())) {
                commonMessages.add(this.createMessage(messagePublic));
            }
        } else if (this.workflowPermissionManager.canViewDrafts((AbstractPage)contentEntityObject, AuthenticatedUserThreadLocal.get()) && (messageDraft = this.pageMessageManager.getDraftMessage((AbstractPage)contentEntityObject, true)) != null && StringUtils.isNotBlank((CharSequence)messageDraft.getMessage())) {
            commonMessages.add(this.createMessage(messageDraft));
        }
        return commonMessages;
    }

    private List<Message> getUserMessages(ContentEntityObject contentEntityObject, boolean publishedView) {
        com.comalatech.confluence.messaging.Message messageDraftUser;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        ArrayList<Message> userMessages = new ArrayList<Message>();
        com.comalatech.confluence.messaging.Message messageBothUser = this.pageMessageManager.getBothMessage((AbstractPage)contentEntityObject, user, true);
        if (messageBothUser != null && StringUtils.isNotBlank((CharSequence)messageBothUser.getMessage())) {
            userMessages.add(this.createMessage(messageBothUser));
        }
        if (publishedView) {
            com.comalatech.confluence.messaging.Message messagePublicUser = this.pageMessageManager.getPublicMessage((AbstractPage)contentEntityObject, user, true);
            if (messagePublicUser != null && StringUtils.isNotBlank((CharSequence)messagePublicUser.getMessage())) {
                userMessages.add(this.createMessage(messagePublicUser));
            }
        } else if (this.workflowPermissionManager.canViewDrafts((AbstractPage)contentEntityObject, user) && (messageDraftUser = this.pageMessageManager.getDraftMessage((AbstractPage)contentEntityObject, user, true)) != null && StringUtils.isNotBlank((CharSequence)messageDraftUser.getMessage())) {
            userMessages.add(this.createMessage(messageDraftUser));
        }
        return userMessages;
    }

    private Message createMessage(com.comalatech.confluence.messaging.Message message) {
        return new Message(this.convertMessageType(message.getStyle()), message.getTitle(), message.getMessage(), message.isShowOnce());
    }

    @Override
    public void setParameter(ContentEntityObject ceo, final String parameterId, final String value) throws WorkflowException {
        new AbstractAdhocService.WorkflowCommand(ceo){

            @Override
            public Object doCommand(AbstractPage page, ConfluenceUser user, PageWorkflows pageWorkflows, PageState state) throws WorkflowException {
                PageWorkflowParameter parameter = DefaultWorkflowHandler.this.workflowParameterManager.getPageWorkflowParameters(pageWorkflows).get(parameterId);
                if (parameter == null) {
                    throw new WorkflowException("Invalid parameter " + parameterId);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Workflow parameter update request with id '" + parameterId + "', current value '" + parameter.getValue() + "' and new value '" + value + "'");
                }
                parameter.setValue(value);
                DefaultWorkflowHandler.this.workflowParameterManager.setPageWorkflowParameterValue(page, parameter);
                return null;
            }
        }.execute();
    }

    @Override
    public PageStatus getPageStatus(ContentEntityObject ceo, boolean publishedView, boolean withMessages) {
        if (log.isDebugEnabled()) {
            log.debug("getting page status for: " + ceo + "      publishedView: " + publishedView);
        }
        AbstractPage page = (AbstractPage)ceo;
        PageStatus pageStatus = null;
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows((AbstractPage)ceo);
        if (this.workflowPermissionManager.canViewDrafts(page, AuthenticatedUserThreadLocal.get())) {
            if (log.isDebugEnabled()) {
                log.debug("page workflows: " + pageWorkflows);
            }
            if (pageWorkflows == null || !pageWorkflows.isShowPageStatus(true)) {
                return null;
            }
            com.comalatech.workflow.model.State currentState = this.stateService.getCurrentState((ContentEntityObject)page);
            if (log.isDebugEnabled()) {
                log.debug("current state: " + currentState);
            }
            if (currentState == null && pageWorkflows.getInitialState() != null) {
                currentState = new PageState(pageWorkflows.getInitialState().getName());
                if (log.isDebugEnabled()) {
                    log.debug("workflow initial state: " + currentState);
                }
            }
            if (currentState != null && pageWorkflows.getStatesContainer() != null) {
                String assignee;
                List<? extends Assignment> assignments;
                State workflowState = pageWorkflows.getState(currentState.getName());
                pageStatus = this.initPageStatus(publishedView, pageWorkflows, currentState);
                com.comalatech.workflow.model.State publishedState = this.stateService.getPublishedState((ContentEntityObject)page);
                if (log.isDebugEnabled()) {
                    log.debug("published state: " + publishedState);
                }
                if (publishedView) {
                    pageStatus.setAlternateViewUrl(this.appendDraftView(page.getUrlPath()));
                    if (!currentState.equals(publishedState)) {
                        pageStatus.setAlternateViewStateName(currentState.getName());
                    } else {
                        pageStatus.setAlternateViewStateName(this.comalaI18nBean.getText("approvalsworkflow.navlink.view"));
                    }
                }
                if (publishedState != null) {
                    pageStatus.setPublishedStateName(publishedState.getName());
                    pageStatus.setPublishedStateDescription(publishedState.getDescription());
                    pageStatus.setPublishedStateColour(publishedState.getColour());
                    if (!publishedView && !publishedState.equals(currentState)) {
                        pageStatus.setAlternateViewStateName(publishedState.getName());
                        pageStatus.setAlternateViewUrl(this.makePrettyReleasedUrlPath(page));
                    }
                }
                if (currentState.getExpirationDate() != null) {
                    pageStatus.setExpirationDate(FancyDateFormatter.decorateDateTimePretty(currentState.getExpirationDate(), false));
                    pageStatus.setExpirationDateValue(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(currentState.getExpirationDate()));
                    pageStatus.setExpired(currentState.getExpirationDate().before(new Date()));
                }
                if (workflowState != null) {
                    pageStatus.setChangeExpirationDate(workflowState.isChangeDueDate());
                }
                if (AuthenticatedUserThreadLocal.get() != null) {
                    pageStatus.setTaskable(currentState.isTaskable());
                    pageStatus.setActiveTasks(currentState.getTasks().size());
                }
                if (pageWorkflows.getApprovals((PageState)currentState).size() > 0) {
                    pageStatus.setActionable(true);
                }
                if ((currentState.getApprovals() == null || currentState.getApprovals().size() <= 0) && (assignments = currentState.getAssignments()) != null && assignments.size() > 0 && StringUtils.isNotBlank((CharSequence)(assignee = assignments.get(assignments.size() - 1).getAssignee()))) {
                    pageStatus.setAssignee(assignee);
                }
                if (pageWorkflows.isDisplayProgressTracker()) {
                    pageStatus.setOrderedWorkflowStates(this.generateOrderedWorkflowStates(currentState, pageWorkflows.getStatesContainer()));
                }
            }
        }
        if (pageStatus == null) {
            pageStatus = new PageStatus(null, false, this.workflowAdvancedConfigurationManager.getUserSearchMinCharacters(), this.documentActivityUpgradeService.isSpaceStatusUpgradeSuccess(page));
            pageStatus.setPublishedView(publishedView);
            pageStatus.setHideStates(true);
        }
        if (withMessages) {
            pageStatus.addMessages(this.getPageMessages((ContentEntityObject)page, publishedView));
        }
        if (log.isDebugEnabled()) {
            log.debug("Getting page status complete");
        }
        return pageStatus;
    }

    private PageStatus initPageStatus(boolean publishedView, PageWorkflows pageWorkflows, com.comalatech.workflow.model.State currentState) {
        PageStatus pageStatus = new PageStatus(currentState.getName(), currentState.isPublished(), this.workflowAdvancedConfigurationManager.getUserSearchMinCharacters(), this.documentActivityUpgradeService.isSpaceStatusUpgradeSuccess(pageWorkflows.getPage()));
        pageStatus.setHasFinalState(pageWorkflows.isRequiresFinalApproval());
        pageStatus.setVersionsCompleted(currentState.isVersionsCompleted());
        pageStatus.setUpdatePageStatus(pageWorkflows.isUpdateStatus());
        pageStatus.setStateComment(currentState.getComment());
        pageStatus.setStateDescription(currentState.getDescription());
        pageStatus.setStateColour(currentState.getColour());
        pageStatus.setAdmin(pageWorkflows.getValueStore().isAdminOverride());
        pageStatus.setPublishedView(publishedView);
        pageStatus.setPageAssignable(currentState.isAssignable());
        pageStatus.setActivityVisible(true);
        pageStatus.setAdhoc(pageWorkflows.isAdhoc());
        pageStatus.setHideStates(pageWorkflows.isHidStates());
        pageStatus.setDisplayProgressTracker(pageWorkflows.isDisplayProgressTracker());
        return pageStatus;
    }

    protected List<String> generateOrderedWorkflowStates(com.comalatech.workflow.model.State currentState, StatesContainer statesContainer) {
        LinkedList<String> orderedWorkflowStates = new LinkedList<String>();
        State current = statesContainer.getState(currentState.getName());
        for (State orderedState : statesContainer.getStates()) {
            if (orderedState.isHideFromPath() && (current == null || !orderedState.getName().equals(current.getName()))) continue;
            orderedWorkflowStates.add(orderedState.getName());
        }
        return orderedWorkflowStates;
    }

    private String appendDraftView(String url) {
        StringBuffer sb = new StringBuffer(url);
        if (url.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        return sb.append("draft=true").toString();
    }

    private String makePrettyReleasedUrlPath(AbstractPage page) {
        String path = page.getUrlPath();
        path = !(page instanceof BlogPost) && path.startsWith("/display/") ? path.replaceAll("/display/", "/display/public/") : "/pages/releaseview.action?pageId=" + page.getIdAsString();
        return path;
    }

    private String convertMessageType(String type) {
        if (Message.MacroParamStyle.INFO.param.equals(type)) {
            return Message.MessageType.INFO.toString();
        }
        if (Message.MacroParamStyle.ERROR.param.equals(type)) {
            return Message.MessageType.ERROR.toString();
        }
        if (Message.MacroParamStyle.GENERIC.param.equals(type)) {
            return Message.MessageType.GENERIC.toString();
        }
        if (Message.MacroParamStyle.HINT.param.equals(type)) {
            return Message.MessageType.HINT.toString();
        }
        if (Message.MacroParamStyle.NOTE.param.equals(type)) {
            return Message.MessageType.INFO.toString();
        }
        if (Message.MacroParamStyle.SUCCESS.param.equals(type)) {
            return Message.MessageType.SUCCESS.toString();
        }
        if (Message.MacroParamStyle.TIP.param.equals(type)) {
            return Message.MessageType.HINT.toString();
        }
        if (Message.MacroParamStyle.WARNING.param.equals(type)) {
            return Message.MessageType.WARNING.toString();
        }
        return Message.MessageType.INFO.toString();
    }

    private class InvolvedUsersContainer {
        private final List<ConfluenceUser> users = new ArrayList<ConfluenceUser>();
        private final Set<String> names = new HashSet<String>();

        public InvolvedUsersContainer() {
            this.add(AuthenticatedUserThreadLocal.getUsername());
        }

        public void add(String name) {
            if (name == null || this.names.contains(name)) {
                return;
            }
            this.names.add(name);
            ConfluenceUser user = DefaultWorkflowHandler.this.userAccessor.getUserByName(name);
            if (user != null) {
                this.users.add(user);
            }
        }

        public List<ConfluenceUser> getUsers() {
            return this.users;
        }
    }
}

