/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service.provider.confluence.filter;

import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQueryFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.contract.CommentActivityFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.contract.PageEditActivityFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class UserFilter
implements PageEditActivityFilter,
CommentActivityFilter {
    @Override
    public boolean filter(VersionHistorySummary version, InternalDocumentActivityQuery query) {
        return this.match(version.getContributorSet(), (InternalDocumentActivityQueryFilter)query.getFilters());
    }

    @Override
    public boolean filter(Comment comment, InternalDocumentActivityQuery query) {
        return this.match(Arrays.asList(comment.getCreator(), comment.getLastModifier()), (InternalDocumentActivityQueryFilter)query.getFilters());
    }

    private boolean match(Collection<ConfluenceUser> users, InternalDocumentActivityQueryFilter filters) {
        if (filters != null && filters.getParticipants() != null && !filters.getParticipants().isEmpty()) {
            return false;
        }
        if (filters == null || filters.getActors() == null || filters.getActors().isEmpty()) {
            return true;
        }
        HashSet userKeys = new HashSet(filters.getActors() == null || filters.getActors().isEmpty() ? Collections.emptyList() : filters.getActors());
        return users.stream().map(user -> user.getKey().getStringValue()).anyMatch(userKeys::contains);
    }
}

