/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActions.mappers;

import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.comalatech.confluence.documentActions.mappers.DocumentActionsMapper;
import com.comalatech.confluence.documentActions.rest.model.ActionReport;
import com.comalatech.confluence.documentActions.services.model.ActionsSearchResult;
import com.comalatech.confluence.documentActions.services.model.PendingTasks;
import com.comalatech.confluence.documentActions.services.model.search.ActionTypes;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.tasks.extractor.model.PageTasksContentPropertyModel;
import com.comalatech.confluence.tasks.extractor.model.PendingTasksContentProperty;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessorImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TasksMapper
implements DocumentActionsMapper {
    private static final Logger log = LoggerFactory.getLogger(TasksMapper.class);
    public static final String COMALA_WORKFLOWS_PENDING_TASKS_KEY = "comalaworkflowstasks";
    private final ObjectMapper jsonMapper;
    private final PageManager pageManager;
    private final UserAccessor userAccessor;
    private final BootstrapManager bootstrapManager;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final ComalaI18nBean comalaI18nBean;

    public TasksMapper(ObjectMapper jsonMapper, PageManager pageManager, UserAccessor userAccessor, BootstrapManager bootstrapManager, WorkflowsFeatureManager workflowsFeatureManager, ComalaI18nBean comalaI18nBean) {
        this.jsonMapper = jsonMapper;
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
        this.bootstrapManager = bootstrapManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    @Override
    public ActionsSearchResult map(ActionsSearchResult actionsSearchResult, ConfluenceUser assignedUser, Content contentEntity, Map.Entry<String, JsonContentProperty> contentMetadata) {
        AbstractPage page;
        if (actionsSearchResult == null) {
            actionsSearchResult = new ActionsSearchResult();
        }
        if (contentMetadata != null && COMALA_WORKFLOWS_PENDING_TASKS_KEY.equals(contentMetadata.getKey()) && (page = this.pageManager.getAbstractPage(contentEntity.getId().asLong())) != null) {
            Optional<PageTasksContentPropertyModel> pendingTasksContentProperties = this.toContentPropertiesPendingTasks(contentMetadata.getValue().getValue());
            List<PendingTasks> pendingTasks = pendingTasksContentProperties.map(pageTasksContentPropertyModel -> pageTasksContentPropertyModel.pendingTasksContentProperties.stream().map(contentProperty -> this.toPendingTasks(page, assignedUser, (PendingTasksContentProperty)contentProperty)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).orElse(Collections.emptyList());
            actionsSearchResult.setPendingTasks(pendingTasks);
        }
        return actionsSearchResult;
    }

    private Optional<PageTasksContentPropertyModel> toContentPropertiesPendingTasks(JsonString pendingTasksJsonContent) {
        PageTasksContentPropertyModel pendingTasks = null;
        try {
            pendingTasks = (PageTasksContentPropertyModel)this.jsonMapper.readValue(pendingTasksJsonContent.getValue(), PageTasksContentPropertyModel.class);
        }
        catch (Exception ex) {
            log.warn("Cannot extract tasks data list {} : {}", new Object[]{pendingTasksJsonContent, this, ex});
        }
        return Optional.ofNullable(pendingTasks);
    }

    private Optional<PendingTasks> toPendingTasks(AbstractPage page, ConfluenceUser assignedUser, PendingTasksContentProperty contentPropertyPendingTask) {
        if (StringUtils.equals((CharSequence)contentPropertyPendingTask.assignedTo, (CharSequence)assignedUser.getName())) {
            PendingTasks task = new PendingTasks();
            task.setId(String.valueOf(contentPropertyPendingTask.id));
            task.setAssignedBy(contentPropertyPendingTask.assignedBy);
            task.setAssignedTo(contentPropertyPendingTask.assignedTo);
            task.setDetails(contentPropertyPendingTask.note);
            task.setType(ActionTypes.TASK);
            if (contentPropertyPendingTask.dueDate > 0L) {
                task.setDueDate(contentPropertyPendingTask.dueDate);
            }
            task.setAssignmentDate(contentPropertyPendingTask.assignmentDate);
            task.setName(contentPropertyPendingTask.name);
            this.getAssignerDetailsFrom(task, contentPropertyPendingTask);
            this.getContentDetailsFromPage(page, task);
            return Optional.of(task);
        }
        return Optional.empty();
    }

    private PendingTasks getContentDetailsFromPage(AbstractPage page, PendingTasks resultPendingTask) {
        ActionReport.ContentDetails contentDetails = new ActionReport.ContentDetails(resultPendingTask);
        contentDetails.setId(page.getId());
        contentDetails.setUrl(page.getUrlPath());
        contentDetails.setTitle(page.getDisplayTitle());
        contentDetails.setType(page.getType());
        contentDetails.setSpaceName(page.getSpace().getName());
        if (page instanceof Page) {
            contentDetails.setHome(((Page)page).isHomePage());
        } else {
            contentDetails.setHome(false);
        }
        resultPendingTask.setContentDetails(contentDetails);
        return resultPendingTask;
    }

    private PendingTasks getAssignerDetailsFrom(PendingTasks resultPendingTask, PendingTasksContentProperty contentPropertyPendingTask) {
        ActionReport.AssignerDetails assignerDetails = new ActionReport.AssignerDetails(resultPendingTask);
        String pictureUrl = "/images/icons/profilepics/default.gif";
        String name = contentPropertyPendingTask.assignedBy;
        if (name != null) {
            ConfluenceUser assignedBy = this.userAccessor.getUserByName(name);
            if (assignedBy != null) {
                name = assignedBy.getFullName();
                pictureUrl = this.userAccessor.getUserProfilePicture((User)assignedBy).getUriReference();
            } else if ("com.comalatech.workflow".equals(name)) {
                WorkflowUserAccessorImpl user = new WorkflowUserAccessorImpl(this.userAccessor, this.bootstrapManager, this.workflowsFeatureManager);
                name = user.getWorkflowsUser().getFullName();
                pictureUrl = user.getWorkflowUserAvatarPath();
            } else {
                name = this.comalaI18nBean.getText("com.comalatech.dashboard.report.unknown");
            }
        } else {
            name = this.comalaI18nBean.getText("anonymous.name");
        }
        assignerDetails.setDisplayName(name);
        assignerDetails.setAvatarUrl(pictureUrl);
        assignerDetails.setUsername(contentPropertyPendingTask.assignedBy);
        resultPendingTask.setAssignerDetails(assignerDetails);
        return resultPendingTask;
    }
}

