/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.dataextractor.listener;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.dataextractor.queue.AppfireQueueService;
import com.comalatech.confluence.dataextractor.queue.model.QueueReadAckContentPropertyItem;
import com.comalatech.confluence.dataextractor.queue.model.QueueWorkflowsContentPropertyItem;
import com.comalatech.confluence.dataextractor.queue.model.QueueWorkflowsParametersContentPropertyItem;
import com.comalatech.confluence.readack.events.ReadAckDueDateChangeEventImpl;
import com.comalatech.confluence.states.event.StateExpiryUpdatedEvent;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.events.ApprovalsResetEvent;
import com.comalatech.workflow.event.StateChangeEvent;
import com.comalatech.workflow.event.approval.ApprovalEvent;
import com.comalatech.workflow.event.readack.ReadAckCompletedEvent;
import com.comalatech.workflow.event.readack.ReadAckCreatedEvent;
import com.comalatech.workflow.event.readack.ReadAckOverdueEvent;
import com.comalatech.workflow.event.readack.ReadAcknowledgedEvent;

public class DataExtractorListener
extends WorkflowsListener {
    private final AppfireQueueService appfireQueueService;

    public DataExtractorListener(EventPublisher eventPublisher, AppfireQueueService appfireQueueService) {
        super(eventPublisher);
        this.appfireQueueService = appfireQueueService;
    }

    @EventListener
    public void approvalEvent(ApprovalEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updatePage(content);
    }

    @EventListener
    public void stateChangeEvent(StateChangeEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updatePage(content);
        this.updatePageWorkflowParameters(content);
    }

    @EventListener
    public void stateExpiryUpdatedEvent(StateExpiryUpdatedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updatePage(content);
    }

    @EventListener
    public void readAckCreatedEvent(ReadAckCreatedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateReadAckPage(content);
    }

    @EventListener
    public void readAckCompletedEvent(ReadAckCompletedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateReadAckPage(content);
    }

    @EventListener
    public void readAcknowlegedEvent(ReadAcknowledgedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateReadAckPage(content);
    }

    @EventListener
    public void readAckOverdue(ReadAckOverdueEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateReadAckPage(content);
    }

    @EventListener
    public void readAckDueDateChange(ReadAckDueDateChangeEventImpl event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateReadAckPage(content);
    }

    @EventListener
    public void approvalsReset(ApprovalsResetEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        if (content != null) {
            this.updatePage(content);
        }
    }

    private void updatePage(AbstractPage content) {
        if (content != null) {
            QueueWorkflowsContentPropertyItem queueContentPropertyItem = new QueueWorkflowsContentPropertyItem(content.getId());
            this.appfireQueueService.addTask("content_queue", queueContentPropertyItem);
        }
    }

    private void updateReadAckPage(AbstractPage content) {
        if (content != null) {
            QueueReadAckContentPropertyItem queueContentPropertyItem = new QueueReadAckContentPropertyItem(content.getId());
            this.appfireQueueService.addTask("content_queue", queueContentPropertyItem);
        }
    }

    private void updatePageWorkflowParameters(AbstractPage content) {
        if (content != null) {
            QueueWorkflowsParametersContentPropertyItem queueContentPropertyItem = new QueueWorkflowsParametersContentPropertyItem(content.getId());
            this.appfireQueueService.addTask("content_queue", queueContentPropertyItem);
        }
    }
}

