/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhocworkflows.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.adhocworkflows.rest.AbstractRestResources;
import com.comalatech.confluence.adhocworkflows.rest.model.User;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflow.rest.model.Message;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.WorkflowHandler;
import com.comalatech.workflow.model.PageStatus;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractAdhocResources
extends AbstractRestResources {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String NO_SECONDS_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm";
    protected final WorkflowHandler workflowHandler;
    protected final UserSearchManager userSearchManager;
    protected final BootstrapManager bootstrapManager;

    public AbstractAdhocResources(PageManager pageManager, PermissionManager permissionManager, WorkflowPermissionManager workflowPermissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, AccessModeService accessModeService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowHandler workflowHandler, UserSearchManager userSearchManager, BootstrapManager bootstrapManager, ComalaI18nBean comalaI18nBean) {
        super(pageManager, permissionManager, workflowPermissionManager, spaceManager, spacePermissionManager, accessModeService, workflowsFeatureManager, workflowConfigurationManager, comalaI18nBean);
        this.workflowHandler = workflowHandler;
        this.userSearchManager = userSearchManager;
        this.bootstrapManager = bootstrapManager;
    }

    protected Response getStatus(AbstractPage page, boolean publishedView) {
        PageStatus pageStatus = this.workflowHandler.getPageStatus((ContentEntityObject)page, publishedView, true);
        return this.makeResponse(pageStatus);
    }

    @Override
    protected Response getStatus(AbstractPage page, Message errorMessage) {
        PageStatus pageStatus = this.workflowHandler.getPageStatus((ContentEntityObject)page, false, true);
        if (errorMessage != null) {
            if (pageStatus == null) {
                pageStatus = new PageStatus();
            }
            pageStatus.addMessage(errorMessage);
        }
        return this.makeResponse(pageStatus);
    }

    protected Workflow getWorkflow(List<Workflow> workflows, String label) {
        if (label == null) {
            return null;
        }
        for (Workflow workflow : workflows) {
            if (!workflow.isActiveForLabel(label)) continue;
            return workflow;
        }
        return null;
    }

    private Response makeResponse(PageStatus pageStatus) {
        if (pageStatus != null) {
            return Response.ok((Object)pageStatus).build();
        }
        return Response.noContent().build();
    }

    protected String getDeletedUserIcon() {
        return this.bootstrapManager.getWebAppContextPath() + "/images/icons/profilepics/default.svg";
    }

    protected boolean canAdminWorkflow(AbstractPage page, com.atlassian.user.User user) {
        return this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION) || page.getSpace() != null && this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)page.getSpace());
    }

    protected List<User> makeInvolvedUsers(List<ConfluenceUser> involvedUsers) {
        ArrayList<User> users = new ArrayList<User>(involvedUsers.size());
        for (ConfluenceUser involvedUser : involvedUsers) {
            users.add(this.userSearchManager.makeUser(involvedUser, null));
        }
        return users;
    }

    protected String formatDate(Date date) {
        if (date != null) {
            return new SimpleDateFormat(DATE_TIME_FORMAT).format(date);
        }
        return null;
    }

    protected Date parseDate(String dateString) throws WorkflowException {
        if (StringUtils.isNotBlank((CharSequence)dateString)) {
            try {
                return new SimpleDateFormat(DATE_TIME_FORMAT).parse(dateString);
            }
            catch (ParseException e) {
                try {
                    return new SimpleDateFormat(NO_SECONDS_DATE_TIME_FORMAT).parse(dateString);
                }
                catch (ParseException e1) {
                    try {
                        return new SimpleDateFormat(DATE_FORMAT).parse(dateString);
                    }
                    catch (ParseException e2) {
                        throw new WorkflowException("Unrecognized date time format");
                    }
                }
            }
        }
        return null;
    }
}

