/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw'], function(CW) {
    CW.toInit(function () {

        function getNewOnboardingUrl(baseUrl) {
            return baseUrl + '/documentManagement/onboarding.action';
        }

        function goToNewOnboarding() {
            window.location.href = getNewOnboardingUrl(CW.getParam('baseUrl'));
        }

        // discovery flag message in pages
        if (CW.getParam('showPageOnboarding')) {
            var linkMore = '<a class="cw-flag-action cw-onboard-more">' + CW.I18n.getText('onboarding.page.discovery.link.more') + '</a>';
            var linkHide = '<a class="cw-flag-action cw-onboard-hide">' + CW.I18n.getText('onboarding.page.discovery.link.hide') + '</a>';
            var messageBody = '<p>' + CW.I18n.getText('onboarding.page.discovery.body') + '</p><p>' + linkMore + '·' + linkHide + '</p>';

            new CW.Flag({
                type: 'info',
                title: CW.I18n.getText('onboarding.page.discovery.title'),
                body: messageBody,
                close: 'manual',
                removeAfterClose: true,
                events: {
                    'click .cw-onboard-more': function() {
                        goToNewOnboarding();
                        this.close();
                    },
                    'click .cw-onboard-hide': function() {
                        // dont show discovery message again
                        CW.request({
                            type: 'POST',
                            contentType: 'application/json',
                            url: CW.getParam('contextPath') + '/rest/cw/2/onboard/hide',
                        });
                        this.close();
                    }
                }
            });
        }
    });
});
