/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function (CW, $) {
    CW.toInit(function () {
        // Workflows Global list
        var WorkflowsListIframe = new CW.iframe({
            id: 'WorkflowsGlobalListIframe',
            url: '/admin/global',
            width: '100%',
            height: '100%',
            query: {}
        });
        $('#cw-global-admin-container').html(WorkflowsListIframe.render());

        CW.connect("reload", function () {
            WorkflowsListIframe.send("reload");
        });

        // Workflow Preview Modal
        CW.connect("globalWorkflowPreview", function (workflowDataJSON) {
            var workflowData = JSON.parse(workflowDataJSON);

            // Workflow preview info
            var globalWorkflowPreview = new CW.Dialog({
                id: 'cw-globalWorkflowPreviewDialog',
                width: 800,
                height: 550,
                path: '/admin/global/preview',
                query: {
                    handle: workflowData.workflowId,
                    global: workflowData.global
                },
                customData: {
                    markup: workflowData.markup
                }
            });
            globalWorkflowPreview.show();
        });

        // Modal: Linked Spaces
        CW.connect("openModal", function (modalDataJSON) {
            var modalData = JSON.parse(modalDataJSON);
            var workflowId = modalData.workflowId;
            var workflowName = modalData.workflowName;

            // Modal Indon
            var openModal = new CW.Dialog({
                id: 'cw-modal',
                width: 500,
                height: 300,
                path: '/modal/linkedspaces/' + workflowId,
                query: {
                    workflowName: workflowName
                }
            });
            openModal.show();
        });

        // Modal: Spaces Categories
        CW.connect("spaceCategory", function (modalDataJSON) {
            var modalData = JSON.parse(modalDataJSON);
            var workflowId = modalData.workflowId;
            var workflowName = modalData.workflowName;
            var spaceLabelLinks = modalData.spaceLabelLinks;
            var path = '/modal/spacecategories/' + workflowId;

            if (spaceLabelLinks.length > 1) {
                path += '/selectcategory';
            } else {
                path += '/linkworkflow';
            }

            // Modal Indon
            var spaceModalCategories = new CW.Dialog({
                id: 'cw-spaceModalCategories',
                width: 500,
                height: 300,
                path: path,
                query: {
                    workflowName: workflowName,
                    spaceLabelLinks: spaceLabelLinks
                }
            });
            spaceModalCategories.show();
        });
    });
});
