/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.user;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.util.regex.Pattern;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;
import org.randombits.confluence.filtering.criteria.NotCriterion;
import org.randombits.confluence.filtering.criteria.user.AnonymousUserCriterion;
import org.randombits.confluence.filtering.criteria.user.UserCriterion;

public class UserNameCriterion
implements Criterion {
    private Pattern namePattern;

    public UserNameCriterion(String namePattern) {
        this.namePattern = Pattern.compile(namePattern);
    }

    public boolean matches(Object object) {
        String username = null;
        if (object instanceof User) {
            username = ((User)object).getName();
        } else if (object instanceof String) {
            username = (String)object;
        }
        return username != null && this.namePattern.matcher(username).matches();
    }

    public String toString() {
        return "{username: " + this.namePattern + "}";
    }

    public static class Interpreter
    implements CriterionInterpreter {
        public static final String SELF = "@self";
        public static final String ANONYMOUS = "@anonymous";
        public static final String AUTHENTICATED = "@authenticated";

        public Criterion createCriterion(String value) {
            if (SELF.equals(value)) {
                return new UserCriterion(AuthenticatedUserThreadLocal.getUser());
            }
            if (ANONYMOUS.equals(value)) {
                return new AnonymousUserCriterion();
            }
            if (AUTHENTICATED.equals(value)) {
                return new NotCriterion(new AnonymousUserCriterion());
            }
            if (value.indexOf(42) >= 0) {
                value = value.replaceAll("\\.", "\\.").replaceAll("\\*", ".*");
                return new UserNameCriterion(value);
            }
            return new UserCriterion(value);
        }
    }
}

