/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model.presenter;

import com.comalatech.confluence.workflowreports.model.WorkflowStatesReportOptions;
import com.comalatech.confluence.workflowreports.model.presenter.MacroParametersPresenter;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlGroup;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlInnerGroup;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlOperators;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlParam;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlPrintable;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowStateReportOptionsCqlPresenter
implements MacroParametersPresenter {
    private static final Logger log = LoggerFactory.getLogger(WorkflowStateReportOptionsCqlPresenter.class);
    private final WorkflowStatesReportOptions options;
    private final ObjectMapper objectMapper;
    private static final String SPACE_NAME = "space";
    private static final String PARENT_NAME = "parent";
    private static final String APPROVED_ASSIGNED_NAME = "content.property[comalaworkflowspendingapprovers].userKeyList";
    private static final String APPROVED_APPROVAL_NAME = "content.property[comalaworkflowsapprovedapprovals].approvalNameList";
    private static final String PENDING_APPROVAL_NAME = "content.property[comalaworkflowspendingapprovals].approvalNameList";
    private static final String REJECTED_APPROVAL_NAME = "content.property[comalaworkflowsrejectedapprovals].approvalNameList";
    private static final String LABEL_NAME = "label";
    private static final String STATES_NAME = "state";
    private static final String WORKFLOW_NAME = "workflowname";
    protected static final String CQL_KEY = "cqlQuery";
    protected static final String SHOW_LIVE_FILTERING_KEY = "showLiveFiltering";
    protected static final String ITEMS_PER_PAGE_KEY = "numberOfItems";
    protected static final String PRE_SELECTED_STATES_KEY = "preSelectedStates";
    protected static final String PRE_SELECTED_WORKFLOWS_KEY = "preSelectedWorkflows";
    protected static final String COLUMNS_TO_SHOW_KEY = "columnsToShow";
    protected static final String SORT_KEY = "sort";
    protected static final String SORT_ORDER_KEY = "sortOrder";
    private static final String APPROVED_STATUS = "APPROVED";
    private static final String PENDING_STATUS = "PENDING";
    private static final String REJECTED_STATUS = "REJECTED";

    public WorkflowStateReportOptionsCqlPresenter(WorkflowStatesReportOptions options, ObjectMapper objectMapper) {
        this.options = options;
        this.objectMapper = objectMapper;
    }

    @Override
    public Map<String, Object> present() {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        propertiesMap.put(ITEMS_PER_PAGE_KEY, this.options.getNumberOfItemsPerPage());
        propertiesMap.put(COLUMNS_TO_SHOW_KEY, this.options.getColumnsToShow());
        propertiesMap.put(SORT_KEY, this.options.getSort());
        propertiesMap.put(SORT_ORDER_KEY, this.options.getSortOrder());
        propertiesMap.putAll(this.propertiesForLiveFiltering());
        propertiesMap.putAll(this.propertiesForCql());
        return propertiesMap;
    }

    private Map<? extends String, ?> propertiesForLiveFiltering() {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        boolean enableLiveFilter = this.options.isSingleSpace();
        propertiesMap.put(SHOW_LIVE_FILTERING_KEY, enableLiveFilter);
        propertiesMap.put(PRE_SELECTED_STATES_KEY, this.toJson(enableLiveFilter ? this.options.getStates() : null));
        propertiesMap.put(PRE_SELECTED_WORKFLOWS_KEY, this.toJson(enableLiveFilter ? this.options.getWorkflows() : null));
        return propertiesMap;
    }

    private String toJson(Object parameter) {
        if (parameter != null) {
            try {
                return this.objectMapper.writeValueAsString(parameter);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return "";
    }

    private Map<? extends String, ?> propertiesForCql() {
        CqlGroup cqlGroup = new CqlGroup().joinOperator(CqlOperators.LogicalOperators.AND).addCqlElement(this.buildSimpleCqlParam(SPACE_NAME, this.options.getSpaceKeys())).addCqlElement(this.buildSimpleCqlParam(PARENT_NAME, this.options.getParentPageId())).addCqlElement(this.buildSimpleCqlParam(APPROVED_ASSIGNED_NAME, Collections.singletonList(this.options.getApprovalAssignedTo()))).addCqlElement(this.buildApprovalCqlParam()).addCqlElement(this.buildLabelsCqlParam());
        if (!this.options.isSingleSpace()) {
            cqlGroup.addCqlElement(this.buildSimpleCqlParam(STATES_NAME, this.options.getStates()));
            cqlGroup.addCqlElement(this.buildSimpleCqlParam(WORKFLOW_NAME, this.options.getWorkflows()));
        }
        if (this.options.getCql() != null) {
            String cql = this.options.getCql();
            String result = cqlGroup.toCqlString();
            if (result.isEmpty()) {
                result = cql;
            } else if (!cql.isEmpty()) {
                result = result + " AND " + cql;
            }
            return Collections.singletonMap(CQL_KEY, result);
        }
        if (this.options.getCqlFilters() != null) {
            this.options.getCqlFilters().forEach(field -> cqlGroup.addCqlElement(this.buildSimpleCqlParam(field.getName(), field.getValue())));
        }
        return Collections.singletonMap(CQL_KEY, cqlGroup.toCqlString());
    }

    private CqlPrintable buildLabelsCqlParam() {
        CqlPrintable labelsCql;
        if (this.options.isAllLabelsMandatory()) {
            CqlGroup labelsGroup = new CqlGroup();
            for (String label : this.options.getLabels()) {
                labelsGroup.addCqlElement(this.buildSimpleCqlParam(LABEL_NAME, label));
            }
            labelsCql = labelsGroup;
        } else {
            labelsCql = this.buildSimpleCqlParam(LABEL_NAME, this.options.getLabels());
        }
        return labelsCql;
    }

    private CqlPrintable buildApprovalCqlParam() {
        CqlPrintable approvalCql = null;
        if (TextUtils.stringSet((String)this.options.getApprovalName()) && TextUtils.stringSet((String)this.options.getApprovalStatus())) {
            String approvalFieldName = null;
            switch (this.options.getApprovalStatus().toUpperCase()) {
                case "APPROVED": {
                    approvalFieldName = APPROVED_APPROVAL_NAME;
                    break;
                }
                case "PENDING": {
                    approvalFieldName = PENDING_APPROVAL_NAME;
                    break;
                }
                case "REJECTED": {
                    approvalFieldName = REJECTED_APPROVAL_NAME;
                }
            }
            approvalCql = this.buildSimpleCqlParam(approvalFieldName, Collections.singletonList(this.options.getApprovalName()));
        } else if (TextUtils.stringSet((String)this.options.getApprovalName())) {
            List<String> approvalNameWrappedList = Collections.singletonList(this.options.getApprovalName());
            approvalCql = new CqlInnerGroup().joinOperator(CqlOperators.LogicalOperators.OR).addCqlElement(this.buildSimpleCqlParam(APPROVED_APPROVAL_NAME, approvalNameWrappedList)).addCqlElement(this.buildSimpleCqlParam(PENDING_APPROVAL_NAME, approvalNameWrappedList)).addCqlElement(this.buildSimpleCqlParam(REJECTED_APPROVAL_NAME, approvalNameWrappedList));
        }
        return approvalCql;
    }

    private CqlPrintable buildSimpleCqlParam(String name, String value) {
        if (TextUtils.stringSet((String)name) && TextUtils.stringSet((String)value)) {
            return new CqlParam(name, value);
        }
        return null;
    }

    private CqlPrintable buildSimpleCqlParam(String name, List<String> values) {
        List notEmptyValues = values.stream().filter(TextUtils::stringSet).collect(Collectors.toList());
        if (TextUtils.stringSet((String)name) && !notEmptyValues.isEmpty()) {
            return new CqlParam(name, values);
        }
        return null;
    }
}

