/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model;

import com.comalatech.confluence.workflowreports.macro.parameter.FieldListReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.ReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.StateReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.StringListReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.model.Field;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class WorkflowStatesReportOptions {
    private final List<String> spaceKeys;
    private final String parentPageId;
    private final String numberOfItemsPerPage;
    private final String columnsToShow;
    private final String sort;
    private final String sortOrder;
    private final List<String> labels;
    private final String approvalAssignedTo;
    private final String approvalName;
    private final String approvalStatus;
    private final List<String> states;
    private final List<String> workflows;
    private List<Field> cqlFilters = null;
    private String cql = null;
    private final boolean allLabelsMandatory;

    public WorkflowStatesReportOptions(List<ReportParameter> parameters) {
        HashMap<String, ReportParameterValue> paramValues = new HashMap<String, ReportParameterValue>();
        for (ReportParameter p : parameters) {
            paramValues.put(p.getKey(), p.getValue());
        }
        this.approvalAssignedTo = this.getStringValueFrom((ReportParameterValue)paramValues.get(StateReportParameters.APPROVAL_ASSIGNED_TO.getKey()));
        this.approvalName = this.getStringValueFrom((ReportParameterValue)paramValues.get(StateReportParameters.APPROVAL_NAME.getKey()));
        this.approvalStatus = this.getStringValueFrom((ReportParameterValue)paramValues.get(StateReportParameters.APPROVAL_STATUS.getKey()));
        this.numberOfItemsPerPage = this.getStringValueFrom((ReportParameterValue)paramValues.get(StateReportParameters.ITEMS_PER_PAGE.getKey()));
        this.columnsToShow = this.getStringValueFrom((ReportParameterValue)paramValues.get(StateReportParameters.COLUMNS_TO_SHOW.getKey()));
        this.sort = this.getStringValueFrom((ReportParameterValue)paramValues.get(StateReportParameters.SORT.getKey()));
        this.sortOrder = this.getStringValueFrom((ReportParameterValue)paramValues.get(StateReportParameters.SORT_ORDER.getKey()));
        this.parentPageId = this.getStringValueFrom((ReportParameterValue)paramValues.get(StateReportParameters.PARENT_PAGE.getKey()));
        this.states = this.getListValueFrom((ReportParameterValue)paramValues.get(StateReportParameters.STATE.getKey()));
        this.workflows = this.getListValueFrom((ReportParameterValue)paramValues.get(StateReportParameters.WORKFLOW.getKey()));
        ReportParameterValue cqlFilterReportParamValue = (ReportParameterValue)paramValues.get(StateReportParameters.CQL_FILTER.getKey());
        if (cqlFilterReportParamValue != null) {
            if (cqlFilterReportParamValue.getClass().equals(FieldListReportParameterValue.class)) {
                this.cqlFilters = this.getListValueFrom(cqlFilterReportParamValue);
            } else {
                this.cql = this.getStringValueFrom(cqlFilterReportParamValue);
            }
        }
        this.spaceKeys = this.getListValueFrom((ReportParameterValue)paramValues.get(StateReportParameters.SPACE.getKey()));
        boolean mandatoryLabels = false;
        this.labels = new ArrayList<String>();
        for (String label : this.getListValueFrom((ReportParameterValue)paramValues.get(StateReportParameters.LABEL.getKey()))) {
            if (label.startsWith("&")) {
                mandatoryLabels = true;
            }
            this.labels.add(StringUtils.removeStart((String)label, (String)"&"));
        }
        this.allLabelsMandatory = mandatoryLabels;
    }

    private String getStringValueFrom(ReportParameterValue value) {
        if (value instanceof StringReportParameterValue) {
            return (String)((StringReportParameterValue)value).getValue();
        }
        return null;
    }

    private List getListValueFrom(ReportParameterValue value) {
        if (value instanceof StringListReportParameterValue) {
            return (List)((StringListReportParameterValue)value).getValue();
        }
        if (value instanceof FieldListReportParameterValue) {
            return (List)((FieldListReportParameterValue)value).getValue();
        }
        return Collections.emptyList();
    }

    public String getFirstSpaceKey() {
        return CollectionUtils.isEmpty(this.spaceKeys) ? null : this.spaceKeys.get(0);
    }

    public List<String> getSpaceKeys() {
        return this.spaceKeys;
    }

    public String getParentPageId() {
        return this.parentPageId;
    }

    public boolean isSingleSpace() {
        return this.spaceKeys.size() == 1 && TextUtils.stringSet((String)this.spaceKeys.get(0));
    }

    public boolean isAllLabelsMandatory() {
        return this.allLabelsMandatory;
    }

    public String getNumberOfItemsPerPage() {
        return this.numberOfItemsPerPage;
    }

    public String getColumnsToShow() {
        return this.columnsToShow;
    }

    public String getSort() {
        return this.sort;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public String getApprovalAssignedTo() {
        return this.approvalAssignedTo;
    }

    public String getApprovalName() {
        return this.approvalName;
    }

    public String getApprovalStatus() {
        return this.approvalStatus;
    }

    public List<String> getStates() {
        return this.states;
    }

    public List<String> getWorkflows() {
        return this.workflows;
    }

    public List<Field> getCqlFilters() {
        return this.cqlFilters;
    }

    public String getCql() {
        return this.cql;
    }
}

