/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflowcontainer.SampleWorkflowStatusEnum;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.event.admin.WorkflowTemplateDeletedEvent;
import com.comalatech.workflow.event.admin.WorkflowTemplateDisabledEvent;
import com.comalatech.workflow.event.admin.WorkflowTemplateEditedEvent;
import com.comalatech.workflow.event.admin.WorkflowTemplateEnabledEvent;

public class GlobalWorkflowActionsListener
extends WorkflowsListener {
    private WorkflowContainerManager workflowContainerManager;

    public GlobalWorkflowActionsListener(EventPublisher eventPublisher, WorkflowContainerManager workflowContainerManager) {
        super(eventPublisher);
        this.workflowContainerManager = workflowContainerManager;
    }

    @EventListener
    public void globalWorkflowDisabledEvent(WorkflowTemplateDisabledEvent disabledEvent) {
        Workflow workflow = (Workflow)disabledEvent.getWorkflow();
        if (this.isSampleWorkflow(workflow)) {
            this.workflowContainerManager.setSampleWorkflowDisabled(workflow);
        }
    }

    @EventListener
    public void globalWorkflowEnabledEvent(WorkflowTemplateEnabledEvent enabledEvent) {
        Workflow workflow = (Workflow)enabledEvent.getWorkflow();
        if (this.isSampleWorkflow(workflow)) {
            this.workflowContainerManager.setSampleWorkflowEnabled(workflow);
        }
    }

    @EventListener
    public void globalWorkflowRemovedEvent(WorkflowTemplateDeletedEvent deletedEvent) {
        Workflow workflow = (Workflow)deletedEvent.getWorkflow();
        if (this.isSampleWorkflow(workflow)) {
            this.workflowContainerManager.setSampleWorkflowRemoved(workflow);
        }
    }

    @EventListener
    public void globalWorkflowAddedEvent(WorkflowTemplateEditedEvent createEvent) {
        SampleWorkflowStatusEnum status;
        Workflow workflow = (Workflow)createEvent.getWorkflow();
        if (this.isSampleWorkflow(workflow) && (status = this.workflowContainerManager.getSampleWorkflowStatus(workflow)) != SampleWorkflowStatusEnum.DISABLED) {
            this.workflowContainerManager.setSampleWorkflowEnabled(workflow);
        }
    }

    private boolean isSampleWorkflow(Workflow workflow) {
        return this.workflowContainerManager.getSampleWorkflowNames().contains(workflow.getName());
    }
}

