/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import com.comalatech.confluence.workflowcontainer.action.RepositoryActionHelper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;

public class GlobalWorkflowsRepositoryAction
extends ConfluenceActionSupport
implements InitializingBean {
    private RepositoryActionHelper repositoryActionHelper = new RepositoryActionHelper();
    private AdhocWorkflowsLicenseManager licenseManager;
    private WorkflowStatisticsManager workflowStatisticsManager;
    private String docoUrl = "https://apps.appf.re/cdmdc/doc/importglobalworkflows/Wnf4zv";

    public String execute() throws Exception {
        return "success";
    }

    public String install() throws Exception {
        return this.repositoryActionHelper.install();
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    private boolean isConfluenceAdministrator() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    @ParameterSafe
    public void setCategory(String category) {
        this.repositoryActionHelper.setCategory(category);
    }

    @ParameterSafe
    public void setReload(boolean reload) {
        this.repositoryActionHelper.setReload(reload);
    }

    @ParameterSafe
    public void setWorkflowId(String workflowId) {
        this.repositoryActionHelper.setWorkflowId(workflowId);
    }

    public void afterPropertiesSet() throws Exception {
        PluginContainerManager.autowireComponent(this.repositoryActionHelper);
    }

    public RepositoryActionHelper getRepositoryActionHelper() {
        return this.repositoryActionHelper;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public WorkflowStatisticsManager getWorkflowStatisticsManager() {
        return this.workflowStatisticsManager;
    }

    public void setWorkflowStatisticsManager(WorkflowStatisticsManager workflowStatisticsManager) {
        this.workflowStatisticsManager = workflowStatisticsManager;
    }

    public String getDocoUrl() {
        return this.docoUrl;
    }
}

