/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.supportconsole.commands;

import com.comalatech.confluence.workflow.supportconsole.commands.contract.SupportGeneratorCommand;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.confluence.workflow.supportconsole.model.contract.SupportData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSupportGeneratorCommandImplementation
implements SupportGeneratorCommand {
    private static final Logger log = LoggerFactory.getLogger(AbstractSupportGeneratorCommandImplementation.class);
    protected final SupportPresenter templateFileLayoutHelper;

    public AbstractSupportGeneratorCommandImplementation(SupportPresenter templateFileLayoutHelper) {
        this.templateFileLayoutHelper = templateFileLayoutHelper;
    }

    protected void basicGenerateSupportFile(SupportData data, Path baseFolder, String template) {
        try {
            Path globalConfigFilePath = Paths.get(baseFolder.toString(), data.getFilename());
            this.basicWriteFile(data, globalConfigFilePath, template);
        }
        catch (Exception e) {
            log.warn("Cannot generate support file for " + data.getLogClassName() + " data", (Throwable)e);
        }
    }

    protected <T> void basicWriteFile(T data, Path path, String template) throws IOException {
        String templatedReport = this.templateFileLayoutHelper.toText(template, data);
        Path filePath = Files.createFile(path, new FileAttribute[0]);
        Files.write(filePath, templatedReport.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

