/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.resources;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.onboard.OnboardingManager;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/onboard")
public class OnboardingResource {
    private static final Logger log = LoggerFactory.getLogger(OnboardingResource.class);
    private final OnboardingManager onboardingManager;

    public OnboardingResource(OnboardingManager onboardingManager) {
        this.onboardingManager = onboardingManager;
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/hide")
    @POST
    public Response hideOnboardPanel() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        try {
            this.onboardingManager.savePageHideCheck(user);
        }
        catch (Exception e) {
            log.error("Error saving onboarding Do Not Show flag for user {} , {}", (Object)user, (Object)e);
            return Response.serverError().build();
        }
        return Response.created((URI)URI.create("")).build();
    }
}

