/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers;

import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.states.model.DueDateWorkflowElement;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.restv2.model.RestCondition;
import com.comalatech.confluence.workflow.restv2.model.mappers.MapperException;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public interface Mapper<E, R> {
    public R toRest(E var1);

    public E fromRest(R var1);

    default public List<RestCondition> parseConditionsToRest(List<Condition> conditions) {
        ArrayList<RestCondition> restConditions = new ArrayList<RestCondition>();
        if (conditions != null && !conditions.isEmpty()) {
            restConditions.addAll(conditions.stream().map(Mappers.conditionMapper::toRest).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return restConditions;
    }

    default public List<Condition> parseConditionsFromRest(List<RestCondition> restConditions) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (restConditions != null && !restConditions.isEmpty()) {
            conditions.addAll(restConditions.stream().map(Mappers.conditionMapper::fromRest).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return conditions;
    }

    default public void parseDueDateFromRest(String restDueDate, E entity) {
        if (entity instanceof DueDateWorkflowElement) {
            try {
                ((DueDateWorkflowElement)entity).setDueDate(restDueDate);
            }
            catch (MacroException iaEx) {
                throw new MapperException("Invalid Period " + restDueDate + ". It must follow ISO8601 Duration Format");
            }
        }
    }
}

