/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.service.StateActivityService;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.BooleanCondition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import java.util.List;

public class StateInitializedCondition
extends BooleanCondition {
    public StateInitializedCondition(boolean not, String value) {
        super(not, value);
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        macro.addParameter("initial", (Object)(!this.not ? 1 : 0));
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        if (this.not) {
            return false;
        }
        AbstractPage page = valueStore.getPage();
        PageState latestState = this.getStateAccessor().getLatestState(page);
        if (latestState == null) {
            return false;
        }
        if (this.getDocumentActivityUpgradeService().hasAlreadyBeenUpgraded(page)) {
            return this.getStateActivityService().getStatesByName(page.getId(), latestState.getName()).size() == 1;
        }
        List<PageState> pageStates = this.getStateAccessor().getPageStates(page);
        return pageStates.stream().filter(pState -> pState.getState().equals(latestState.getName())).count() == 1L;
    }

    @Override
    public String toString(ValueStore valueStore) {
        return this.not ? "Has a current state" : "Page's state is set the first time";
    }

    private StateAccessor getStateAccessor() {
        return PluginContainerManager.getComponent("stateAccessor", StateAccessor.class);
    }

    private StateActivityService getStateActivityService() {
        return PluginContainerManager.getComponent("stateActivityService", StateActivityService.class);
    }
}

