/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.ipc.api.DefaultStateService;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.macros.actions.AbstractActionMacro;
import com.comalatech.confluence.workflow.macros.templates.MacroParameters;
import com.comalatech.confluence.workflow.model.StateInDraftSpaceCondition;
import com.comalatech.workflow.StateService;
import com.opensymphony.util.TextUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetStateMacro
extends AbstractActionMacro {
    private static final Logger log = LoggerFactory.getLogger(SetStateMacro.class);
    private WorkflowAccessor workflowAccessor;
    private StateService stateService;

    @Override
    protected String getName() {
        return "set-state";
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        if (!this.inExecuteMode(renderContext)) {
            return "";
        }
        List<AbstractPage> pages = this.getPagesFromParams(parameters, renderContext);
        for (AbstractPage page : pages) {
            try {
                StatesContainer statesContainer;
                PageWorkflows pageWorkflows = this.workflowAccessor.getWorkflows(page);
                if (pageWorkflows == null) continue;
                ValueStore valueStore = pageWorkflows.getValueStore();
                Parameters params = new Parameters(parameters, renderContext, valueStore);
                if (params.draftSpace) {
                    Page draftPage = StateInDraftSpaceCondition.getPageInDraftSpace(valueStore);
                    if (draftPage == null) {
                        log.warn("there is no draft page for " + page);
                        return "";
                    }
                    page = draftPage;
                    valueStore = this.workflowAccessor.getWorkflows(page).getValueStore();
                    pageWorkflows = valueStore.getPageWorkflows();
                }
                if ((statesContainer = pageWorkflows.getStatesContainer()) == null) {
                    throw new WorkflowException("The are no states defined for page " + page.getTitle());
                }
                State state1 = statesContainer.getState(params.stateName);
                if (state1 == null) {
                    throw new WorkflowException("Invalid state name '" + params.stateName + "'");
                }
                ((DefaultStateService)this.stateService).setState((ContentEntityObject)page, params.stateName, params.comment, false);
            }
            catch (MacroException | com.comalatech.workflow.WorkflowException e) {
                this.logMessage(renderContext, (Exception)e);
            }
        }
        return "";
    }

    public void setWorkflowAccessor(WorkflowAccessor workflowAccessor) {
        this.workflowAccessor = workflowAccessor;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }

    private static class Parameters
    extends MacroParameters {
        String stateName = this.get(new String[]{"state", "0"});
        String comment;
        boolean approved = this.getFlagWithDefault("approved", true);
        boolean draftSpace = this.getFlagWithDefault(new String[]{"draft", "draftspace"}, false);

        private Parameters(Map map, RenderContext renderContext, ValueStore valueStore) throws MacroException, WorkflowException {
            super(map, renderContext);
            this.comment = this.get("comment", false);
            if (TextUtils.stringSet((String)this.comment)) {
                this.comment = this.replaceReferences(renderContext, this.comment);
            }
            if (!TextUtils.stringSet((String)this.stateName)) {
                if (valueStore.getPageState() == null) {
                    throw new WorkflowException("No state defined");
                }
                this.stateName = valueStore.getPageState().getState();
            }
        }

        public String replaceReferences(RenderContext renderContext, String body) {
            ValueStore valueStore = (ValueStore)renderContext.getParam((Object)"valueStore");
            return valueStore.replaceReferences(body);
        }
    }
}

