/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.documentReport;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.dataextractor.model.UserContentPropertyModel;
import com.comalatech.confluence.workflow.documentReport.DocumentReportService;
import com.comalatech.confluence.workflow.restv2.model.documentreport.DocumentReport;
import com.comalatech.confluence.workflow.restv2.model.documentreport.WorkflowsReportData;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.ApprovalsMapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.DocumentReportJsonPropertyMapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.ReadAckMapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.UserApprovalsMapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.UsersMapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.WorkflowsMapper;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentReportServiceImpl
implements DocumentReportService {
    private static final Logger log = LoggerFactory.getLogger(DocumentReportServiceImpl.class);
    private final List<DocumentReportJsonPropertyMapper> mapperList = new ArrayList<DocumentReportJsonPropertyMapper>();
    private final WorkflowUserAccessor workflowUserAccessor;

    public DocumentReportServiceImpl(UserAccessor userAccessor, WorkflowUserAccessor workflowUserAccessor) {
        this.mapperList.add(new WorkflowsMapper());
        this.mapperList.add(new UsersMapper(userAccessor));
        this.mapperList.add(new ApprovalsMapper());
        this.mapperList.add(new UserApprovalsMapper(userAccessor));
        this.mapperList.add(new ReadAckMapper());
        this.workflowUserAccessor = workflowUserAccessor;
    }

    @Override
    public DocumentReport buildDocumentReportModelFromCqlResponse(SearchPageResponse<SearchResult> searchResults) {
        DocumentReport documentReport = new DocumentReport();
        try {
            this.setPaginationMetadata(searchResults, documentReport);
            for (SearchResult result : searchResults) {
                WorkflowsReportData workflowsReportData = new WorkflowsReportData();
                Content contentEntity = (Content)result.getEntity();
                EnrichableMap properties = (EnrichableMap)contentEntity.getMetadata().get("properties");
                this.extractMetadataProperties((EnrichableMap<String, JsonContentProperty>)properties, workflowsReportData);
                documentReport.workflowsReportList.add(workflowsReportData);
                this.updateContentData(result, contentEntity, workflowsReportData);
                this.updateUserData(workflowsReportData);
            }
        }
        catch (Exception ex) {
            log.warn("Could not be able to parse report data from CQL response {} ", searchResults, (Object)ex);
        }
        return documentReport;
    }

    private void extractMetadataProperties(EnrichableMap<String, JsonContentProperty> properties, WorkflowsReportData workflowsReportData) {
        for (Map.Entry propertyNamePropertyDataEntry : properties.entrySet()) {
            String key = (String)propertyNamePropertyDataEntry.getKey();
            String json = ((JsonContentProperty)propertyNamePropertyDataEntry.getValue()).getValue().getValue();
            this.applyMapper(key, json, workflowsReportData);
        }
    }

    private void updateContentData(SearchResult result, Content contentEntity, WorkflowsReportData workflowsReportData) {
        workflowsReportData.contentData.iconCssClass = result.getIconCssClass();
        workflowsReportData.contentData.title = result.getTitle();
        workflowsReportData.contentData.url = result.getUrl();
        workflowsReportData.contentData.updated = result.getLastModified().toDate();
        workflowsReportData.contentData.id = contentEntity.getId().asLong();
        workflowsReportData.contentData.type = contentEntity.getType().getType();
        Person lastUpdatedBy = ((Version)contentEntity.getHistory().getLastUpdatedRef().get()).getBy();
        workflowsReportData.contentData.lastUpdatedBy = this.getUserData(lastUpdatedBy);
        workflowsReportData.contentData.created = contentEntity.getHistory().getCreatedDate().toDate();
        Person createdBy = contentEntity.getHistory().getCreatedBy();
        workflowsReportData.contentData.createdBy = this.getUserData(createdBy);
        try {
            workflowsReportData.contentData.spaceKey = contentEntity.getSpace() != null ? contentEntity.getSpace().getKey() : null;
            workflowsReportData.contentData.spaceTitle = contentEntity.getSpace() != null ? contentEntity.getSpace().getName() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateUserData(WorkflowsReportData workflowsReportData) {
        if ("com.comalatech.workflow".equals(workflowsReportData.currentStateStartedBy)) {
            ConfluenceUser user = this.workflowUserAccessor.getAddonUser();
            workflowsReportData.currentStateStartedBy = user.getName();
            workflowsReportData.currentStateStartedByInfo.displayName = user.getFullName();
            workflowsReportData.currentStateStartedByInfo.profilePicture.path = this.workflowUserAccessor.getAddonUserAvatarPath();
            workflowsReportData.currentStateStartedByInfo.userName = user.getName();
            workflowsReportData.currentStateStartedByInfo.showAsLink = false;
        }
    }

    private UserContentPropertyModel getUserData(Person person) {
        UserContentPropertyModel userData = new UserContentPropertyModel();
        userData.userName = (String)person.getOptionalUsername().getOrNull();
        userData.displayName = person.getDisplayName();
        userData.profilePicture = new UserContentPropertyModel.ProfilePictureContentPropertyModel(person.getProfilePicture().getPath());
        UserKey lastUpdatedUserkey = (UserKey)person.getUserKey().getOrNull();
        if (lastUpdatedUserkey != null) {
            userData.userKeyProperty = lastUpdatedUserkey.getStringValue();
        }
        userData.showAsLink = userData.userName != null;
        return userData;
    }

    private void setPaginationMetadata(SearchPageResponse<SearchResult> searchResults, DocumentReport documentReport) {
        documentReport.limit = searchResults.getPageRequest().getLimit();
        documentReport.start = searchResults.getPageRequest().getStart();
        documentReport.size = searchResults.size();
        documentReport.totalSize = searchResults.totalSize();
    }

    private void applyMapper(String key, String json, WorkflowsReportData data) {
        this.mapperList.forEach(documentRepoMapper -> documentRepoMapper.map(key, json, data));
    }
}

