/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.compat.setup.xstream.XStreamManagerCompat;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import com.comalatech.confluence.documentActions.model.DocumentActionsDashboard;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.tasks.model.StateTasksMode;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.model.WorkflowConfiguration;
import com.comalatech.confluence.workflowcontainer.model.RequireApprovalComment;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import com.comalatech.workflow.WorkflowConfigurationService;
import com.comalatech.workflow.model.MacroTransformStatus;
import com.comalatech.workflow.model.PageUpdateResetApprovalStatus;
import com.comalatech.workflow.model.TasksMode;
import com.comalatech.workflow.model.WorkflowVisibility;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowConfigurationManager
implements WorkflowConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowConfigurationManager.class);
    private static final String OLD_WORKFLOW_CONFIG_KEY = "com.comalatech.workflow.config";
    private static final String WORKFLOW_CONFIG_KEY = "com.comalatech.workflow.config.3.1";
    private static final String WORKFLOW_HISTORY_VISIBILITY = "com.comalatech.workflow.config.history.page";
    private static final String WORKFLOW_IMPORTERS_GROUP = "com.comalatech.workflow.importers";
    private static final String WORKFLOW_TASKSMODE = "com.comalatech.workflow.tasksmode";
    private static final String WORKFLOW_STATETASKMODE = "com.comalatech.workflow.tasksinspace";
    private static final String WORKFLOW_DEFAULT_APPROVALWORKFLOW = "com.comalatech.workflow.defaultapprovalworkflow";
    private static final String WORKFLOW_REQUIRE_APPROVAL_COMMENT = "com.comalatech.workflow.requireApprovalComment";
    private static final String WORKFLOW_EMAILANYONE = "com.comalatech.workflow.emailanyone";
    private static final String WORKFLOW_MACRO_TRANSFORM_ENABLE = "com.comalatech.workflow.macrotransformenable";
    private static final String WORKFLOW_PAGE_UPDATE_APPROVAL_RESET = "com.comalatech.workflow.pageupdateapprovalreset";
    private static final String MAVEN_CONFIG_PLUGIN_KEY = "key";
    private static final String MAVEN_CONFIG_VERSION = "version";
    private static final String VIEW_DRAFT_BY_DEFAULT_KEY = "com.comalatech.workflow.config.viewdraft";
    private static final String WORKFLOW_AUDIT_LOGGING = "com.comalatech.workflow.config.auditlogging";
    private static final String DEFAULT_WORKFLOW_NAME = "Simple approval workflow";
    private static final String DEFAULT_IMPORTER_GROUP = "approvalsworkflow.configuration.conflenceUsers";
    private static final String WORKFLOW_CONFIG_SNAPSHOTS_CREATION_ENABLE = "com.comalatech.workflow.config.snapshots.creation.enable";
    private static final String ONBOARD_ENABLED_KEY = "com.comalatech.worflow.onboard.enable";
    private static final String ONBOARD_TOP_BAR_ENABLED_KEY = "com.comalatech.workflow.onboard.top.bar.enable";
    private static final String WORKFLOW_TRANSLATOR_ENABLED_KEY = "com.comalatech.worflow.translator.enable";
    private static final String DOCUMENT_ACTIONS_DASHBOARD_ENABLED_KEY = "com.comalatech.worflow.documentActions.dashboard.enable";
    private static final int MAX_REQUESTS = 20;
    private static final int THRESHOLD_IN_SECONDS = 20;
    private static final boolean VIEW_DRAFT_BY_DEFAULT_DEFAULT_VALUE = true;
    private static final boolean SNAPSHOTS_CREATION_ENABLED_DEFAULT_VALUE = false;
    private final BandanaManager bandanaManager;
    private final GroupManager groupManager;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final XStreamManagerCompat xStreamManagerCompat;
    private final ReadWriteTransactionService transactionService;
    private final BandanaContext bandanaContext = ConfluenceBandanaContext.GLOBAL_CONTEXT;
    private Properties mavenConfigurationProperties;
    private int pluginVersionNumber = 0;
    private String pluginVersion = "";
    private String workflowVersionNumber = "";
    private String workflowVersionName = "";

    public WorkflowConfigurationManager(BandanaManager bandanaManager, GroupManager groupManager, WorkflowsFeatureManager workflowsFeatureManager, XStreamManagerCompat xStreamManagerCompat, ReadWriteTransactionService transactionService) {
        this.bandanaManager = bandanaManager;
        this.groupManager = groupManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.xStreamManagerCompat = xStreamManagerCompat;
        this.transactionService = transactionService;
        this.initConfluenceLicense();
        this.initMavenConfigurationParams();
    }

    public WorkflowConfigurationManager initMavenConfigurationParams() {
        String pluginPropertiesFile = "templates/plugin.properties";
        this.mavenConfigurationProperties = new Properties();
        try {
            this.mavenConfigurationProperties.load(this.getClass().getClassLoader().getResourceAsStream("templates/plugin.properties"));
        }
        catch (IOException e) {
            log.error("Error loading file: templates/plugin.properties", (Throwable)e);
        }
        String mavenKey = this.mavenConfigurationProperties.getProperty(MAVEN_CONFIG_PLUGIN_KEY);
        String mavenVersion = this.mavenConfigurationProperties.getProperty(MAVEN_CONFIG_VERSION).trim().replace(" ", "");
        try {
            String[] versionComponents = mavenVersion.split("[\\s@&.?$+-]+");
            String cleanVersion = IntStream.rangeClosed(0, 2).mapToObj(i -> versionComponents[i]).filter(component -> StringUtils.isNumeric((String)component)).map(version -> StringUtils.rightPad((String)version, (int)2, (String)"0")).collect(Collectors.joining());
            this.pluginVersionNumber = Integer.parseInt(cleanVersion);
        }
        catch (NumberFormatException nfex) {
            log.error("Error parsing version from maven properties: " + mavenVersion, (Throwable)nfex);
        }
        this.pluginVersion = this.workflowsFeatureManager.getAppPrefix(mavenKey) + "_" + mavenVersion;
        this.workflowVersionName = this.workflowsFeatureManager.getAppName(mavenKey);
        this.workflowVersionNumber = mavenVersion;
        return this;
    }

    private void initConfluenceLicense() {
        License confluenceLicense = LicenseManager.getInstance().getLicense("CONF");
        if (confluenceLicense != null) {
            WorkflowConfiguration.setOrganisation(confluenceLicense.getOrganisation());
            WorkflowConfiguration.setConfluenceUsers(confluenceLicense.getUsers());
        } else {
            WorkflowConfiguration.setOrganisation("Demo");
            WorkflowConfiguration.setConfluenceUsers(9999);
        }
    }

    @Override
    public WorkflowVisibility getWorkflowVisibility(Space space) {
        WorkflowVisibilityInternal workflowVisibilityInternal = this.getHistoryVisibility(space.getKey());
        return WorkflowVisibilityInternal.internalToPublic(workflowVisibilityInternal);
    }

    @Override
    public WorkflowVisibility getEffectiveWorkflowVisibility(Space space) {
        WorkflowVisibilityInternal visibilityInternal = this.getHistoryVisibility(space.getKey(), true);
        if (WorkflowVisibilityInternal.ANY.equals((Object)visibilityInternal)) {
            return WorkflowVisibility.ANY;
        }
        return WorkflowVisibility.CONTRIBUTORS;
    }

    @Override
    public void setWorkflowVisibility(Space space, WorkflowVisibility workflowVisibility) {
        WorkflowVisibilityInternal visibilityInternal = WorkflowVisibilityInternal.publicToInternal(workflowVisibility);
        this.setHistoryVisibility(space.getKey(), visibilityInternal);
    }

    @Override
    public PageUpdateResetApprovalStatus getResetApprovalStatus(Space space) {
        return this.getResetApprovalStatus(space.getKey(), false);
    }

    @Override
    public PageUpdateResetApprovalStatus getEffectiveResetApprovalStatus(Space space) {
        if (this.isPageUpdateApprovalReset(space.getKey())) {
            return PageUpdateResetApprovalStatus.RESET;
        }
        return PageUpdateResetApprovalStatus.IGNORE;
    }

    @Override
    public void setResetApprovalStatus(Space space, PageUpdateResetApprovalStatus pageUpdateResetApprovalStatus) {
        this.setResetApprovalStatus(space.getKey(), pageUpdateResetApprovalStatus);
    }

    @Override
    public TasksMode getTasksMode(Space space) {
        return this.getTasksMode(space.getKey(), false);
    }

    @Override
    public TasksMode getEffectiveTasksMode(Space space) {
        TasksMode mode = this.getTasksMode(space.getKey(), true);
        if (TasksMode.STRICT.equals((Object)mode)) {
            return TasksMode.STRICT;
        }
        return TasksMode.LENIENT;
    }

    @Override
    public void setTasksMode(Space space, TasksMode tasksMode) {
        this.setTasksMode(space.getKey(), tasksMode);
    }

    @Override
    public boolean isViewDraftByDefault(Space space) {
        String value = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(space), VIEW_DRAFT_BY_DEFAULT_KEY, true);
        if (this.workflowsFeatureManager.isWorkflowsApp()) {
            return !Boolean.FALSE.toString().equalsIgnoreCase(value);
        }
        return true;
    }

    @Override
    public void setViewDraftByDefault(Space space, boolean value) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(space), VIEW_DRAFT_BY_DEFAULT_KEY, (Object)Boolean.toString(value));
    }

    @Override
    public MacroTransformStatus getMacroTransformStatus(Space space) {
        return this.getMacroTransformEnable(space.getKey(), false);
    }

    @Override
    public MacroTransformStatus getEffectiveMacroTransformStatus(Space space) {
        MacroTransformStatus status = this.getMacroTransformEnable(space.getKey(), true);
        if (MacroTransformStatus.ENABLED.equals((Object)status)) {
            return MacroTransformStatus.ENABLED;
        }
        return MacroTransformStatus.DISABLED;
    }

    @Override
    public void setMacroTransformStatus(Space space, MacroTransformStatus macroTransformStatus) {
        this.setMacroTransformEnable(space.getKey(), macroTransformStatus);
    }

    @Override
    public boolean isSnapshotsCreationEnabled(Space space) {
        String value = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(space), WORKFLOW_CONFIG_SNAPSHOTS_CREATION_ENABLE, true);
        if (this.workflowsFeatureManager.isWorkflowsApp()) {
            return Boolean.TRUE.toString().equalsIgnoreCase(value);
        }
        return false;
    }

    @Override
    public void setSnapshotsCreationEnabled(Space space, boolean isAutoSnapshotEnabled) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(space), WORKFLOW_CONFIG_SNAPSHOTS_CREATION_ENABLE, (Object)Boolean.toString(isAutoSnapshotEnabled));
    }

    private WorkflowConfiguration createDefaultConfiguration() {
        WorkflowConfiguration conf = new WorkflowConfiguration();
        conf.setPageApprovalsSpaceKeys(new String[]{"ANY"});
        conf.setSpaceWorkflowSpaceKeys(new String[]{"ANY"});
        conf.setPageApprovalsRestricted(false);
        conf.setSpaceWorkflowRestricted(false);
        conf.setVersion("0");
        conf.setMaxEvents(20);
        conf.setThresholdInSeconds(20);
        return conf;
    }

    private Void saveConfiguration(WorkflowConfiguration workflowConfiguration, boolean loaded) {
        this.initStateWorkflowConfiguration(!loaded);
        if (!loaded) {
            this.saveConfiguration(workflowConfiguration);
        }
        return null;
    }

    private Void safeSaveConfiguration(WorkflowConfiguration workflowConfiguration, boolean loaded) {
        return this.transactionService.executeInReadWriteTransaction(() -> this.saveConfiguration(workflowConfiguration, loaded));
    }

    public WorkflowConfiguration getConfiguration() {
        WorkflowConfiguration workflowConfiguration;
        boolean loaded = false;
        boolean upgrade = false;
        String rawConfig = (String)this.bandanaManager.getValue(this.bandanaContext, WORKFLOW_CONFIG_KEY);
        if (!TextUtils.stringSet((String)rawConfig)) {
            rawConfig = (String)this.bandanaManager.getValue(this.bandanaContext, OLD_WORKFLOW_CONFIG_KEY);
            upgrade = true;
        }
        if (!TextUtils.stringSet((String)rawConfig)) {
            workflowConfiguration = this.createDefaultConfiguration();
        } else {
            try {
                workflowConfiguration = (WorkflowConfiguration)this.xStreamManagerCompat.fromXML(rawConfig);
                if (upgrade) {
                    log.warn("Upgrading configuration");
                    workflowConfiguration.setSpaceWorkflowSpaceKeys(new String[]{"ANY"});
                    workflowConfiguration.setSpaceWorkflowRestricted(false);
                    this.saveConfiguration(workflowConfiguration);
                }
                loaded = true;
            }
            catch (Exception e) {
                log.error("Error getting the global workflow configuration: " + e.getMessage());
                workflowConfiguration = this.createDefaultConfiguration();
            }
        }
        workflowConfiguration.init();
        this.safeSaveConfiguration(workflowConfiguration, loaded);
        workflowConfiguration.setPluginVersion(this.getPluginVersion());
        workflowConfiguration.setPluginVersionNumber(this.getPluginVersionNumber());
        workflowConfiguration.setWorkflowVersionNumber(this.getWorkflowVersionNumber());
        workflowConfiguration.setWorkflowVersionName(this.getWorkflowVersionName());
        workflowConfiguration.setWorkflowAuthor(this.getWorkflowVersionName());
        workflowConfiguration.setWorkflowLogo(this.workflowsFeatureManager.getAppLogoName(null));
        return workflowConfiguration;
    }

    public int getPluginVersionNumber() {
        return this.pluginVersionNumber;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public String getWorkflowVersionNumber() {
        return this.workflowVersionNumber;
    }

    public String getWorkflowVersionName() {
        return this.workflowVersionName;
    }

    public String getImportersGroup() {
        String bandanaImportersGroup = (String)this.bandanaManager.getValue(this.bandanaContext, WORKFLOW_IMPORTERS_GROUP);
        if (!TextUtils.stringSet((String)bandanaImportersGroup)) {
            return ConfluenceActionSupport.getTextStatic((String)DEFAULT_IMPORTER_GROUP);
        }
        return bandanaImportersGroup;
    }

    public void setImportersGroup(String group) {
        if (!TextUtils.stringSet((String)group)) {
            group = ConfluenceActionSupport.getTextStatic((String)DEFAULT_IMPORTER_GROUP);
        }
        this.bandanaManager.setValue(this.bandanaContext, WORKFLOW_IMPORTERS_GROUP, (Object)group);
    }

    public boolean canImportWorkflows(ConfluenceUser user) {
        if (user == null) {
            return false;
        }
        String importersGroup = this.getImportersGroup();
        try {
            Group group = this.groupManager.getGroup(importersGroup);
            return group == null || this.groupManager.hasMembership(group, (User)user);
        }
        catch (EntityException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public void setAuditLoggingEnabled(boolean enabled) {
        this.bandanaManager.setValue(this.bandanaContext, WORKFLOW_AUDIT_LOGGING, (Object)enabled);
    }

    public Boolean isAuditLoggingEnabled() {
        Boolean bandanaAuditLoggingEnabled = (Boolean)this.bandanaManager.getValue(this.bandanaContext, WORKFLOW_AUDIT_LOGGING);
        if (bandanaAuditLoggingEnabled == null) {
            return false;
        }
        return bandanaAuditLoggingEnabled;
    }

    public boolean isEmailAnyone() {
        return Boolean.TRUE.toString().equals(this.bandanaManager.getValue(this.bandanaContext, WORKFLOW_EMAILANYONE));
    }

    public void setEmailAnyone(boolean emailAnyoneAllowed) {
        this.bandanaManager.setValue(this.bandanaContext, WORKFLOW_EMAILANYONE, (Object)Boolean.toString(emailAnyoneAllowed));
    }

    public TasksMode getTasksMode(String spaceKey, boolean lookupUp) {
        String bandanaTasksMode;
        if (TextUtils.stringSet((String)spaceKey)) {
            String mode = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), WORKFLOW_TASKSMODE, lookupUp);
            TasksMode tasksMode = this.tasksModeParse(mode);
            if (!lookupUp || tasksMode != TasksMode.DEFAULT) {
                return tasksMode;
            }
        }
        if (!TextUtils.stringSet((String)(bandanaTasksMode = (String)this.bandanaManager.getValue(this.bandanaContext, WORKFLOW_TASKSMODE)))) {
            return TasksMode.LENIENT;
        }
        return this.tasksModeParse(bandanaTasksMode);
    }

    private TasksMode tasksModeParse(String mode) {
        if (TasksMode.STRICT.toString().equalsIgnoreCase(mode)) {
            return TasksMode.STRICT;
        }
        if (TasksMode.LENIENT.toString().equalsIgnoreCase(mode)) {
            return TasksMode.LENIENT;
        }
        return TasksMode.DEFAULT;
    }

    public void setTasksMode(String spaceKey, TasksMode tasksMode) {
        ConfluenceBandanaContext context = new ConfluenceBandanaContext(spaceKey);
        if (tasksMode == TasksMode.DEFAULT && this.bandanaManager.getValue((BandanaContext)context, WORKFLOW_TASKSMODE) == null) {
            return;
        }
        this.bandanaManager.setValue((BandanaContext)context, WORKFLOW_TASKSMODE, (Object)tasksMode.toString());
    }

    public StateTasksMode getStateTasksMode(String spaceKey, boolean lookup) {
        if (TextUtils.stringSet((String)spaceKey)) {
            String modeName = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), WORKFLOW_STATETASKMODE, lookup);
            return StateTasksMode.parse(modeName);
        }
        String bandanaStateTasksMode = (String)this.bandanaManager.getValue(this.bandanaContext, WORKFLOW_STATETASKMODE);
        if (bandanaStateTasksMode == null) {
            return StateTasksMode.RESET;
        }
        return StateTasksMode.parse(bandanaStateTasksMode);
    }

    public void setStateTasksMode(String spaceKey, StateTasksMode mode) {
        ConfluenceBandanaContext context = new ConfluenceBandanaContext(spaceKey);
        if (mode == StateTasksMode.DEFAULT && spaceKey != null) {
            this.bandanaManager.removeValue((BandanaContext)context, WORKFLOW_STATETASKMODE);
            return;
        }
        this.bandanaManager.setValue((BandanaContext)context, WORKFLOW_STATETASKMODE, (Object)mode.toString());
    }

    public String getDefaultApprovalWorkflow(String spaceKey, boolean lookup) {
        if (TextUtils.stringSet((String)spaceKey)) {
            return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), WORKFLOW_DEFAULT_APPROVALWORKFLOW, lookup);
        }
        String bandanaDefaultApprovalWorkflow = (String)this.bandanaManager.getValue(this.bandanaContext, WORKFLOW_DEFAULT_APPROVALWORKFLOW);
        if (bandanaDefaultApprovalWorkflow == null) {
            return DEFAULT_WORKFLOW_NAME;
        }
        return bandanaDefaultApprovalWorkflow;
    }

    public void setDefaultApprovalWorkflow(String spaceKey, String workflowName) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), WORKFLOW_DEFAULT_APPROVALWORKFLOW, (Object)workflowName);
    }

    public RequireApprovalComment getRequireApprovalComment(boolean lookup) {
        String requireApprovalComment = (String)this.bandanaManager.getValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, WORKFLOW_REQUIRE_APPROVAL_COMMENT, lookup);
        return requireApprovalComment != null ? RequireApprovalComment.valueOf(requireApprovalComment) : RequireApprovalComment.OPTIONAL;
    }

    public void setRequireApprovalComment(RequireApprovalComment requireApprovalComment) {
        ComalatechBandanaContext context = ComalatechBandanaContext.COMALATECH_CONTEXT;
        if (requireApprovalComment == RequireApprovalComment.OPTIONAL) {
            this.bandanaManager.removeValue((BandanaContext)context, WORKFLOW_REQUIRE_APPROVAL_COMMENT);
        } else {
            this.bandanaManager.setValue((BandanaContext)context, WORKFLOW_REQUIRE_APPROVAL_COMMENT, (Object)requireApprovalComment.toString());
        }
    }

    private void initStateWorkflowConfiguration(boolean newInstallation) {
        String modeName = (String)this.bandanaManager.getValue(this.bandanaContext, WORKFLOW_STATETASKMODE);
        if (modeName != null) {
            return;
        }
        if (newInstallation) {
            this.bandanaManager.setValue(this.bandanaContext, WORKFLOW_STATETASKMODE, (Object)StateTasksMode.MOVE.toString());
        } else {
            this.bandanaManager.setValue(this.bandanaContext, WORKFLOW_STATETASKMODE, (Object)StateTasksMode.RESET.toString());
        }
    }

    public WorkflowVisibilityInternal getHistoryVisibility() {
        return this.getHistoryVisibility(null, true);
    }

    public WorkflowVisibilityInternal getHistoryVisibility(String spaceKey) {
        return this.getHistoryVisibility(spaceKey, true);
    }

    public WorkflowVisibilityInternal getHistoryVisibility(String spaceKey, boolean lookupGlobal) {
        WorkflowVisibilityInternal workflowVisibility = null;
        if (TextUtils.stringSet((String)spaceKey) && this.workflowsFeatureManager.isWorkflowsApp()) {
            String spaceVisibility = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), WORKFLOW_HISTORY_VISIBILITY, false);
            workflowVisibility = WorkflowVisibilityInternal.parse(spaceVisibility);
        }
        if (workflowVisibility == null || WorkflowVisibilityInternal.DEFAULT.equals((Object)workflowVisibility)) {
            if (lookupGlobal) {
                String globalVisibility = (String)this.bandanaManager.getValue(this.bandanaContext, WORKFLOW_HISTORY_VISIBILITY);
                if (globalVisibility == null) {
                    return WorkflowVisibilityInternal.CONTRIBUTORS;
                }
                return WorkflowVisibilityInternal.parse(globalVisibility);
            }
            workflowVisibility = WorkflowVisibilityInternal.DEFAULT;
        }
        return workflowVisibility;
    }

    public void setHistoryVisibility(WorkflowVisibilityInternal visibility) {
        this.bandanaManager.setValue(this.bandanaContext, WORKFLOW_HISTORY_VISIBILITY, (Object)visibility.toString());
    }

    public void setHistoryVisibility(String spaceKey, WorkflowVisibilityInternal visibility) {
        ConfluenceBandanaContext context = new ConfluenceBandanaContext(spaceKey);
        if (WorkflowVisibilityInternal.DEFAULT == visibility && this.bandanaManager.getValue((BandanaContext)context, WORKFLOW_HISTORY_VISIBILITY) == null) {
            return;
        }
        this.bandanaManager.setValue((BandanaContext)context, WORKFLOW_HISTORY_VISIBILITY, (Object)(visibility == null ? null : visibility.toString()));
    }

    public MacroTransformStatus getMacroTransformEnable(String spaceKey, boolean lookupGlobal) {
        MacroTransformStatus status = null;
        if (TextUtils.stringSet((String)spaceKey)) {
            String spaceStatus = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), WORKFLOW_MACRO_TRANSFORM_ENABLE, false);
            if (TextUtils.stringSet((String)spaceStatus) && this.workflowsFeatureManager.isWorkflowsApp()) {
                status = this.macroTransformStatusParse(spaceStatus);
            }
            if (status == null || MacroTransformStatus.DEFAULT.equals((Object)status)) {
                status = lookupGlobal ? this.getMacroTransformEnable() : MacroTransformStatus.DEFAULT;
            }
        } else {
            this.getMacroTransformEnable();
        }
        return status;
    }

    public MacroTransformStatus getMacroTransformEnable() {
        String globalStatus = (String)this.bandanaManager.getValue(this.bandanaContext, WORKFLOW_MACRO_TRANSFORM_ENABLE);
        if (TextUtils.stringSet((String)globalStatus)) {
            return this.macroTransformStatusParse(globalStatus);
        }
        return MacroTransformStatus.DISABLED;
    }

    private MacroTransformStatus macroTransformStatusParse(String transformStatus) {
        if (MacroTransformStatus.ENABLED.toString().equalsIgnoreCase(transformStatus)) {
            return MacroTransformStatus.ENABLED;
        }
        if (MacroTransformStatus.DISABLED.toString().equalsIgnoreCase(transformStatus)) {
            return MacroTransformStatus.DISABLED;
        }
        return MacroTransformStatus.DEFAULT;
    }

    public boolean isMacroTransformEnable(String spaceKey) {
        MacroTransformStatus status = this.getMacroTransformEnable(spaceKey, true);
        return MacroTransformStatus.ENABLED.equals((Object)status);
    }

    public void setMacroTransformEnable(MacroTransformStatus status) {
        this.bandanaManager.setValue(this.bandanaContext, WORKFLOW_MACRO_TRANSFORM_ENABLE, (Object)status.toString());
    }

    public void setMacroTransformEnable(String spaceKey, MacroTransformStatus status) {
        ConfluenceBandanaContext context = new ConfluenceBandanaContext(spaceKey);
        this.bandanaManager.setValue((BandanaContext)context, WORKFLOW_MACRO_TRANSFORM_ENABLE, (Object)(status == null ? null : status.toString()));
    }

    public PageUpdateResetApprovalStatus getResetApprovalStatus(String spaceKey, boolean lookupGlobal) {
        PageUpdateResetApprovalStatus status = null;
        if (TextUtils.stringSet((String)spaceKey)) {
            String spaceStatus = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), WORKFLOW_PAGE_UPDATE_APPROVAL_RESET, false);
            if (TextUtils.stringSet((String)spaceStatus) && this.workflowsFeatureManager.isWorkflowsApp()) {
                status = PageUpdateResetApprovalStatus.valueOf(spaceStatus);
            }
            if (status == null || PageUpdateResetApprovalStatus.DEFAULT.equals((Object)status)) {
                status = lookupGlobal ? this.getResetApprovalStatus() : PageUpdateResetApprovalStatus.DEFAULT;
            }
        }
        return status;
    }

    public PageUpdateResetApprovalStatus getResetApprovalStatus() {
        PageUpdateResetApprovalStatus status = null;
        String globalStatus = (String)this.bandanaManager.getValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, WORKFLOW_PAGE_UPDATE_APPROVAL_RESET);
        if (TextUtils.stringSet((String)globalStatus)) {
            status = PageUpdateResetApprovalStatus.valueOf(globalStatus);
        }
        if (status == null) {
            status = PageUpdateResetApprovalStatus.RESET;
        }
        return status;
    }

    public boolean isPageUpdateApprovalReset(String spaceKey) {
        PageUpdateResetApprovalStatus status = this.getResetApprovalStatus(spaceKey, true);
        return PageUpdateResetApprovalStatus.RESET.equals((Object)status);
    }

    public void setResetApprovalStatus(PageUpdateResetApprovalStatus status) {
        this.bandanaManager.setValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, WORKFLOW_PAGE_UPDATE_APPROVAL_RESET, (Object)(status == null ? null : status.toString()));
    }

    public void setResetApprovalStatus(String spaceKey, PageUpdateResetApprovalStatus status) {
        ConfluenceBandanaContext context = new ConfluenceBandanaContext(spaceKey);
        this.bandanaManager.setValue((BandanaContext)context, WORKFLOW_PAGE_UPDATE_APPROVAL_RESET, (Object)(status == null ? null : status.toString()));
    }

    public void setConfiguration(WorkflowConfiguration workflowConfiguration) {
        this.initConfluenceLicense();
        workflowConfiguration.init();
        workflowConfiguration.incrementVersion();
        this.saveConfiguration(workflowConfiguration);
    }

    private void saveConfiguration(WorkflowConfiguration workflowConfiguration) {
        this.bandanaManager.setValue(this.bandanaContext, WORKFLOW_CONFIG_KEY, (Object)this.xStreamManagerCompat.toXML(workflowConfiguration));
    }

    public void disabled() {
    }

    public boolean isOnboardEnabled() {
        Object value = this.bandanaManager.getValue(this.bandanaContext, ONBOARD_ENABLED_KEY, true);
        if (Objects.isNull(value)) {
            return true;
        }
        return (Boolean)value;
    }

    public void setOnboardEnabled(boolean onBoardEnabledStatus) {
        this.bandanaManager.setValue(this.bandanaContext, ONBOARD_ENABLED_KEY, (Object)onBoardEnabledStatus);
    }

    public boolean isOnboardTopBarEnabled() {
        Object value = this.bandanaManager.getValue(this.bandanaContext, ONBOARD_TOP_BAR_ENABLED_KEY, true);
        if (Objects.isNull(value)) {
            return true;
        }
        return (Boolean)value;
    }

    public void setOnboardTopBarEnabled(boolean onboardTopBarEnabledStatus) {
        this.bandanaManager.setValue(this.bandanaContext, ONBOARD_TOP_BAR_ENABLED_KEY, (Object)onboardTopBarEnabledStatus);
    }

    public boolean isWorkflowTranslatorEnabled() {
        Object value = this.bandanaManager.getValue(this.bandanaContext, WORKFLOW_TRANSLATOR_ENABLED_KEY, true);
        if (Objects.isNull(value)) {
            return true;
        }
        return (Boolean)value;
    }

    public void setWorkflowTranslatorEnabled(boolean enabled) {
        this.bandanaManager.setValue(this.bandanaContext, WORKFLOW_TRANSLATOR_ENABLED_KEY, (Object)enabled);
    }

    public DocumentActionsDashboard getDocumentActionsDashboardEnable() {
        String status = (String)this.bandanaManager.getValue(this.bandanaContext, DOCUMENT_ACTIONS_DASHBOARD_ENABLED_KEY);
        return DocumentActionsDashboard.fromString(status).orElse(DocumentActionsDashboard.ENABLED);
    }

    public void setDocumentActionsDashboardEnabled(DocumentActionsDashboard documentActionsDashboard) {
        this.bandanaManager.setValue(this.bandanaContext, DOCUMENT_ACTIONS_DASHBOARD_ENABLED_KEY, (Object)documentActionsDashboard.name());
    }

    public boolean isDocumentActionsDashboardEnabled() {
        DocumentActionsDashboard status = this.getDocumentActionsDashboardEnable();
        return DocumentActionsDashboard.ENABLED.equals((Object)status);
    }
}

