/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.tasks.model;

import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.AssignableActivity;
import com.comalatech.confluence.states.model.DeletionActivity;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.model.Task;
import com.comalatech.confluence.tasks.model.TaskOperations;
import com.comalatech.confluence.tasks.model.TaskType;
import com.comalatech.confluence.workflow.model.DueDateRecordAware;
import com.comalatech.workflow.model.Assignment;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonIgnore;

public class PageTask
extends AssignableActivity
implements com.comalatech.workflow.model.Task,
DueDateRecordAware {
    private static final List<String> EMPTY_NAMES = Collections.emptyList();
    private int id;
    private String name;
    private TaskType type;
    List<TaskCompletion> completions;
    private DeletionActivity deletion;
    private DueDateRecord dueDateRecord;
    private List<DueDateRecord> dueDateHistory;
    private transient boolean canComplete;

    public PageTask() {
    }

    public PageTask(String user, String name, TaskType type, Date date) {
        this(user, name, type, date, null);
    }

    public PageTask(String user, String name, TaskType type, Date date, String comment) {
        super(user, date);
        this.name = name;
        this.type = type;
        this.completions = new ArrayList<TaskCompletion>();
        if (TextUtils.stringSet((String)comment)) {
            this.setComment(comment);
        }
        this.dueDateHistory = new ArrayList<DueDateRecord>();
    }

    public PageTask(String user, Task task, Date date) {
        this(user, task.getName(), task.getType(), date, task.getNote());
    }

    @JsonIgnore
    public List<TaskOperations> getOperations() {
        if (this.isCompleted()) {
            return TaskOperations.COMPLETED_TASKS_OPERATIONS;
        }
        return TaskOperations.OPENED_TASKS_OPERATIONS;
    }

    @Override
    public boolean isCompleted() {
        return this.completions.size() > 0 && (this.getAssignments().size() == 0 || this.getLastCompletion().compareTo((Activity)((Object)this.getLastAssignment())) > 0);
    }

    @Override
    public TaskCompletion getLastCompletion() {
        if (this.completions.size() == 0) {
            return null;
        }
        return this.completions.get(this.completions.size() - 1);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<TaskCompletion> getCompletions() {
        return this.completions;
    }

    public void setCompletions(List<TaskCompletion> completions) {
        this.completions = completions;
    }

    public void complete(TaskCompletion completion) {
        this.completions.add(completion);
    }

    @Override
    public boolean canComplete() {
        return this.canComplete;
    }

    public void setCanComplete(boolean canComplete) {
        this.canComplete = canComplete;
    }

    @Override
    public com.comalatech.confluence.states.model.Assignment getCurrentAssignment() {
        if (this.isCompleted()) {
            return null;
        }
        return this.getLastAssignment();
    }

    public List<String> getGroupNames() {
        Assignment assignment = this.getLastAssignment();
        if (assignment == null) {
            return EMPTY_NAMES;
        }
        return ((com.comalatech.confluence.states.model.Assignment)assignment).getGroupNames();
    }

    public String getGroups() {
        Assignment assignment = this.getLastAssignment();
        if (assignment == null) {
            return null;
        }
        return ((com.comalatech.confluence.states.model.Assignment)assignment).getGroups();
    }

    public TaskType getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String getActivityId() {
        return Long.toString(this.id);
    }

    public String getAssignee() {
        Assignment assigment = this.getLastAssignment();
        if (assigment == null) {
            return null;
        }
        return ((com.comalatech.confluence.states.model.Assignment)assigment).getAssignee();
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PageTask pageTask = (PageTask)o;
        if (this.id != pageTask.id) {
            return false;
        }
        if (this.getAssignments() != null ? !this.getAssignments().equals(pageTask.getAssignments()) : pageTask.getAssignments() != null) {
            return false;
        }
        if (!Objects.equals(this.completions, pageTask.completions)) {
            return false;
        }
        if (!Objects.equals(this.name, pageTask.name)) {
            return false;
        }
        if (this.type != pageTask.type) {
            return false;
        }
        if (!Objects.equals(this.deletion, pageTask.deletion)) {
            return false;
        }
        if (!Objects.equals(this.dueDateRecord, pageTask.dueDateRecord)) {
            return false;
        }
        return Objects.equals(this.dueDateHistory, pageTask.dueDateHistory);
    }

    public boolean canBeSentBack(ConfluenceUser user) {
        if (user == null) {
            return false;
        }
        Assignment assignment = this.getLastAssignment();
        if (assignment == null) {
            return !this.getPerformer().equals(user.getName());
        }
        return !((Activity)((Object)assignment)).getPerformer().equals(user.getName());
    }

    @Override
    public String getOutcome() {
        if (this.isCompleted()) {
            return "completed";
        }
        return null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.id;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.getAssignments() != null ? this.getAssignments().hashCode() : 0);
        result = 31 * result + (this.completions != null ? this.completions.hashCode() : 0);
        result = 31 * result + (this.dueDateRecord != null ? this.dueDateRecord.hashCode() : 0);
        result = 31 * result + (this.dueDateHistory != null ? this.dueDateHistory.hashCode() : 0);
        return result;
    }

    @Override
    public Map<String, String> getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", this.name);
        map.put("type", this.type.getName());
        map.put("id", Integer.toString(this.id));
        return map;
    }

    @Override
    public String getActivityKey() {
        return "task";
    }

    @Override
    public String toString() {
        return "PageTask{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", dueDate=" + this.dueDateRecord + ", dueDateHistories= " + this.dueDateHistory + ", assignments=" + this.getAssignments() + ", completions=" + this.completions + ", deletion=" + this.deletion + '}';
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeletionActivity getDeletion() {
        return this.deletion;
    }

    public void setDeletion(DeletionActivity deletion) {
        this.deletion = deletion;
    }

    @Override
    public Date getDueDate() {
        if (this.dueDateRecord != null) {
            return this.dueDateRecord.getDueDate();
        }
        return null;
    }

    @Override
    public DueDateRecord getCurrentDueDate() {
        return this.dueDateRecord;
    }

    @Override
    public PageTask addDueDateHistory(DueDateRecord dueDateRecord) {
        this.dueDateHistory.add(dueDateRecord);
        return this;
    }

    @Override
    public void setDueDateHistory(List<DueDateRecord> dueDateHistory) {
        this.dueDateHistory = dueDateHistory;
    }

    @Override
    public List<DueDateRecord> getDueDateHistory() {
        return this.dueDateHistory;
    }

    @Override
    public void setCurrentDueDate(DueDateRecord dueDateRecord) {
        this.dueDateRecord = dueDateRecord;
    }

    public String getUnassignedUser() {
        com.comalatech.confluence.states.model.Assignment assignment;
        List<com.comalatech.confluence.states.model.Assignment> assignments = this.getAssignments();
        if (assignments != null && assignments.size() > 1 && assignments.get(assignments.size() - 1).getAssignee() == null && (assignment = assignments.get(assignments.size() - 2)) != null) {
            return assignment.getAssignee();
        }
        return null;
    }
}

