/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.comalatech.confluence.states.model.Timer;
import java.util.Date;
import java.util.Objects;

public class PageStateTimer {
    private String name;
    private Date dueDate;
    private boolean active;
    private Date fired;
    private String note;

    public PageStateTimer() {
    }

    public PageStateTimer(String name) {
        if (!Timer.isValidName(name)) {
            throw new IllegalArgumentException("Invalid state name " + name);
        }
        this.name = name;
    }

    public PageStateTimer(String name, Date dueDate) {
        this(name);
        this.dueDate = dueDate;
        this.active = true;
        this.note = null;
    }

    public PageStateTimer(String name, Date dueDate, boolean active, Date fired) {
        this(name);
        this.dueDate = dueDate;
        this.active = active;
        this.fired = fired;
        this.note = null;
    }

    public boolean isActive() {
        return this.active;
    }

    public Date getFired() {
        return this.fired;
    }

    public void setFired(Date fired) {
        this.active = false;
        this.fired = fired;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getName() {
        return this.name;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageStateTimer that = (PageStateTimer)o;
        if (this.active != that.active) {
            return false;
        }
        if (!Objects.equals(this.dueDate, that.dueDate)) {
            return false;
        }
        if (!Objects.equals(this.fired, that.fired)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.note, that.note);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.dueDate != null ? this.dueDate.hashCode() : 0);
        result = 31 * result + (this.active ? 1 : 0);
        result = 31 * result + (this.fired != null ? this.fired.hashCode() : 0);
        result = 31 * result + (this.note != null ? this.note.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PageStateTimer{name='" + this.name + '\'' + ", dueDate=" + this.dueDate + ", active=" + this.active + ", fired=" + this.fired + ", note='" + this.note + '\'' + '}';
    }
}

