/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.comalatech.confluence.util.FancyDateFormatter;
import com.opensymphony.util.TextUtils;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public abstract class Activity
implements Comparable<Activity>,
com.comalatech.workflow.model.Activity {
    private String performer;
    private Date date;
    private String comment;

    public Activity() {
    }

    protected Activity(String performer, Date date) {
        this.performer = performer;
        this.date = date;
    }

    public abstract Map<String, String> getAttributes();

    public abstract String getActivityKey();

    public String getCssClass() {
        return this.getActivityKey();
    }

    @Override
    @HtmlSafe
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    @Deprecated
    public String getUserName() {
        return this.getPerformer();
    }

    @Override
    public String getPerformer() {
        return this.performer;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public String getFancyDate() {
        return FancyDateFormatter.decorateDateTimePretty(this.date, false);
    }

    public void setUserName(String userName) {
        this.performer = userName;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean equals(Object o) {
        if (!this.equalsIgnoreDateAndComment(o)) {
            return false;
        }
        Activity activity = (Activity)o;
        if (!Objects.equals(this.date, activity.date)) {
            return false;
        }
        return Objects.equals(this.comment, activity.comment);
    }

    public boolean equalsIgnoreDateAndComment(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Activity activity = (Activity)o;
        return Objects.equals(this.performer, activity.performer);
    }

    public int hashCode() {
        int result = this.performer != null ? this.performer.hashCode() : 0;
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Activity activity) {
        if (this.date == null) {
            if (activity.date != null) {
                return -1;
            }
        } else {
            if (activity.date == null) {
                return 1;
            }
            if (this.date.getTime() < activity.date.getTime()) {
                return -1;
            }
            if (this.date.getTime() > activity.date.getTime()) {
                return 1;
            }
        }
        if (this.performer == null) {
            if (activity.performer != null) {
                return -1;
            }
        } else {
            if (activity.performer == null) {
                return 1;
            }
            return this.performer.compareTo(activity.performer);
        }
        return 0;
    }

    public String toString() {
        return "Activity{" + this.getActivityKey() + " by " + this.performer + " on " + this.date + (this.comment != null && this.comment.trim().length() > 0 ? " \"" + this.trimmedComment() + "\" " : "") + this.attributesToString() + "}";
    }

    public String getSignatureMode() {
        return "";
    }

    public static String toString(Activity activity) {
        StringBuffer sb = new StringBuffer();
        sb.append("by ").append(activity.getPerformer());
        if (TextUtils.stringSet((String)activity.getComment())) {
            sb.append(" (").append(activity.getComment().replaceAll("\n", "")).append(")");
        }
        return sb.toString();
    }

    private String attributesToString() {
        StringBuffer sb = new StringBuffer();
        String separator = "";
        for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
            sb.append(separator).append(entry.getKey()).append("=").append(entry.getValue());
            separator = ", ";
        }
        return sb.toString();
    }

    private String trimmedComment() {
        String tmp = this.comment.replaceAll("\n", " ").trim();
        if (tmp.length() > 20) {
            return tmp.substring(0, 20) + "...";
        }
        return tmp;
    }
}

