/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.macro;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.readack.model.ReadAck;
import com.comalatech.confluence.workflow.macros.AbstractWorkflowElementMacro;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ReadAckMacro
extends AbstractWorkflowElementMacro {
    public static final String READ_ACK_MACRO = "read-ack";
    public static final String PARAM_DUEDATE = "duedate";
    public static final String APPROVER_REQUEST_OPTION = "approverRequestOption";
    public static final String PARAM_CHANGE_DUE_DATE = "changeduedate";

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
        this.validateParameters(parameters);
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        ArrayList flags = new ArrayList();
        Map macroParams = this.makeMacroParams();
        this.parseParameters(parameters, conditions, flags, macroParams, page);
        this.mapMacroToModel(renderContext, conditions, macroParams);
        return "";
    }

    private void mapMacroToModel(RenderContext renderContext, List<Condition> conditions, Map macroParams) throws MacroException {
        boolean approverRequestOption = MapUtils.getBooleanValue(macroParams, APPROVER_REQUEST_OPTION, true);
        boolean canChangeDueDate = MapUtils.getBooleanValue(macroParams, PARAM_CHANGE_DUE_DATE, true);
        ReadAck readAck = new ReadAck(conditions);
        readAck.setDueDate(MapUtils.getString(macroParams, PARAM_DUEDATE));
        readAck.setApproverRequestOption(approverRequestOption);
        readAck.setChangeDueDate(canChangeDueDate);
        List<WorkflowElement> elements = this.getElementsList(renderContext);
        elements.add(readAck);
    }

    private void validateParameters(Map parameters) throws MacroException {
        String user = (String)parameters.get("user");
        String group = (String)parameters.get("group");
        if (StringUtils.isNotBlank((CharSequence)user) && user.contains("!")) {
            throw new MacroException("Invalid parameter \"user\" read-ack macro.");
        }
        if (StringUtils.isNotBlank((CharSequence)group) && group.contains("!")) {
            throw new MacroException("Invalid parameter \"group\" read-ack macro.");
        }
    }

    private Map makeMacroParams() {
        HashMap<String, String> macroParams = new HashMap<String, String>();
        macroParams.put(PARAM_DUEDATE, null);
        macroParams.put(PARAM_CHANGE_DUE_DATE, "true");
        macroParams.put(APPROVER_REQUEST_OPTION, "true");
        return macroParams;
    }

    @Override
    public boolean allowsAnonymousUser() {
        return false;
    }

    @Override
    public boolean hasBody() {
        return false;
    }
}

