/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.listener;

import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.adhoc.notification.model.ReadAckCreatedEventEmail;
import com.comalatech.confluence.adhoc.notification.model.ReadAckCreatedEventOverdueEmail;
import com.comalatech.confluence.nextup.slack.service.WorkflowsEventPublisher;
import com.comalatech.confluence.readack.activeObjects.accessor.ReadAckRecordAccessor;
import com.comalatech.confluence.readack.activeObjects.entity.BaseReadAckRecord;
import com.comalatech.confluence.readack.activity.ReadAckActivityManager;
import com.comalatech.confluence.readack.activity.ReadAckCompletedActivityModel;
import com.comalatech.confluence.readack.events.ReadAckOverdueNotificationEvent;
import com.comalatech.confluence.readack.model.ReadAckSearchCriteria;
import com.comalatech.confluence.readack.model.ReadAckStatusType;
import com.comalatech.confluence.readack.service.ReadAckManager;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.workflow.event.readack.ReadAckCompletedEvent;
import com.comalatech.workflow.event.readack.ReadAckCreatedEvent;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadAckListener
extends WorkflowsListener {
    private static final Logger log = LoggerFactory.getLogger(ReadAckListener.class);
    private final AdhocNotificationService adhocNotificationService;
    private final ReadAckActivityManager readAckActivityManager;
    private final ReadAckManager readAckManager;
    private final ReadAckRecordAccessor readAckRecordAccessor;
    private final UserAccessor userAccessor;
    private final WorkflowNotificationConfigManager workflowNotificationConfigManager;
    private final WorkflowsEventPublisher workflowsEventPublisher;

    public ReadAckListener(EventPublisher eventPublisher, AdhocNotificationService adhocNotificationService, ReadAckManager readAckManager, ReadAckActivityManager readAckActivityManager, ReadAckRecordAccessor readAckRecordAccessor, UserAccessor userAccessor, WorkflowNotificationConfigManager workflowNotificationConfigManager, WorkflowsEventPublisher workflowsEventPublisher) {
        super(eventPublisher);
        this.adhocNotificationService = adhocNotificationService;
        this.readAckManager = readAckManager;
        this.readAckActivityManager = readAckActivityManager;
        this.readAckRecordAccessor = readAckRecordAccessor;
        this.userAccessor = userAccessor;
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
        this.workflowsEventPublisher = workflowsEventPublisher;
    }

    @EventListener
    public void notifyReadAckCreated(ReadAckCreatedEvent event) {
        AbstractPage page = (AbstractPage)event.getContent();
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.READ_CONFIRMATION, page.getSpaceKey())) {
            ReadAckCreatedEventEmail email = new ReadAckCreatedEventEmail();
            email.setEntityId(page.getId());
            email.addContextProperty("pageTitle", page.getTitle());
            email.addContextProperty("pagePath", page.getUrlPath());
            Set<ConfluenceUser> users = event.getUsers();
            this.workflowsEventPublisher.publishSlackNotification(email.getSubject(), email.getBody(), users.stream().map(ConfluenceUser::getKey).map(UserKey::getStringValue).collect(Collectors.joining(",")), page);
            this.adhocNotificationService.sendEmail(email, users);
        }
    }

    @EventListener
    public void cleanReadAckInfo(PageRemoveEvent event) {
        try {
            this.cleanReadAckInfo((AbstractPage)event.getPage());
        }
        catch (Exception e) {
            log.error("There was an error while processing event: " + event, (Throwable)e);
        }
    }

    @EventListener
    public void cleanReadAckInfo(BlogPostRemoveEvent event) {
        try {
            this.cleanReadAckInfo((AbstractPage)event.getBlogPost());
        }
        catch (Exception e) {
            log.error("There was an error while processing event: " + event, (Throwable)e);
        }
    }

    @EventListener
    public void notifyReadAckOverdue(ReadAckOverdueNotificationEvent event) {
        AbstractPage page = event.getPage();
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.READ_CONFIRMATION, page.getSpaceKey())) {
            ReadAckSearchCriteria criteria = new ReadAckSearchCriteria();
            criteria.setPageId(page.getId());
            criteria.setStatus(ReadAckStatusType.UserStatusType.PENDING);
            List<BaseReadAckRecord> readAckRecords = this.readAckRecordAccessor.search(criteria);
            Set userKeys = readAckRecords.stream().map(BaseReadAckRecord::getUserKey).collect(Collectors.toSet());
            Set<ConfluenceUser> users = userKeys.stream().map(UserKey::new).map(arg_0 -> ((UserAccessor)this.userAccessor).getUserByKey(arg_0)).collect(Collectors.toSet());
            ReadAckCreatedEventOverdueEmail email = new ReadAckCreatedEventOverdueEmail();
            email.setEntityId(page.getId());
            email.addContextProperty("pageTitle", page.getTitle());
            email.addContextProperty("pagePath", page.getUrlPath());
            this.workflowsEventPublisher.publishSlackNotification(email.getSubject(), email.getBody(), String.join((CharSequence)",", userKeys), page);
            this.adhocNotificationService.sendEmail(email, users);
        }
    }

    private void cleanReadAckInfo(AbstractPage abstractPage) {
        this.readAckManager.removeReadAckUserRecords(abstractPage);
    }

    @EventListener
    public void addReadAckCompletedStats(ReadAckCompletedEvent event) {
        this.readAckActivityManager.addReadAckActivity((AbstractPage)event.getContent(), new ReadAckCompletedActivityModel(event.getAckTimestamp(), event.getContent().getVersion()));
    }
}

