/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.nextup.slack.infrastructure;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.comalatech.confluence.adhoc.notification.SlackNotificationConfigManager;
import com.comalatech.confluence.nextup.slack.service.PublishSlackPayload;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.macros.actions.AbstractActionMacro;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public class SlackUserMacro
extends AbstractActionMacro {
    private static final String PARAM_USER = "user";
    private static final String PARAM_SUBJECT = "subject";
    private PublishSlackPayload publishSlackPayload;
    private UserAccessor userAccessor;
    private GroupManager groupManager;
    private SlackNotificationConfigManager slackNotificationConfigManager;

    @Override
    protected String getName() {
        return "send-slack-user";
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        if (this.slackNotificationConfigManager.isDisabledByDarkFeature()) {
            return "";
        }
        try {
            String userGroupNames = (String)parameters.get(PARAM_USER);
            this.validateParamUser(userGroupNames);
            this.validateBody(body);
            if (!this.inExecuteMode(renderContext)) {
                return "";
            }
            AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
            ValueStore valueStore = this.getOrCreateValueStore(renderContext, page);
            this.publishSlackPayload.notifyUsers((String)parameters.get(PARAM_SUBJECT), body, userGroupNames, page.getId(), valueStore);
        }
        catch (Exception e) {
            if (this.inExecuteMode(renderContext)) {
                this.logMessage(renderContext, e);
                return "";
            }
            throw new MacroException(e.getMessage());
        }
        return "";
    }

    private void validateParamUser(String usernames) throws MacroException, EntityException {
        String[] users;
        if (!TextUtils.stringSet((String)usernames)) {
            throw new MacroException("user must be defined.");
        }
        for (String user : users = MiscUtils.splitAndTrim(usernames)) {
            boolean isInvalidUser;
            if (user.startsWith("@") || user.endsWith("@")) continue;
            boolean isInvalidGroup = this.groupManager.getGroup(user) == null;
            boolean bl = isInvalidUser = this.userAccessor.getUserByName(user) == null;
            if (!isInvalidUser || !isInvalidGroup) continue;
            throw new MacroException("Invalid user or group " + user);
        }
    }

    private void validateBody(String body) throws MacroException {
        if (!TextUtils.stringSet((String)body)) {
            throw new MacroException("The body message must be defined.");
        }
    }

    private ValueStore getOrCreateValueStore(RenderContext renderContext, AbstractPage page) {
        ValueStore renderContextValueStore = (ValueStore)renderContext.getParam((Object)"valueStore");
        if (renderContextValueStore == null) {
            return this.valueStoreManager.createValueStore(page);
        }
        return this.valueStoreManager.createValueStore(page, renderContextValueStore.getPropertiesMap());
    }

    public void setPublishSlackPayload(PublishSlackPayload publishSlackPayload) {
        this.publishSlackPayload = publishSlackPayload;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public void setSlackNotificationConfigManager(SlackNotificationConfigManager slackNotificationConfigManager) {
        this.slackNotificationConfigManager = slackNotificationConfigManager;
    }
}

