/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.nextup.slack.infrastructure;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.adhoc.notification.SlackNotificationConfigManager;
import com.comalatech.confluence.nextup.slack.service.WorkflowsEventPublisher;
import com.opensymphony.util.TextUtils;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackEventPublisher
implements WorkflowsEventPublisher {
    private static final Logger log = LoggerFactory.getLogger(SlackEventPublisher.class);
    private static final String CDM_SLACK_USER_EVENT_EMITTER = "com.comalatech.confluence.SlackUserMessageRequested";
    private static final String PAYLOAD_VERSION = "user_v1";
    private final EventPublisher eventPublisher;
    private final SlackNotificationConfigManager slackNotificationConfigManager;

    public SlackEventPublisher(EventPublisher eventPublisher, SlackNotificationConfigManager slackNotificationConfigManager) {
        this.eventPublisher = eventPublisher;
        this.slackNotificationConfigManager = slackNotificationConfigManager;
    }

    @Override
    public void publish(String subject, String message, String users, long pageId) {
        if (this.slackNotificationConfigManager.isNextupPluginDisabled()) {
            log.warn("There was an attempt to send a slack message but it was not. The slack messages will not being sent until 'Docs+ Slack for Confluence' is enabled.");
            return;
        }
        Properties payload = new Properties();
        payload.setProperty("_emitter", CDM_SLACK_USER_EVENT_EMITTER);
        payload.setProperty("message", this.generateBlockKit(subject, message));
        payload.setProperty("users", users);
        payload.setProperty("page_id", String.valueOf(pageId));
        payload.setProperty("payload_version", PAYLOAD_VERSION);
        this.eventPublisher.publish((Object)payload);
    }

    @Override
    public void publishSlackNotification(String subject, String message, String users, AbstractPage page) {
        if (this.slackNotificationConfigManager.isDisabledByDarkFeature() || this.slackNotificationConfigManager.isDisabledForSpace(page.getSpaceKey())) {
            return;
        }
        this.publish(subject, message, users, page.getId());
    }

    private String generateBlockKit(String subject, String message) {
        JSONArray jsonBlockKit = new JSONArray();
        if (TextUtils.stringSet((String)subject)) {
            JSONObject subjectBlock = new JSONObject();
            subjectBlock.put("type", "header").put("text", new JSONObject().put("type", "plain_text").put("text", subject).put("emoji", true));
            jsonBlockKit.put(subjectBlock);
        }
        JSONObject messageBlock = new JSONObject();
        messageBlock.put("type", "section").put("block_id", "sectionBlockOnlyPlainText").put("text", new JSONObject().put("type", "plain_text").put("text", message).put("emoji", true));
        jsonBlockKit.put(messageBlock);
        return jsonBlockKit.toString();
    }
}

