/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.AssignableActivity;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.workflow.StateService;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.randombits.confluence.supplier.Supplier;
import org.randombits.confluence.supplier.SupplierException;
import org.randombits.confluence.supplier.UnsupportedContextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdhocWorkflowsSupplier
implements Supplier {
    private static final Logger log = LoggerFactory.getLogger(AdhocWorkflowsSupplier.class);
    private static final int MAX_ERRORS_IN_THREAD = 50;
    private final StateAccessor stateAccessor;
    private final StateService stateService;
    private final ApprovalAccessor approvalAccessor;
    private final UserAccessor userAccessor;
    private final InternalWorkflowParameterManager workflowParameterManager;
    private final UsersListResolver usersListResolver;
    private static final ThreadLocal<Integer> errorCount = new ThreadLocal();

    public AdhocWorkflowsSupplier(StateAccessor stateAccessor, StateService stateService, ApprovalAccessor approvalAccessor, UserAccessor userAccessor, InternalWorkflowParameterManager workflowParameterManager, UsersListResolver usersListResolver) {
        this.stateAccessor = stateAccessor;
        this.stateService = stateService;
        this.approvalAccessor = approvalAccessor;
        this.userAccessor = userAccessor;
        this.workflowParameterManager = workflowParameterManager;
        this.usersListResolver = usersListResolver;
    }

    @Override
    public boolean supportsPrefix(String s) {
        return s == null || "workflow".equalsIgnoreCase(s);
    }

    @Override
    public boolean supportsContext(Object context) {
        return context instanceof AbstractPage || context instanceof PageTask || context instanceof PageState || context instanceof ApprovalCheck || context instanceof MetadataLookup || context instanceof TaskCompletion || context instanceof StatesLookup || context instanceof Assignment;
    }

    @Override
    public Object getValue(Object context, String key) throws UnsupportedContextException, SupplierException {
        try {
            if (context instanceof AbstractPage) {
                return this.getAbstractPageValue(key, (AbstractPage)context);
            }
            if (context instanceof PageState) {
                return this.getPageStateValue(key, (PageState)context);
            }
            if (context instanceof PageTask) {
                return this.getTaskValue(key, (PageTask)context);
            }
            if (context instanceof MetadataLookup) {
                return this.getMetadataValue(key, (MetadataLookup)context);
            }
            if (context instanceof ApprovalCheck) {
                return this.getApprovalCheckValue(key, (ApprovalCheck)context);
            }
            if (context instanceof TaskCompletion) {
                return this.getTaskCompletionValue(key, (TaskCompletion)context);
            }
            if (context instanceof StatesLookup) {
                return this.getStatesPageValue(key, (StatesLookup)context);
            }
            if (context instanceof Assignment) {
                return this.getActivityValue(key, (Assignment)context);
            }
            return null;
        }
        catch (Exception e) {
            int count;
            if (errorCount.get() == null) {
                count = 1;
                errorCount.set(1);
            } else {
                count = errorCount.get() + 1;
                errorCount.set(count);
            }
            if (count < 50) {
                if (log.isDebugEnabled()) {
                    log.error("", (Throwable)e);
                } else {
                    log.error(e.toString());
                }
            } else if (count == 50) {
                log.error("too many errors (" + count + "): " + e + ". No more errors will be logged in this request");
            }
            return null;
        }
    }

    private Object getMetadataValue(String key, MetadataLookup lookup) {
        return this.workflowParameterManager.getParameterValue(lookup.page, key);
    }

    private Object getPageStateValue(String key, PageState state) {
        if ("tasks".equals(key) || "activetasks".equals(key)) {
            return state.getPageTasks().getActiveTasks();
        }
        if ("completedtasks".equals(key)) {
            return state.getPageTasks().getCompletedTasks();
        }
        if ("alltasks".equals(key)) {
            return state.getPageTasks().get();
        }
        if ("version".equals(key)) {
            return state.getVersion();
        }
        if ("duedate".equals(key) || "expirydate".equals(key)) {
            return state.getExpirationDate();
        }
        if ("allapprovals".equals(key)) {
            return this.approvalAccessor.getApprovalChecks(state.getPage(), state);
        }
        return this.getAssignableActivityValue(key, state);
    }

    private Object getTaskValue(String key, PageTask task) {
        if ("completed".equals(key)) {
            return task.isCompleted();
        }
        if ("completion".equals(key)) {
            return task.getLastCompletion();
        }
        if ("completions".equals(key)) {
            return task.getCompletions();
        }
        if ("duedate".equals(key)) {
            return task.getDueDate();
        }
        return this.getAssignableActivityValue(key, task);
    }

    private Object getTaskCompletionValue(String key, TaskCompletion completion) {
        if ("outcome".equals(key)) {
            return completion.getOutcome();
        }
        if ("approved".equals(key)) {
            return "approve".equals(completion.getOutcome());
        }
        if ("rejected".equals(key)) {
            return "approve".equals(completion.getOutcome());
        }
        return this.getActivityValue(key, completion);
    }

    private Object getAssignableActivityValue(String key, AssignableActivity activity) {
        if ("name".equals(key) || "state".equals(key)) {
            return activity.getName();
        }
        if ("assignee".equals(key)) {
            Assignment assignment = activity.getLastAssignment();
            if (assignment == null || !TextUtils.stringSet((String)assignment.getAssigneeNames())) {
                return null;
            }
            String[] names = MiscUtils.splitAndTrim(assignment.getAssigneeNames());
            return this.userAccessor.getUserByName(names[0]);
        }
        if ("assignees".equals(key)) {
            Assignment assignment = activity.getLastAssignment();
            if (assignment == null || !TextUtils.stringSet((String)assignment.getAssigneeNames())) {
                return null;
            }
            return this.usersListResolver.getAsUsers(assignment.getAssigneeNames());
        }
        if ("assignment".equals(key)) {
            return activity.getLastAssignment();
        }
        if ("assignments".equals(key)) {
            return activity.getAssignments();
        }
        return this.getActivityValue(key, activity);
    }

    private Object getActivityValue(String key, Activity activity) {
        if ("user".equals(key)) {
            return this.userAccessor.getUserByName(activity.getPerformer());
        }
        if ("date".equals(key)) {
            return activity.getDate();
        }
        if ("comment".equals(key)) {
            return activity.getComment();
        }
        return null;
    }

    private Object getApprovalCheckValue(String key, ApprovalCheck approval) {
        if ("name".equals(key)) {
            return approval.getName();
        }
        if ("approved".equals(key)) {
            return approval.isApproved();
        }
        if ("rejected".equals(key)) {
            return approval.isApproved();
        }
        if ("version".equals(key)) {
            return approval.getVersion();
        }
        Approver lastApprover = approval.getLastApprover();
        if (lastApprover == null) {
            return null;
        }
        if ("date".equals(key)) {
            return lastApprover.getDate();
        }
        if ("comment".equals(key)) {
            return lastApprover.getComment();
        }
        if ("user".equals(key)) {
            return this.userAccessor.getUserByName(lastApprover.getUser());
        }
        return null;
    }

    private List<PageState> getStatesPageValue(String key, StatesLookup statesLookup) {
        if ("all".equals(key)) {
            return statesLookup.states;
        }
        ArrayList<PageState> states = new ArrayList<PageState>();
        for (PageState pageState : statesLookup.states) {
            if (!pageState.getName().equalsIgnoreCase(key)) continue;
            states.add(pageState);
        }
        return states;
    }

    private Object getAbstractPageValue(String key, AbstractPage page) {
        if ("approvals".equals(key)) {
            return this.approvalAccessor.getLatestApprovalChecks(page);
        }
        PageState state = (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
        if (state == null) {
            return null;
        }
        if ("state".equals(key)) {
            return state;
        }
        if ("states".equals(key)) {
            return new StatesLookup(this.stateAccessor.getPageStates(page));
        }
        if ("tasks".equals(key)) {
            return state.getPageTasks().getActiveTasks();
        }
        if ("metadata".equals(key)) {
            return new MetadataLookup(page);
        }
        return null;
    }

    private static class MetadataLookup {
        AbstractPage page;

        private MetadataLookup(AbstractPage page) {
            this.page = page;
        }
    }

    private static class StatesLookup {
        List<PageState> states;

        private StatesLookup(List<PageState> states) {
            this.states = states;
        }
    }
}

