/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.tasks;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityRecordOrigin;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.service.DocumentActivityService;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.Status;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.UpgradeTask;
import com.comalatech.confluence.documentActivity.upgrade.events.SpacePreCheckedEvent;
import com.comalatech.confluence.documentActivity.upgrade.events.SpaceUpgradedEvent;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.documentActivity.upgrade.support.commands.UpgradeLog;
import com.comalatech.confluence.documentActivity.upgrade.support.model.UpgradeLogData;
import com.comalatech.confluence.documentActivity.upgrade.utils.SupportPackageFile;
import com.comalatech.confluence.documentActivity.usecases.contracts.GenerateDocumentActivity;
import com.comalatech.confluence.documentActivity.usecases.contracts.ValidateDocumentActivity;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.accesor.entity.PageActivityRecord;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.workflow.StateService;
import java.io.IOException;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceUpgradeTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(SpaceUpgradeTask.class);
    private final Space space;
    private final UpgradeTask upgradeTask;
    private final List<PageActivityRecord> pageActivityRecords;
    private final DocumentActivityUpgradeService documentActivityUpgradeService;
    private final ValidateDocumentActivity validateDocumentActivity;
    private final GenerateDocumentActivity generateDocumentActivity;
    private final PageManager pageManager;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final DocumentActivityService documentActivityService;
    private final StateService stateService;
    private final StateAccessor stateAccessor;
    private final ApprovalAccessor approvalAccessor;
    private final EventPublisher eventPublisher;
    private final boolean isUpgrading;
    private final UpgradeLog upgradeLog;
    public static final String NAME = ConfluenceActionSupport.getTextStatic((String)"comalatech.awp.global.workflows.upgrade.checks.checkup.task");

    public SpaceUpgradeTask(Space space, UpgradeTask upgradeTask, List<PageActivityRecord> pageActivityRecords, DocumentActivityUpgradeService documentActivityUpgradeService, ValidateDocumentActivity validateDocumentActivity, GenerateDocumentActivity generateDocumentActivity, PageManager pageManager, ReadWriteTransactionService readWriteTransactionService, SupportPresenter templateFileLayoutHelper, DocumentActivityService documentActivityService, StateService stateService, StateAccessor stateAccessor, ApprovalAccessor approvalAccessor, EventPublisher eventPublisher, boolean isUpgrading) {
        this.space = space;
        this.upgradeTask = upgradeTask;
        this.isUpgrading = isUpgrading;
        this.pageActivityRecords = pageActivityRecords;
        this.documentActivityUpgradeService = documentActivityUpgradeService;
        this.validateDocumentActivity = validateDocumentActivity;
        this.generateDocumentActivity = generateDocumentActivity;
        this.pageManager = pageManager;
        this.readWriteTransactionService = readWriteTransactionService;
        this.documentActivityService = documentActivityService;
        this.stateService = stateService;
        this.stateAccessor = stateAccessor;
        this.approvalAccessor = approvalAccessor;
        this.eventPublisher = eventPublisher;
        this.upgradeLog = new UpgradeLog(templateFileLayoutHelper);
    }

    public String getName() {
        return NAME;
    }

    protected void runInternal() {
        Instant startedAt = Instant.now();
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList pagesWithErrors = new ArrayList();
        AtomicBoolean cancelledByUser = new AtomicBoolean(false);
        try {
            SupportPackageFile.deleteSpaceBaseFolder(this.space.getKey());
            if (this.isUpgradeTaskReadyToStart(this.isUpgrading)) {
                if (this.pageActivityRecords != null && !this.pageActivityRecords.isEmpty()) {
                    log.debug("Upgrade task started for space " + this.space.getKey() + ", containing " + this.pageActivityRecords.size() + " pages with activity");
                    this.readWriteTransactionService.executeInReadWriteTransaction(() -> {
                        AtomicLong totalDocActEntries = new AtomicLong(0L);
                        AtomicLong recordsProcessed = new AtomicLong(0L);
                        ArrayList<CompletableFuture> activitiesToStore = new ArrayList<CompletableFuture>();
                        ArrayList<CompletableFuture> latestFinalStatesToStore = new ArrayList<CompletableFuture>();
                        HashMap<AbstractPage, CompletableFuture> latestApprovalChecksBeforeFinalStateToStore = new HashMap<AbstractPage, CompletableFuture>();
                        int totalActivities = this.pageActivityRecords.size();
                        ((Stream)this.pageActivityRecords.stream().parallel()).forEach(page -> {
                            if (this.hasBeenCancelledByUser(this.space, this.isUpgrading)) {
                                cancelledByUser.set(true);
                                throw new RuntimeException("The upgrade task for the space " + this.space.getKey() + " has been cancelled by the user");
                            }
                            Long pageId = page.getPageId();
                            boolean successfulValidation = false;
                            AbstractPage content = this.pageManager.getAbstractPage(pageId.longValue());
                            if (content != null) {
                                try {
                                    if (!this.documentActivityService.getById(content).isEmpty()) {
                                        log.debug(MessageFormat.format("Page {0} already upgraded: skipping.", content.getId()));
                                        successfulValidation = true;
                                    } else {
                                        log.debug(MessageFormat.format("Page {0} pre-check processing...", content.getId()));
                                        List<Activity> activities = this.generateDocumentActivity.generate(content);
                                        successfulValidation = this.validateDocumentActivity.validate(content, activities, true, SupportPackageFile.getDataBasePath(this.space.getKey(), content.getId()));
                                        if (successfulValidation) {
                                            if (!this.isUpgrading) {
                                                totalDocActEntries.addAndGet(activities.size());
                                            } else {
                                                PageState previousStateToFinalState;
                                                activitiesToStore.add(CompletableFuture.supplyAsync(() -> activities));
                                                PageState publishedState = (PageState)this.stateService.getPublishedState((ContentEntityObject)content);
                                                if (publishedState != null) {
                                                    latestFinalStatesToStore.add(CompletableFuture.supplyAsync(() -> publishedState));
                                                }
                                                if ((previousStateToFinalState = this.stateAccessor.getPreviousStateToFinalState(content, publishedState)) != null) {
                                                    latestApprovalChecksBeforeFinalStateToStore.put(content, CompletableFuture.supplyAsync(() -> this.approvalAccessor.getApprovalsPriorToLatestPublishedState(content, previousStateToFinalState)));
                                                }
                                            }
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    this.handleError(messages, MessageFormat.format("Content of id {0} failed during the validation", pageId), e);
                                }
                            } else {
                                this.handleError(messages, MessageFormat.format("Content of id {0} does not exist", pageId), null);
                            }
                            recordsProcessed.addAndGet(1L);
                            if (this.isUpgrading) {
                                this.progress.setPercentage(recordsProcessed.intValue() * 40 / totalActivities);
                                this.setProgressStatus(1, Long.valueOf(totalActivities), Long.valueOf(recordsProcessed.intValue()));
                            } else {
                                this.progress.setPercentage(recordsProcessed.intValue(), this.pageActivityRecords.size());
                            }
                            if (!successfulValidation) {
                                pagesWithErrors.add(pageId);
                            }
                            log.debug(MessageFormat.format("Page {0} pre-check process finished successfully: {1}.", pageId, successfulValidation));
                        });
                        if (this.isUpgrading) {
                            this.performDBPersistence(activitiesToStore, latestFinalStatesToStore, latestApprovalChecksBeforeFinalStateToStore, cancelledByUser);
                        }
                        this.eventPublisher.publish((Object)new SpacePreCheckedEvent(this.space.getKey(), totalDocActEntries.get()));
                        if (!pagesWithErrors.isEmpty() || !messages.isEmpty()) {
                            if (!pagesWithErrors.isEmpty()) {
                                this.handleError(messages, MessageFormat.format("Space {0} Upgrade task failed for these pages: {1} ..., forcing rollback.", this.space.getKey(), pagesWithErrors), null);
                            }
                            throw new RuntimeException();
                        }
                        this.upgradeTask.setStatus(Status.getSuccessStatus(this.isUpgrading));
                        return null;
                    });
                } else {
                    log.debug("There is no page with activity for the space:" + this.space.getKey());
                    this.upgradeTask.setStatus(Status.getSuccessStatus(this.isUpgrading));
                }
            } else {
                this.upgradeTask.setStatus(Status.getFailStatus(this.isUpgrading));
                this.handleError(messages, MessageFormat.format("Error starting the long running task for the space {0}", this.space.getKey()), null);
            }
        }
        catch (Exception e) {
            this.handleError(messages, "Error during the activities upgrade.", e);
            if (cancelledByUser.get()) {
                this.upgradeTask.setStatus(Status.getCancelStatus(this.isUpgrading));
            }
            this.upgradeTask.setNumErrors(pagesWithErrors.size());
            this.upgradeTask.setStatus(Status.getFailStatus(this.isUpgrading));
        }
        if (Status.getFailStatus(this.isUpgrading).equals((Object)this.upgradeTask.getStatus())) {
            try {
                if (!messages.isEmpty()) {
                    this.upgradeLog.generateSupportFile(UpgradeLogData.builder().messages(messages).build(), SupportPackageFile.generateSpaceBaseFolder(this.space.getKey()));
                }
            }
            catch (IOException e) {
                log.error("Error generating the space support zip.");
            }
            this.upgradeTask.setDuration(TimerUtils.getDuration(startedAt));
            this.progress.setCompletedSuccessfully(false);
        } else if (Status.getSuccessStatus(this.isUpgrading).equals((Object)this.upgradeTask.getStatus())) {
            this.upgradeTask.setDuration(TimerUtils.getDuration(startedAt));
            this.progress.setCompletedSuccessfully(true);
        } else if (Status.getCancelStatus(this.isUpgrading).equals((Object)this.upgradeTask.getStatus())) {
            this.progress.setCompletedSuccessfully(false);
            this.upgradeTask.cancelUpgradeTask(this.isUpgrading);
        }
        this.progress.setPercentage(100);
        this.documentActivityUpgradeService.saveSpaceUpgrade(this.space, this.upgradeTask);
        if (this.isUpgrading) {
            this.eventPublisher.publish((Object)new SpaceUpgradedEvent());
        }
        log.debug("Upgrade task finished for space " + this.space.getKey());
    }

    private void handleError(List<String> messages, String message, Exception ex) {
        messages.add(message);
        if (ex != null) {
            messages.add(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        if (ex != null) {
            log.error(message, (Throwable)ex);
        } else {
            log.error(message);
        }
    }

    private boolean hasBeenCancelledByUser(Space space, boolean upgrade) {
        return this.readWriteTransactionService.executeInReadWriteTransaction(() -> {
            UpgradeTask upgradeTask = this.documentActivityUpgradeService.getSpaceUpgrade(space);
            return upgradeTask != null && Status.getCancelStatus(upgrade).equals((Object)upgradeTask.getStatus());
        });
    }

    private boolean isUpgradeTaskReadyToStart(boolean upgrade) throws InterruptedException {
        UpgradeTask upgradeTaskStored = this.documentActivityUpgradeService.getSpaceUpgrade(this.space);
        DateTime timeLimit = DateTime.now().plusSeconds(180);
        while (!Status.getInProgressStatus(upgrade).equals((Object)upgradeTaskStored.getStatus()) && DateTime.now().getMillis() <= timeLimit.getMillis()) {
            upgradeTaskStored = this.documentActivityUpgradeService.getSpaceUpgrade(this.space);
            Thread.sleep(2000L);
        }
        this.upgradeTask.setStartedAt(upgradeTaskStored.getStartedAt());
        return Status.getInProgressStatus(upgrade).equals((Object)upgradeTaskStored.getStatus());
    }

    private void saveActivitiesInAO(List<CompletableFuture> activitiesToStore, AtomicBoolean cancelRequest) {
        AtomicLong records = new AtomicLong(0L);
        int totalActivities = activitiesToStore.size();
        log.debug("Number of pages to store activities:" + totalActivities);
        activitiesToStore.forEach(elem -> {
            try {
                if (this.hasBeenCancelledByUser(this.space, this.isUpgrading)) {
                    cancelRequest.set(true);
                    throw new RuntimeException("The upgrade task for the space " + this.space.getKey() + " has been cancelled by the user");
                }
                List activities = (List)elem.get();
                if (activities != null && activities.size() > 0) {
                    log.debug("Storing doc activity entries in database for page {} ...", (Object)((Activity)activities.get(0)).getTarget().getTargetId());
                    activities.forEach(act -> this.documentActivityService.create((Activity)act, ActivityRecordOrigin.ORIGIN_UPGRADE));
                }
                records.addAndGet(1L);
                this.progress.setPercentage(records.intValue() * 40 / activitiesToStore.size() + 40);
                this.setProgressStatus(2, Long.valueOf(totalActivities), records.longValue());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void saveLatestFinalStates(List<CompletableFuture> statesToStore, AtomicBoolean cancelRequest) {
        AtomicLong records = new AtomicLong(0L);
        int totalStates = statesToStore.size();
        log.debug("Number of published states to store:" + totalStates);
        statesToStore.forEach(state -> {
            try {
                if (this.hasBeenCancelledByUser(this.space, this.isUpgrading)) {
                    cancelRequest.set(true);
                    throw new RuntimeException("The upgrade task for the space " + this.space.getKey() + " has been cancelled by the user");
                }
                PageState publishedState = (PageState)state.get();
                log.debug("Storing published state in database for page {} ...", (Object)publishedState.getPage());
                this.stateAccessor.setLatestFinalState(publishedState.getPage(), publishedState);
                records.addAndGet(1L);
                this.progress.setPercentage(records.intValue() * 10 / statesToStore.size() + 80);
                this.setProgressStatus(3, Long.valueOf(totalStates), records.longValue());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void saveLatestApprovalChecksBeforeFinalState(Map<AbstractPage, CompletableFuture> approvalChecksToStore, AtomicBoolean cancelRequest) {
        AtomicLong records = new AtomicLong(0L);
        int totalApprovalChecks = approvalChecksToStore.size();
        log.debug("Number of latest approval checks before published state to store:" + totalApprovalChecks);
        approvalChecksToStore.forEach((content, approvalChecks) -> {
            try {
                if (this.hasBeenCancelledByUser(this.space, this.isUpgrading)) {
                    cancelRequest.set(true);
                    throw new RuntimeException("The upgrade task for the space " + this.space.getKey() + " has been cancelled by the user");
                }
                List approvals = (List)approvalChecks.get();
                if (approvals != null && !approvals.isEmpty()) {
                    log.debug("Storing pre-latest approval check in database for page {} ...", (Object)content.getId());
                    this.approvalAccessor.saveApprovalChecksBeforeLastFinalState((AbstractPage)content, approvals.toArray(new ApprovalCheck[approvals.size()]));
                }
                records.addAndGet(1L);
                this.progress.setPercentage(records.intValue() * 10 / approvalChecksToStore.size() + 80);
                this.setProgressStatus(4, Long.valueOf(totalApprovalChecks), records.longValue());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void performDBPersistence(List<CompletableFuture> activitiesToStore, List<CompletableFuture> latestFinalStatesToStore, Map<AbstractPage, CompletableFuture> latestApprovalChecksBeforeFinalStateToStore, AtomicBoolean cancelledByUser) {
        log.debug("Starting database storage: AO activities saving.");
        this.saveActivitiesInAO(activitiesToStore, cancelledByUser);
        log.debug("Finished database storage: AO activities saving.");
        log.debug("Starting database storage: Published state content property.");
        this.saveLatestFinalStates(latestFinalStatesToStore, cancelledByUser);
        log.debug("Finished database storage: Published state content property.");
        log.debug("Starting database storage: Latest approval check before published state content property.");
        this.saveLatestApprovalChecksBeforeFinalState(latestApprovalChecksBeforeFinalStateToStore, cancelledByUser);
        log.debug("Finishing database storage: Latest approval check before published state content property.");
    }

    private void setProgressStatus(int phase, Long totalRecords, Long recordsProcessed) {
        this.progress.setStatus(ConfluenceActionSupport.getTextStatic((String)("comalatech.awp.global.workflows.upgrade.checks.phase" + phase)) + ": " + ConfluenceActionSupport.getTextStatic((String)"comalatech.awp.global.workflows.upgrade.checks.phase.records", (Object[])new String[]{recordsProcessed.toString(), totalRecords.toString()}));
    }
}

