/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service.provider;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.domain.entities.Target;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.provider.AbstractPageActivityProvider;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.DateRangeFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.NextActivityFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.PageTypeFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.UserFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.contract.PageEditActivityFilter;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.workflow.model.document.activity.SortingOrder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageEditsActivityProvider
extends AbstractPageActivityProvider<VersionHistorySummary> {
    private static final Logger log = LoggerFactory.getLogger(PageEditsActivityProvider.class);
    private final List<PageEditActivityFilter> pageEditActivityFilters;

    public PageEditsActivityProvider(ContentEntityManager contentEntityManager, ActorUtils actorUtils) {
        super(contentEntityManager, actorUtils);
        this.excludingTypes = Arrays.stream(ActionType.Type.values()).filter(type -> !type.equals((Object)ActionType.Type.PAGE)).collect(Collectors.toList());
        this.activityType = ActionType.Type.PAGE;
        this.activitySubtypes = Arrays.asList(ActionType.Subtype.PAGE_CREATED, ActionType.Subtype.PAGE_UPDATED);
        this.pageEditActivityFilters = Arrays.asList(new NextActivityFilter(), new DateRangeFilter(), new PageTypeFilter(), new UserFilter());
    }

    @Override
    protected boolean matchesFilters(VersionHistorySummary version, InternalDocumentActivityQuery query) {
        return this.pageEditActivityFilters.parallelStream().allMatch(filter -> filter.filter(version, query));
    }

    @Override
    public List<Activity> get(InternalDocumentActivityQuery query) {
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Getting confluence page versions activities for this query filters: {0}", query));
        }
        if (!this.shouldApply(query)) {
            log.debug("Confluence page versions provider skipped");
            return Collections.emptyList();
        }
        ContentEntityObject ceo = this.getContent(query);
        Comparator<VersionHistorySummary> sorter = Comparator.comparingLong(entry -> entry.getLastModificationDate().getTime());
        if (SortingOrder.asc != query.getOrder()) {
            sorter = sorter.reversed();
        }
        return ((Stream)this.contentEntityManager.getVersionHistorySummaries(ceo).parallelStream().filter(version -> this.matchesFilters((VersionHistorySummary)version, query)).sequential()).sorted(sorter).limit(query.getLimit() + 5).map(edit -> this.buildPageCreationUpdateActivity((VersionHistorySummary)edit, ceo)).collect(Collectors.toList());
    }

    private Activity buildPageCreationUpdateActivity(VersionHistorySummary historySummary, ContentEntityObject ceo) {
        long moment = historySummary.getLastModificationDate().getTime();
        Set contributors = historySummary.getContributorSet();
        ActionDetails details = new ActionDetails();
        if (historySummary.getVersionComment() != null && !historySummary.getVersionComment().isEmpty()) {
            details.addDetail(ActionDetailType.PAGE_VERSION_COMMENT, historySummary.getVersionComment());
        }
        ActionType.Subtype subtype = historySummary.getVersion() == 1 ? ActionType.Subtype.PAGE_CREATED : ActionType.Subtype.PAGE_UPDATED;
        Action action = new Action(new ActionType(ActionType.Type.PAGE, subtype), this.getActors(contributors), details);
        Long spaceId = ceo instanceof AbstractPage ? Long.valueOf(((AbstractPage)ceo).getSpace().getId()) : null;
        Target target = GenericEventActivityMapper.buildTarget(historySummary.getId(), historySummary.getVersion(), spaceId, null);
        return new Activity(target, moment, action);
    }

    private List<Actor> getActors(Set<ConfluenceUser> contributors) {
        return contributors.isEmpty() ? Collections.singletonList(this.actorUtils.buildAnonymousActor()) : contributors.stream().map(this.actorUtils::buildActor).collect(Collectors.toList());
    }
}

