/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.listener;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.adhoc.notification.model.TaskEventEmail;
import com.comalatech.confluence.nextup.slack.service.WorkflowsEventPublisher;
import com.comalatech.confluence.tasks.event.TaskCreateEvent;
import com.comalatech.confluence.util.FancyDateFormatter;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.event.TaskAssignEvent;
import com.comalatech.workflow.event.TaskCompleteEvent;
import com.comalatech.workflow.event.TaskDueDateExpiredEvent;
import com.comalatech.workflow.event.TaskEvent;
import com.comalatech.workflow.model.Assignment;
import com.comalatech.workflow.model.Task;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.web.util.HtmlUtils;

public class TaskNotificationListener
extends WorkflowsListener {
    protected final WorkflowNotificationConfigManager workflowNotificationConfigManager;
    protected final AdhocNotificationService adhocNotificationService;
    protected final UserAccessor userAccessor;
    protected final NotificationManager notificationManager;
    protected final WorkflowAccessor workflowAccessor;
    protected final StateService stateService;
    protected final WorkflowConfigurationManager workflowConfigurationManager;
    protected final WorkflowsEventPublisher workflowsEventPublisher;

    @EventListener
    public void taskCreate(TaskCreateEvent event) {
        AbstractPage page = (AbstractPage)event.getContent();
        Permission requiredPermission = this.getConfluencePermissionRequired(page);
        com.comalatech.confluence.states.model.Assignment assignment = event.getTask().getCurrentAssignment();
        ConfluenceUser modifier = AuthenticatedUserThreadLocal.get();
        ConfluenceUser assignee = null;
        HashSet<ConfluenceUser> assigneesSet = new HashSet<ConfluenceUser>();
        if (assignment != null) {
            if (TextUtils.stringSet((String)assignment.getAssignee())) {
                assignee = this.userAccessor.getUserByName(assignment.getAssignee());
            }
            if (assignee != null) {
                assigneesSet.add(assignee);
            }
            if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.TASK_ASSIGNMENT, page.getSpaceKey())) {
                TaskEventEmail email = this.createTaskEmail(event.getTask(), page, "com.comalatech.task.notification.create.subject", assignment.getComment());
                email.addContextProperty("assignee", assignee != null ? assignee.getFullName() : "");
                if (event.getTask().getDueDate() != null) {
                    email.addContextProperty("activityDescription", "com.comalatech.task.notification.createAndAssignAndDueDate.assignee.description");
                } else {
                    email.addContextProperty("activityDescription", "com.comalatech.task.notification.createAndAssign.assignee.description");
                }
                this.workflowsEventPublisher.publishSlackNotification(email.getSubject(), email.getBody(), assigneesSet.stream().map(ConfluenceUser::getKey).map(UserKey::getStringValue).collect(Collectors.joining(",")), page);
                this.adhocNotificationService.sendEmail(email, assigneesSet, requiredPermission);
            }
        }
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.TASK_PAGEWATCHER, page.getSpaceKey())) {
            Set<ConfluenceUser> watchers = this.adhocNotificationService.getContentWatchers(page, modifier, true, assigneesSet, null);
            String note = event.getTask().getComment();
            if (assignment != null) {
                note = assignment.getComment();
            }
            TaskEventEmail email = this.createTaskEmail(event.getTask(), page, "com.comalatech.task.notification.create.subject", note);
            email.addContextProperty("assignee", assignee != null ? assignee.getFullName() : "");
            if (assignment != null) {
                if (event.getTask().getDueDate() != null) {
                    email.addContextProperty("activityDescription", "com.comalatech.task.notification.createAndAssignAndDueDate.watcher.description");
                } else {
                    email.addContextProperty("activityDescription", "com.comalatech.task.notification.createAndAssign.watcher.description");
                }
            } else if (event.getTask().getDueDate() != null) {
                email.addContextProperty("activityDescription", "com.comalatech.task.notification.createAndDueDate.watcher.description");
            } else {
                email.addContextProperty("activityDescription", "com.comalatech.task.notification.create.watcher.description");
            }
            this.workflowsEventPublisher.publishSlackNotification(email.getSubject(), email.getBody(), watchers.stream().map(ConfluenceUser::getKey).map(UserKey::getStringValue).collect(Collectors.joining(",")), page);
            this.adhocNotificationService.sendEmail(email, watchers, requiredPermission);
        }
    }

    public TaskNotificationListener(EventPublisher eventPublisher, WorkflowNotificationConfigManager workflowNotificationConfigManager, AdhocNotificationService adhocNotificationService, UserAccessor userAccessor, NotificationManager notificationManager, WorkflowAccessor workflowAccessor, StateService stateService, WorkflowConfigurationManager workflowConfigurationManager, WorkflowsEventPublisher workflowsEventPublisher, DarkFeatureManager darkFeatureManager) {
        super(eventPublisher);
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
        this.adhocNotificationService = adhocNotificationService;
        this.userAccessor = userAccessor;
        this.notificationManager = notificationManager;
        this.workflowAccessor = workflowAccessor;
        this.stateService = stateService;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.workflowsEventPublisher = workflowsEventPublisher;
    }

    @EventListener
    public void taskAssigned(TaskAssignEvent event) {
        if (!event.isAtTaskCreation()) {
            AbstractPage page = (AbstractPage)event.getContent();
            Permission requiredPermission = this.getConfluencePermissionRequired(page);
            ConfluenceUser assignee = null;
            if (TextUtils.stringSet((String)event.getAssignment().getAssignee())) {
                assignee = this.userAccessor.getUserByName(event.getAssignment().getAssignee());
            }
            HashSet<ConfluenceUser> assigneesSet = new HashSet<ConfluenceUser>();
            if (assignee != null) {
                assigneesSet.add(assignee);
            }
            if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.TASK_ASSIGNMENT, page.getSpaceKey())) {
                TaskEventEmail email = this.createTaskEmail(event.getTask(), page, "com.comalatech.task.notification.assigned.subject", event.getAssignment().getComment());
                email.addContextProperty("assignee", assignee != null ? assignee.getFullName() : "");
                if (event.getTask().getDueDate() != null) {
                    email.addContextProperty("activityDescription", "com.comalatech.task.notification.assignedAndDueDate.description");
                } else {
                    email.addContextProperty("activityDescription", "com.comalatech.task.notification.assigned.description");
                }
                this.workflowsEventPublisher.publishSlackNotification(email.getSubject(), email.getBody(), assignee.getKey().getStringValue(), page);
                this.adhocNotificationService.sendEmail(email, assigneesSet, requiredPermission);
            }
            if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.TASK_PAGEWATCHER, page.getSpaceKey())) {
                Assignment previousAssignment;
                ConfluenceUser modifier = AuthenticatedUserThreadLocal.get();
                List<? extends Assignment> previousAssignments = event.getTask().getAssignments();
                ConfluenceUser previousAssignee = null;
                if (previousAssignments != null && previousAssignments.size() > 1 && TextUtils.stringSet((String)(previousAssignment = previousAssignments.get(previousAssignments.size() - 2)).getAssignee())) {
                    previousAssignee = this.userAccessor.getUserByName(previousAssignment.getAssignee());
                }
                Set<ConfluenceUser> watchers = this.adhocNotificationService.getContentWatchers(page, modifier, true, assigneesSet, Collections.singleton(previousAssignee));
                TaskEventEmail email = this.createTaskEmail(event.getTask(), page, "com.comalatech.task.notification.assigned.watcher.subject", event.getAssignment().getComment());
                email.addContextProperty("assignee", assignee != null ? assignee.getFullName() : "");
                if (event.getTask().getDueDate() != null) {
                    email.addContextProperty("activityDescription", "com.comalatech.task.notification.assignedAndDueDate.watcher.description");
                } else {
                    email.addContextProperty("activityDescription", "com.comalatech.task.notification.assigned.watcher.description");
                }
                this.workflowsEventPublisher.publishSlackNotification(email.getSubject(), email.getBody(), watchers.stream().map(ConfluenceUser::getKey).map(UserKey::getStringValue).collect(Collectors.joining(",")), page);
                this.adhocNotificationService.sendEmail(email, watchers, requiredPermission);
            }
        }
    }

    @EventListener
    public void taskCompleted(TaskCompleteEvent event) {
        ConfluenceUser modifier = AuthenticatedUserThreadLocal.get();
        AbstractPage page = (AbstractPage)event.getContent();
        Permission requiredPermission = this.getConfluencePermissionRequired(page);
        TaskEventEmail email = this.createTaskEmail(event.getTask(), page, "com.comalatech.task.notification.complete.watcher.subject", event.getCompletion().getComment());
        email.addContextProperty("completer", modifier != null ? modifier.getFullName() : "");
        email.addContextProperty("activityDescription", "com.comalatech.task.notification.complete.watcher.description");
        Set<ConfluenceUser> emailUsers = this.getEmailUserForCommonEventEmail(page, event, modifier);
        this.workflowsEventPublisher.publishSlackNotification(email.getSubject(), email.getBody(), emailUsers.stream().map(ConfluenceUser::getKey).map(UserKey::getStringValue).collect(Collectors.joining(",")), page);
        this.adhocNotificationService.sendEmail(email, emailUsers, requiredPermission);
    }

    @EventListener
    public void taskExpired(TaskDueDateExpiredEvent event) {
        AbstractPage page = (AbstractPage)event.getContent();
        Permission requiredPermission = this.getConfluencePermissionRequired(page);
        String message = event.getTask().getComment() != null ? event.getTask().getComment() : "";
        TaskEventEmail email = this.createTaskEmail(event.getTask(), page, "com.comalatech.task.notification.expired.watcher.subject", message);
        email.addContextProperty("activityDescription", "com.comalatech.task.notification.expired.watcher.description");
        Set<ConfluenceUser> emailUsers = this.getEmailUserForCommonEventEmail(page, event, null);
        this.workflowsEventPublisher.publishSlackNotification(email.getSubject(), email.getBody(), emailUsers.stream().map(ConfluenceUser::getKey).map(UserKey::getStringValue).collect(Collectors.joining(",")), page);
        this.adhocNotificationService.sendEmail(email, emailUsers, requiredPermission);
    }

    protected Set<ConfluenceUser> getEmailUserForCommonEventEmail(AbstractPage page, TaskEvent event, ConfluenceUser modifier) {
        Assignment assignment;
        HashSet<ConfluenceUser> emailUsers = new HashSet<ConfluenceUser>();
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.TASK_ASSIGNMENT, page.getSpaceKey()) && (assignment = event.getTask().getLastAssignment()) != null && TextUtils.stringSet((String)assignment.getAssignee())) {
            emailUsers.add(this.userAccessor.getUserByName(assignment.getAssignee()));
        }
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.TASK_PAGEWATCHER, page.getSpaceKey())) {
            emailUsers.addAll(this.adhocNotificationService.getContentWatchers(page, modifier, true, null, null));
        }
        return emailUsers;
    }

    protected TaskEventEmail createTaskEmail(Task task, AbstractPage page, String subjectI18n, String note) {
        TaskEventEmail email = new TaskEventEmail(subjectI18n);
        email.setEntityId(page.getId());
        email.addContextProperty("taskName", task.getName());
        email.addContextProperty("assignmentNoteHtml", TextUtils.stringSet((String)note) ? HtmlUtils.htmlEscape((String)note) : "");
        email.addContextProperty("taskId", task.getActivityId());
        if (task.getDueDate() != null) {
            email.addContextProperty("dueDate", FancyDateFormatter.decorateDateTimePretty(task.getDueDate(), false));
        }
        return email;
    }

    protected Permission getConfluencePermissionRequired(AbstractPage page) {
        WorkflowVisibilityInternal visibility;
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows != null && pageWorkflows.isRequiresFinalApproval() && !this.stateService.getCurrentState((ContentEntityObject)page).isPublished() && WorkflowVisibilityInternal.CONTRIBUTORS == (visibility = this.workflowConfigurationManager.getHistoryVisibility(page.getSpaceKey()))) {
            return Permission.EDIT;
        }
        return Permission.VIEW;
    }
}

