/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.listener;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.ApprovalAssignedEventEmail;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.nextup.slack.service.WorkflowsEventPublisher;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.events.BlogPostApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalAssignedEvent;
import com.comalatech.workflow.event.approval.ApprovalAssignedEvent;
import com.opensymphony.util.TextUtils;
import java.util.HashSet;
import org.springframework.web.util.HtmlUtils;

public class ApprovalNotificationListener
extends WorkflowsListener {
    protected final WorkflowNotificationConfigManager workflowNotificationConfigManager;
    protected final AdhocNotificationService adhocNotificationService;
    protected final UserAccessor userAccessor;
    protected final WorkflowsEventPublisher workflowsEventPublisher;
    protected final DarkFeatureManager darkFeatureManager;

    public ApprovalNotificationListener(EventPublisher eventPublisher, WorkflowNotificationConfigManager workflowNotificationConfigManager, AdhocNotificationService adhocNotificationService, UserAccessor userAccessor, WorkflowsEventPublisher workflowsEventPublisher, DarkFeatureManager darkFeatureManager) {
        super(eventPublisher);
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
        this.adhocNotificationService = adhocNotificationService;
        this.userAccessor = userAccessor;
        this.workflowsEventPublisher = workflowsEventPublisher;
        this.darkFeatureManager = darkFeatureManager;
    }

    @EventListener
    public void pageApprovalAssignedEvent(PageApprovalAssignedEvent event) {
        this.processAssignedEvent(event);
    }

    @EventListener
    public void blogPostApprovalAssignedEvent(BlogPostApprovalAssignedEvent event) {
        this.processAssignedEvent(event);
    }

    protected void processAssignedEvent(ApprovalAssignedEvent event) {
        AbstractPage page = (AbstractPage)event.getContent();
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.APPROVAL_ASSIGNMENT, page.getSpaceKey())) {
            String assignee = event.getAssignment().getAssignee();
            ConfluenceUser assigneeUser = null;
            String assigneeKey = null;
            if (TextUtils.stringSet((String)assignee)) {
                assigneeUser = this.userAccessor.getUserByName(assignee);
                assigneeKey = assigneeUser.getKey().getStringValue();
            }
            ApprovalAssignedEventEmail email = this.composeEmail(page, event, assigneeUser);
            this.workflowsEventPublisher.publishSlackNotification(email.getSubject(), email.getBody(), assigneeKey, page);
            HashSet<ConfluenceUser> emailsTo = new HashSet<ConfluenceUser>();
            emailsTo.add(assigneeUser);
            this.adhocNotificationService.sendEmail(email, emailsTo);
        }
    }

    private ApprovalAssignedEventEmail composeEmail(AbstractPage page, ApprovalAssignedEvent event, ConfluenceUser assigneeUser) {
        ApprovalAssignedEventEmail email = new ApprovalAssignedEventEmail();
        email.setEntityId(page.getId());
        email.addContextProperty("approvalName", event.getApprovalName());
        email.addContextProperty("assignee", assigneeUser);
        email.addContextProperty("pageTitle", page.getTitle());
        String comment = event.getAssignment().getComment();
        email.addContextProperty("assignmentNoteHtml", TextUtils.stringSet((String)comment) ? HtmlUtils.htmlEscape((String)comment) : "");
        return email;
    }
}

